/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.library.metrics;

import com.tngtech.archunit.PublicAPI;
import com.tngtech.archunit.base.ForwardingCollection;
import com.tngtech.archunit.thirdparty.com.google.common.base.MoreObjects;
import com.tngtech.archunit.thirdparty.com.google.common.base.Preconditions;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Set;

@PublicAPI(usage=PublicAPI.Usage.ACCESS)
public final class MetricsComponent<T>
extends ForwardingCollection<T> {
    private final String identifier;
    private final Set<T> elements;

    private MetricsComponent(String identifier, Collection<T> elements) {
        this.identifier = Preconditions.checkNotNull(identifier, "identifier must not be null");
        this.elements = ImmutableSet.copyOf(elements);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public String getIdentifier() {
        return this.identifier;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<T> getElements() {
        return this.elements;
    }

    @Override
    protected Collection<T> delegate() {
        return this.elements;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this).add("identifier", this.identifier).toString();
    }

    @SafeVarargs
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static <T> MetricsComponent<T> of(String identifier, T ... elements) {
        return new MetricsComponent<T>(identifier, ImmutableSet.copyOf(elements));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static <T> MetricsComponent<T> of(String identifier, Collection<T> elements) {
        return new MetricsComponent<T>(identifier, elements);
    }
}

