﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/firehose/Firehose_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace Firehose {
namespace Model {

/**
 * <p>Describes the metadata that's delivered to the specified HTTP endpoint
 * destination.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/firehose-2015-08-04/HttpEndpointCommonAttribute">AWS
 * API Reference</a></p>
 */
class HttpEndpointCommonAttribute {
 public:
  AWS_FIREHOSE_API HttpEndpointCommonAttribute() = default;
  AWS_FIREHOSE_API HttpEndpointCommonAttribute(Aws::Utils::Json::JsonView jsonValue);
  AWS_FIREHOSE_API HttpEndpointCommonAttribute& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_FIREHOSE_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The name of the HTTP endpoint common attribute.</p>
   */
  inline const Aws::String& GetAttributeName() const { return m_attributeName; }
  inline bool AttributeNameHasBeenSet() const { return m_attributeNameHasBeenSet; }
  template <typename AttributeNameT = Aws::String>
  void SetAttributeName(AttributeNameT&& value) {
    m_attributeNameHasBeenSet = true;
    m_attributeName = std::forward<AttributeNameT>(value);
  }
  template <typename AttributeNameT = Aws::String>
  HttpEndpointCommonAttribute& WithAttributeName(AttributeNameT&& value) {
    SetAttributeName(std::forward<AttributeNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The value of the HTTP endpoint common attribute.</p>
   */
  inline const Aws::String& GetAttributeValue() const { return m_attributeValue; }
  inline bool AttributeValueHasBeenSet() const { return m_attributeValueHasBeenSet; }
  template <typename AttributeValueT = Aws::String>
  void SetAttributeValue(AttributeValueT&& value) {
    m_attributeValueHasBeenSet = true;
    m_attributeValue = std::forward<AttributeValueT>(value);
  }
  template <typename AttributeValueT = Aws::String>
  HttpEndpointCommonAttribute& WithAttributeValue(AttributeValueT&& value) {
    SetAttributeValue(std::forward<AttributeValueT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_attributeName;
  bool m_attributeNameHasBeenSet = false;

  Aws::String m_attributeValue;
  bool m_attributeValueHasBeenSet = false;
};

}  // namespace Model
}  // namespace Firehose
}  // namespace Aws
