/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceInternal;

import com.zeroc.Ice.Communicator;
import com.zeroc.Ice.EncodingVersion;
import com.zeroc.Ice.EndpointSelectionType;
import com.zeroc.Ice.Logger;
import com.zeroc.Ice.Properties;
import com.zeroc.IceInternal.BufSizeWarnInfo;
import com.zeroc.IceInternal.EndpointFactory;
import com.zeroc.IceInternal.EndpointI_connectors;
import com.zeroc.IceInternal.IPEndpointI;
import com.zeroc.IceInternal.Instance;
import com.zeroc.IceInternal.NetworkProxy;
import com.zeroc.IceInternal.Util;
import java.net.InetSocketAddress;

public class ProtocolInstance {
    protected Instance _instance;
    protected int _traceLevel;
    protected String _traceCategory;
    protected Logger _logger;
    protected Properties _properties;
    protected String _protocol;
    protected short _type;
    protected boolean _secure;

    public ProtocolInstance(Communicator communicator, short type, String protocol, boolean secure) {
        this._instance = Util.getInstance(communicator);
        this._traceLevel = this._instance.traceLevels().network;
        this._traceCategory = this._instance.traceLevels().networkCat;
        this._logger = this._instance.initializationData().logger;
        this._properties = this._instance.initializationData().properties;
        this._type = type;
        this._protocol = protocol;
        this._secure = secure;
    }

    public int traceLevel() {
        return this._traceLevel;
    }

    public String traceCategory() {
        return this._traceCategory;
    }

    public Logger logger() {
        return this._logger;
    }

    public EndpointFactory getEndpointFactory(short type) {
        return this._instance.endpointFactoryManager().get(type);
    }

    public String protocol() {
        return this._protocol;
    }

    public short type() {
        return this._type;
    }

    public boolean secure() {
        return this._secure;
    }

    public Properties properties() {
        return this._properties;
    }

    public boolean preferIPv6() {
        return this._instance.preferIPv6();
    }

    public int protocolSupport() {
        return this._instance.protocolSupport();
    }

    public String defaultHost() {
        return this._instance.defaultsAndOverrides().defaultHost;
    }

    public InetSocketAddress defaultSourceAddress() {
        return this._instance.defaultsAndOverrides().defaultSourceAddress;
    }

    public EncodingVersion defaultEncoding() {
        return this._instance.defaultsAndOverrides().defaultEncoding;
    }

    public int defaultTimeout() {
        return this._instance.defaultsAndOverrides().defaultTimeout;
    }

    public NetworkProxy networkProxy() {
        return this._instance.networkProxy();
    }

    public int messageSizeMax() {
        return this._instance.messageSizeMax();
    }

    public void resolve(String host, int port, EndpointSelectionType type, IPEndpointI endpt, EndpointI_connectors callback) {
        this._instance.endpointHostResolver().resolve(host, port, type, endpt, callback);
    }

    public BufSizeWarnInfo getBufSizeWarn(short type) {
        return this._instance.getBufSizeWarn(type);
    }

    public void setSndBufSizeWarn(short type, int size) {
        this._instance.setSndBufSizeWarn(type, size);
    }

    public void setRcvBufSizeWarn(short type, int size) {
        this._instance.setRcvBufSizeWarn(type, size);
    }

    ProtocolInstance(Instance instance, short type, String protocol, boolean secure) {
        this._instance = instance;
        this._traceLevel = this._instance.traceLevels().network;
        this._traceCategory = this._instance.traceLevels().networkCat;
        this._logger = this._instance.initializationData().logger;
        this._properties = this._instance.initializationData().properties;
        this._type = type;
        this._protocol = protocol;
        this._secure = secure;
    }
}

