/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.ui.swing;

import java.awt.Component;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;
import org.graalvm.visualvm.lib.ui.UIUtils;

public class ProfilerPopupMenu
extends JPopupMenu {
    private boolean forceBackground;

    public ProfilerPopupMenu() {
    }

    public ProfilerPopupMenu(String label) {
        super(label);
    }

    @Override
    public JMenuItem add(JMenuItem menuItem) {
        if (this.forceBackground && !UIUtils.isOracleLookAndFeel()) {
            menuItem.setOpaque(false);
        }
        if (this.forceBackground && !UIUtils.isNimbusLookAndFeel()) {
            menuItem.setForeground(this.getForeground());
        }
        return super.add(menuItem);
    }

    @Override
    public void add(Component comp, Object constraints) {
        if (this.forceBackground && !UIUtils.isOracleLookAndFeel() && comp instanceof JComponent) {
            ((JComponent)comp).setOpaque(false);
        }
        if (this.forceBackground && !UIUtils.isNimbusLookAndFeel()) {
            comp.setForeground(this.getForeground());
        }
        comp.setMinimumSize(comp.getPreferredSize());
        super.add(comp, constraints);
    }

    public void setForceBackground(boolean force) {
        if (!UIUtils.isNimbus() || !Boolean.TRUE.equals(UIManager.getBoolean("nb.dark.theme"))) {
            this.forceBackground = force;
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.forceBackground) {
            g.setColor(this.getBackground());
            g.fillRect(1, 1, this.getWidth() - 2, this.getHeight() - 2);
        }
    }
}

