# Tongan

## Introduction

As in all Polynesian star lore, Tongan sky culture descends from the practical application of nautical navigation.

## Description

In some circumstances separation of individual star names from &quot;star path&quot; names cannot be resolved. A star may have multiple names 1) if the star is part of numerous star paths and 2) since the naming of stars can differ depending on which Tongan island group it originates from. The nomenclature of stars is approximated based on the limited resources available.

Whilst the most-notable/common stars and constellations (i.e. Orion, Pleiades, Crux) are identified in Tongan star lore there are two notable exceptions. There is an absence of naming of the North star (Polaris: &alpha; UMi). This is peculiar considering the latitude of the Tongan islands and the prominence of this star at certain times of the year. In the event of any northerly journeys from Tonga such an important navigational landmark could not have possibly gone unnoticed. The constellation of Scorpio (parts in, or stars of) are also absent from Tongan star lore. This is surprising since the vast majority of star lore &ndash; globally and Polynesian &ndash; has Scorpio as a central constellation due to it being easily identified and that it is nearly directly opposite Orion in the night sky. [Stellarium would welcome any further knowledge on these two anomalies.]

Common ancestry of Polynesian star lore's is evident in the similarities in the labelling of stars. For example the Pleiades is called Mataliki in Tongan, Matariki in Maori and Makali`i in Hawaiian.

### Nomenclature

|Tongan term|Designation|
|-----------|-----------|
|Humu|Coal sack|
|Kaniva|Milky Way|
|Ma'afulele|Large Magellan cloud|
|Ma'afutoka|Small Magellan cloud|
|'otu Ma'afu|Magellanic clouds (both)|
|Ha'amonga|Ecliptic|
|Mahina|Moon|
|La'a|Sun|
|Fetu'u|Star (in general)|
|Fetu'ufuka|Comet|
|'Umata|Rainbow|
|Fetu'u'Esiafi|Falling star|
|tapukitea|Venus|
|Matamemea|Mars|
|Ma'afutoka (same as SMC)|Canopus|
|Ma'afulele (same as LMC)|Sirius|
|Velitoa hififo|Rigel|
|Velitoa hahake|Betelgeuse|
|Hikule'o|Arcturus|
|Monuafe|Meissa|
|Motuliki|Pleiades|
|Tu'ulalupe|Hyades|
|Toloatonga|Southern Cross|
|Toloalahi|False Cross|

**Tongan constellations**

|Tongan name|Designation or notes|
|-----------|--------------------|
|Tuinga ika|Part of Orion, belt and sword|
|Ae e'Uvea|Corona Borealis (*Speculative*)|
|Fatanalua|Coma Berenices (*Speculative*)|
|Kapakau'o'tafahi|Cassiopeia (*Speculative*)|
|Toloa|Belt of Orion|
|Lua tangata|Castor and/or Pollux|
|Fungasia|Toliman and/or Agena|
|Houmatoloa (Toloa, toloatonga, toloalahi)|&mdash;|

## References

 - [#1]: Velt Kik, *Ko E Ngaahi fetu'u 'o, Stars over tonga*, 1990 'Atenisi University, Nuku'alofa, Tonga Government printing department.
 - [#2]: T.H Fale, *Tongan astronomy*, 1990 Polynesian Eyes foundation, Nuku'alofa, Tonga Choice printing.
 - [#3]: E. E. V. Collocott, *Tongan astronomy and calendar*, 1992 Occasional Papers of the Bernice Pauahi Bishop Museum of Polynesian ethnology and Natural History, Vol.8, No. 4 Honolulu, Hawaii, Bishop Museum Press 1922, p. 157-173.

## Authors

This sky culture was contributed by Stellarium user *Dan Smale*, smaledaniel(at)outlook.com

## License

CC BY-SA 4.0
