/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.ssl.util;

import io.netty.buffer.ByteBuf;
import java.nio.ByteOrder;

public class TLSUtil {
    private static final int SSL_CONTENT_TYPE_CHANGE_CIPHER_SPEC = 20;
    private static final int SSL_CONTENT_TYPE_ALERT = 21;
    private static final int SSL_CONTENT_TYPE_HANDSHAKE = 22;
    private static final int SSL_CONTENT_TYPE_APPLICATION_DATA = 23;
    private static final int SSL_CONTENT_TYPE_EXTENSION_HEARTBEAT = 24;
    private static final int SSL_RECORD_HEADER_LENGTH = 5;

    private TLSUtil() {
    }

    public static boolean isTLS(ByteBuf buffer) {
        int packetLength = 0;
        int offset = buffer.readerIndex();
        boolean tls = switch (buffer.getUnsignedByte(offset)) {
            case 20, 21, 22, 23, 24 -> true;
            default -> false;
        };
        if (tls) {
            short majorVersion = buffer.getUnsignedByte(offset + 1);
            if (majorVersion == 3) {
                packetLength = TLSUtil.unsignedShortBE(buffer, offset + 3) + 5;
                if (packetLength <= 5) {
                    tls = false;
                }
            } else {
                tls = false;
            }
        }
        return tls;
    }

    private static int unsignedShortBE(ByteBuf buffer, int offset) {
        return buffer.order() == ByteOrder.BIG_ENDIAN ? buffer.getUnsignedShort(offset) : buffer.getUnsignedShortLE(offset);
    }
}

