/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.ssl.transport;

import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.stream.Collectors;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.security.auth.x500.X500Principal;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.SpecialPermission;
import org.opensearch.security.ssl.transport.PrincipalExtractor;

public class DefaultPrincipalExtractor
implements PrincipalExtractor {
    protected final Logger log = LogManager.getLogger(this.getClass());

    @Override
    public String extractPrincipal(final X509Certificate x509Certificate, PrincipalExtractor.Type type) {
        if (x509Certificate == null) {
            return null;
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new SpecialPermission());
        }
        String dnString = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                X500Principal principal = x509Certificate.getSubjectX500Principal();
                return principal.toString();
            }
        });
        try {
            LdapName ln = new LdapName(dnString);
            ArrayList<Rdn> rdns = new ArrayList<Rdn>(ln.getRdns());
            Collections.reverse(rdns);
            dnString = String.join((CharSequence)",", rdns.stream().map(r -> r.toString()).collect(Collectors.toList()));
        }
        catch (InvalidNameException e) {
            this.log.error("Unable to parse: {}", (Object)dnString, (Object)e);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("principal: {}", (Object)dnString);
        }
        return dnString;
    }
}

