/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.logic;

import java.io.IOException;
import java.io.InputStream;
import java.util.function.BiPredicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.script.ScriptContext;
import javax.script.ScriptException;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.collection.Pair;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.resource.Resource;
import net.shibboleth.shared.scripting.AbstractScriptEvaluator;
import net.shibboleth.shared.scripting.EvaluableScript;
import org.slf4j.Logger;

public class ScriptedBiPredicate<T, U>
extends AbstractScriptEvaluator
implements BiPredicate<T, U> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ScriptedBiPredicate.class);
    @Nullable
    private Pair<Class<T>, Class<U>> inputTypes;

    protected ScriptedBiPredicate(@Nonnull @NotEmpty EvaluableScript theScript, @Nullable @NotEmpty String extraInfo) {
        super(theScript);
        this.setOutputType(Boolean.class);
        this.setReturnOnError(false);
        this.setLogPrefix("Scripted BiPredicate from " + extraInfo + ":");
    }

    protected ScriptedBiPredicate(@Nonnull @NotEmpty EvaluableScript theScript) {
        super(theScript);
        this.setOutputType(Boolean.class);
        this.setReturnOnError(false);
        this.setLogPrefix("Anonymous BiPredicate:");
    }

    @Nullable
    public Pair<Class<T>, Class<U>> getInputTypes() {
        return this.inputTypes;
    }

    public void setInputTypes(@Nullable Pair<Class<T>, Class<U>> types) {
        this.inputTypes = types != null && types.getFirst() != null && types.getSecond() != null ? types : null;
    }

    public void setReturnOnError(boolean flag) {
        this.setReturnOnError((Object)flag);
    }

    @Override
    public boolean test(@Nullable T first, @Nullable U second) {
        Object result;
        Pair<Class<T>, Class<U>> types = this.getInputTypes();
        if (null != types) {
            Class<T> intype1 = types.getFirst();
            Class<U> intype2 = types.getSecond();
            if (null != first && null != intype1 && !intype1.isInstance(first)) {
                this.log.error("{} Input of type {} was not of type {}", new Object[]{this.getLogPrefix(), first.getClass(), intype1});
                return this.returnError();
            }
            if (null != second && null != intype2 && !intype2.isInstance(second)) {
                this.log.error("{} Input of type {} was not of type {}", new Object[]{this.getLogPrefix(), second.getClass(), intype2});
                return this.returnError();
            }
        }
        return (Boolean)((result = this.evaluate(first, second)) != null ? result : Boolean.valueOf(this.returnError()));
    }

    private boolean returnError() throws ClassCastException {
        Object ret = this.getReturnOnError();
        if (ret instanceof Boolean) {
            return (Boolean)ret;
        }
        throw new ClassCastException("Unable to cast return value to a boolean");
    }

    @Override
    protected void prepareContext(@Nonnull ScriptContext scriptContext, Object ... input) {
        scriptContext.setAttribute("input1", input != null ? input[0] : null, 100);
        scriptContext.setAttribute("input2", input != null ? input[1] : null, 100);
    }

    @Nonnull
    public static <T, U> ScriptedBiPredicate<T, U> resourceScript(@Nonnull @ParameterName(name="engineName") @NotEmpty String engineName, @Nonnull @ParameterName(name="resource") Resource resource) throws ScriptException, IOException, ComponentInitializationException {
        try (InputStream is = resource.getInputStream();){
            EvaluableScript script = new EvaluableScript();
            script.setEngineName(engineName);
            script.setScript(is);
            script.initialize();
            ScriptedBiPredicate<T, U> scriptedBiPredicate = new ScriptedBiPredicate<T, U>(script, resource.getDescription());
            return scriptedBiPredicate;
        }
    }

    @Nonnull
    public static <T, U> ScriptedBiPredicate<T, U> resourceScript(@Nonnull @ParameterName(name="resource") Resource resource) throws ScriptException, IOException, ComponentInitializationException {
        return ScriptedBiPredicate.resourceScript("JavaScript", resource);
    }

    @Nonnull
    public static <T, U> ScriptedBiPredicate<T, U> inlineScript(@Nonnull @ParameterName(name="engineName") @NotEmpty String engineName, @Nonnull @ParameterName(name="scriptSource") @NotEmpty String scriptSource) throws ScriptException, ComponentInitializationException {
        EvaluableScript script = new EvaluableScript();
        script.setEngineName(engineName);
        script.setScript(scriptSource);
        script.initialize();
        return new ScriptedBiPredicate<T, U>(script, "Inline");
    }

    @Nonnull
    public static <T, U> ScriptedBiPredicate<T, U> inlineScript(@Nonnull @ParameterName(name="scriptSource") @NotEmpty String scriptSource) throws ScriptException, ComponentInitializationException {
        EvaluableScript script = new EvaluableScript();
        script.setScript(scriptSource);
        script.initialize();
        return new ScriptedBiPredicate<T, U>(script, "Inline");
    }
}

