/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.nodes.stats;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch.nodes.stats.ShardSearchPipelineOperationStats;
import org.opensearch.client.opensearch.nodes.stats.ShardSearchPipelinePerPipelineProcessorStats;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class ShardSearchPipelinePerPipelineStats
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, ShardSearchPipelinePerPipelineStats> {
    @Nullable
    private final ShardSearchPipelineOperationStats request;
    @Nonnull
    private final List<ShardSearchPipelinePerPipelineProcessorStats> requestProcessors;
    @Nullable
    private final ShardSearchPipelineOperationStats response;
    @Nonnull
    private final List<ShardSearchPipelinePerPipelineProcessorStats> responseProcessors;
    public static final JsonpDeserializer<ShardSearchPipelinePerPipelineStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ShardSearchPipelinePerPipelineStats::setupShardSearchPipelinePerPipelineStatsDeserializer);

    private ShardSearchPipelinePerPipelineStats(Builder builder) {
        this.request = builder.request;
        this.requestProcessors = ApiTypeHelper.unmodifiable(builder.requestProcessors);
        this.response = builder.response;
        this.responseProcessors = ApiTypeHelper.unmodifiable(builder.responseProcessors);
    }

    public static ShardSearchPipelinePerPipelineStats of(Function<Builder, ObjectBuilder<ShardSearchPipelinePerPipelineStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final ShardSearchPipelineOperationStats request() {
        return this.request;
    }

    @Nonnull
    public final List<ShardSearchPipelinePerPipelineProcessorStats> requestProcessors() {
        return this.requestProcessors;
    }

    @Nullable
    public final ShardSearchPipelineOperationStats response() {
        return this.response;
    }

    @Nonnull
    public final List<ShardSearchPipelinePerPipelineProcessorStats> responseProcessors() {
        return this.responseProcessors;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.request != null) {
            generator.writeKey("request");
            this.request.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.requestProcessors)) {
            generator.writeKey("request_processors");
            generator.writeStartArray();
            for (ShardSearchPipelinePerPipelineProcessorStats item0 : this.requestProcessors) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.response != null) {
            generator.writeKey("response");
            this.response.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.responseProcessors)) {
            generator.writeKey("response_processors");
            generator.writeStartArray();
            for (ShardSearchPipelinePerPipelineProcessorStats item0 : this.responseProcessors) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupShardSearchPipelinePerPipelineStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::request, ShardSearchPipelineOperationStats._DESERIALIZER, "request");
        op.add(Builder::requestProcessors, JsonpDeserializer.arrayDeserializer(ShardSearchPipelinePerPipelineProcessorStats._DESERIALIZER), "request_processors");
        op.add(Builder::response, ShardSearchPipelineOperationStats._DESERIALIZER, "response");
        op.add(Builder::responseProcessors, JsonpDeserializer.arrayDeserializer(ShardSearchPipelinePerPipelineProcessorStats._DESERIALIZER), "response_processors");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.request);
        result = 31 * result + Objects.hashCode(this.requestProcessors);
        result = 31 * result + Objects.hashCode(this.response);
        result = 31 * result + Objects.hashCode(this.responseProcessors);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShardSearchPipelinePerPipelineStats other = (ShardSearchPipelinePerPipelineStats)o;
        return Objects.equals(this.request, other.request) && Objects.equals(this.requestProcessors, other.requestProcessors) && Objects.equals(this.response, other.response) && Objects.equals(this.responseProcessors, other.responseProcessors);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, ShardSearchPipelinePerPipelineStats> {
        @Nullable
        private ShardSearchPipelineOperationStats request;
        @Nullable
        private List<ShardSearchPipelinePerPipelineProcessorStats> requestProcessors;
        @Nullable
        private ShardSearchPipelineOperationStats response;
        @Nullable
        private List<ShardSearchPipelinePerPipelineProcessorStats> responseProcessors;

        public Builder() {
        }

        private Builder(ShardSearchPipelinePerPipelineStats o) {
            this.request = o.request;
            this.requestProcessors = Builder._listCopy(o.requestProcessors);
            this.response = o.response;
            this.responseProcessors = Builder._listCopy(o.responseProcessors);
        }

        private Builder(Builder o) {
            this.request = o.request;
            this.requestProcessors = Builder._listCopy(o.requestProcessors);
            this.response = o.response;
            this.responseProcessors = Builder._listCopy(o.responseProcessors);
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder request(@Nullable ShardSearchPipelineOperationStats value) {
            this.request = value;
            return this;
        }

        @Nonnull
        public final Builder request(Function<ShardSearchPipelineOperationStats.Builder, ObjectBuilder<ShardSearchPipelineOperationStats>> fn) {
            return this.request(fn.apply(new ShardSearchPipelineOperationStats.Builder()).build());
        }

        @Nonnull
        public final Builder requestProcessors(List<ShardSearchPipelinePerPipelineProcessorStats> list) {
            this.requestProcessors = Builder._listAddAll(this.requestProcessors, list);
            return this;
        }

        @Nonnull
        public final Builder requestProcessors(ShardSearchPipelinePerPipelineProcessorStats value, ShardSearchPipelinePerPipelineProcessorStats ... values) {
            this.requestProcessors = Builder._listAdd(this.requestProcessors, value, values);
            return this;
        }

        @Nonnull
        public final Builder requestProcessors(Function<ShardSearchPipelinePerPipelineProcessorStats.Builder, ObjectBuilder<ShardSearchPipelinePerPipelineProcessorStats>> fn) {
            return this.requestProcessors(fn.apply(new ShardSearchPipelinePerPipelineProcessorStats.Builder()).build(), new ShardSearchPipelinePerPipelineProcessorStats[0]);
        }

        @Nonnull
        public final Builder response(@Nullable ShardSearchPipelineOperationStats value) {
            this.response = value;
            return this;
        }

        @Nonnull
        public final Builder response(Function<ShardSearchPipelineOperationStats.Builder, ObjectBuilder<ShardSearchPipelineOperationStats>> fn) {
            return this.response(fn.apply(new ShardSearchPipelineOperationStats.Builder()).build());
        }

        @Nonnull
        public final Builder responseProcessors(List<ShardSearchPipelinePerPipelineProcessorStats> list) {
            this.responseProcessors = Builder._listAddAll(this.responseProcessors, list);
            return this;
        }

        @Nonnull
        public final Builder responseProcessors(ShardSearchPipelinePerPipelineProcessorStats value, ShardSearchPipelinePerPipelineProcessorStats ... values) {
            this.responseProcessors = Builder._listAdd(this.responseProcessors, value, values);
            return this;
        }

        @Nonnull
        public final Builder responseProcessors(Function<ShardSearchPipelinePerPipelineProcessorStats.Builder, ObjectBuilder<ShardSearchPipelinePerPipelineProcessorStats>> fn) {
            return this.responseProcessors(fn.apply(new ShardSearchPipelinePerPipelineProcessorStats.Builder()).build(), new ShardSearchPipelinePerPipelineProcessorStats[0]);
        }

        @Override
        @Nonnull
        public ShardSearchPipelinePerPipelineStats build() {
            this._checkSingleUse();
            return new ShardSearchPipelinePerPipelineStats(this);
        }
    }
}

