/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.memory;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import lombok.Generated;
import org.opensearch.common.concurrent.RefCountedReleasable;
import org.opensearch.knn.common.featureflags.KNNFeatureFlags;
import org.opensearch.knn.index.VectorDataType;
import org.opensearch.knn.index.engine.KNNEngine;
import org.opensearch.knn.index.engine.qframe.QuantizationConfig;
import org.opensearch.knn.index.memory.SharedIndexState;
import org.opensearch.knn.index.memory.SharedIndexStateManager;
import org.opensearch.knn.jni.JNIService;

public interface NativeMemoryAllocation {
    public void close();

    public boolean isClosed();

    public long getMemoryAddress();

    public void readLock();

    public void writeLock();

    public void readUnlock();

    public void writeUnlock();

    public int getSizeInKB();

    default public void incRef() {
    }

    default public boolean decRef() {
        return true;
    }

    public static class AnonymousAllocation
    implements NativeMemoryAllocation {
        private final ExecutorService executor;
        private volatile boolean closed;
        private final int size;
        private final ReadWriteLock readWriteLock;

        AnonymousAllocation(ExecutorService executor, int size) {
            this.executor = executor;
            this.closed = false;
            this.size = size;
            this.readWriteLock = new ReentrantReadWriteLock();
        }

        @Override
        public void close() {
            if (this.isClosed()) {
                return;
            }
            this.executor.execute(() -> {
                this.writeLock();
                this.closed = true;
                this.writeUnlock();
            });
        }

        @Override
        public boolean isClosed() {
            return this.closed;
        }

        @Override
        public long getMemoryAddress() {
            throw new UnsupportedOperationException("Cannot get memory address for an AnonymousAllocation.");
        }

        @Override
        public void readLock() {
            this.readWriteLock.readLock().lock();
        }

        @Override
        public void writeLock() {
            this.readWriteLock.writeLock().lock();
        }

        @Override
        public void readUnlock() {
            this.readWriteLock.readLock().unlock();
        }

        @Override
        public void writeUnlock() {
            this.readWriteLock.writeLock().unlock();
        }

        @Override
        public int getSizeInKB() {
            return this.size;
        }
    }

    public static class TrainingDataAllocation
    implements NativeMemoryAllocation {
        private final ExecutorService executor;
        private volatile boolean closed;
        private long memoryAddress;
        private final int sizeKb;
        private QuantizationConfig quantizationConfig = QuantizationConfig.EMPTY;
        private int readCount;
        private final Semaphore readSemaphore;
        private final Semaphore writeSemaphore;
        private final VectorDataType vectorDataType;

        public TrainingDataAllocation(ExecutorService executor, long memoryAddress, int sizeKb, VectorDataType vectorDataType) {
            this.executor = executor;
            this.closed = false;
            this.memoryAddress = memoryAddress;
            this.sizeKb = sizeKb;
            this.readCount = 0;
            this.readSemaphore = new Semaphore(1);
            this.writeSemaphore = new Semaphore(1);
            this.vectorDataType = vectorDataType;
        }

        @Override
        public void close() {
            this.executor.execute(() -> {
                this.writeLock();
                try {
                    this.cleanup();
                }
                finally {
                    this.writeUnlock();
                }
            });
        }

        public void closeUnsafe() {
            this.executor.execute(() -> {
                this.cleanup();
                this.writeUnlock();
            });
        }

        private void cleanup() {
            if (this.closed) {
                return;
            }
            this.closed = true;
            if (this.memoryAddress != 0L) {
                this.vectorDataType.freeNativeMemory(this.memoryAddress);
            }
        }

        @Override
        public boolean isClosed() {
            return this.closed;
        }

        @Override
        public long getMemoryAddress() {
            return this.memoryAddress;
        }

        @Override
        public void readLock() {
            try {
                this.readSemaphore.acquire();
            }
            catch (InterruptedException ex) {
                throw new RuntimeException(ex);
            }
            if (this.readCount == 0) {
                try {
                    this.writeLock();
                }
                catch (RuntimeException e) {
                    this.readSemaphore.release();
                    throw e;
                }
            }
            ++this.readCount;
            this.readSemaphore.release();
        }

        @Override
        public void writeLock() {
            try {
                this.writeSemaphore.acquire();
            }
            catch (InterruptedException ex) {
                throw new RuntimeException(ex);
            }
        }

        @Override
        public void readUnlock() {
            try {
                this.readSemaphore.acquire();
            }
            catch (InterruptedException ex) {
                throw new RuntimeException(ex);
            }
            --this.readCount;
            if (this.readCount <= 0) {
                this.writeUnlock();
            }
            this.readSemaphore.release();
        }

        @Override
        public void writeUnlock() {
            this.writeSemaphore.release();
        }

        @Override
        public int getSizeInKB() {
            return this.sizeKb;
        }

        @Generated
        public void setMemoryAddress(long memoryAddress) {
            this.memoryAddress = memoryAddress;
        }

        @Generated
        public QuantizationConfig getQuantizationConfig() {
            return this.quantizationConfig;
        }

        @Generated
        public void setQuantizationConfig(QuantizationConfig quantizationConfig) {
            this.quantizationConfig = quantizationConfig;
        }
    }

    public static class IndexAllocation
    implements NativeMemoryAllocation {
        private final ExecutorService executor;
        private final long memoryAddress;
        private final int sizeKb;
        private volatile boolean closed;
        private final KNNEngine knnEngine;
        private final String vectorFileName;
        private final String openSearchIndexName;
        private final ReadWriteLock readWriteLock;
        private final SharedIndexState sharedIndexState;
        private final boolean isBinaryIndex;
        private final RefCountedReleasable<IndexAllocation> refCounted;

        IndexAllocation(ExecutorService executorService, long memoryAddress, int sizeKb, KNNEngine knnEngine, String vectorFileName, String openSearchIndexName) {
            this(executorService, memoryAddress, sizeKb, knnEngine, vectorFileName, openSearchIndexName, null, false);
        }

        IndexAllocation(ExecutorService executorService, long memoryAddress, int sizeKb, KNNEngine knnEngine, String vectorFileName, String openSearchIndexName, SharedIndexState sharedIndexState, boolean isBinaryIndex) {
            this.executor = executorService;
            this.closed = false;
            this.knnEngine = knnEngine;
            this.vectorFileName = vectorFileName;
            this.openSearchIndexName = openSearchIndexName;
            this.memoryAddress = memoryAddress;
            this.readWriteLock = new ReentrantReadWriteLock();
            this.sizeKb = sizeKb;
            this.sharedIndexState = sharedIndexState;
            this.isBinaryIndex = isBinaryIndex;
            this.refCounted = new RefCountedReleasable("IndexAllocation-Reference", (Object)this, this::closeInternal);
        }

        protected void closeInternal() {
            Runnable onClose = () -> {
                this.writeLock();
                try {
                    this.cleanup();
                }
                finally {
                    this.writeUnlock();
                }
            };
            if (KNNFeatureFlags.isForceEvictCacheEnabled()) {
                onClose.run();
            } else {
                this.executor.execute(onClose);
            }
        }

        @Override
        public void close() {
            if (!this.closed && this.refCounted.refCount() > 0) {
                this.refCounted.close();
            }
        }

        private void cleanup() {
            if (this.closed) {
                return;
            }
            this.closed = true;
            if (this.memoryAddress != 0L) {
                JNIService.free(this.memoryAddress, this.knnEngine, this.isBinaryIndex);
            }
            if (this.sharedIndexState != null) {
                SharedIndexStateManager.getInstance().release(this.sharedIndexState);
            }
        }

        @Override
        public boolean isClosed() {
            return this.closed;
        }

        @Override
        public long getMemoryAddress() {
            return this.memoryAddress;
        }

        @Override
        public void readLock() {
            this.readWriteLock.readLock().lock();
        }

        @Override
        public void writeLock() {
            this.readWriteLock.writeLock().lock();
        }

        @Override
        public void readUnlock() {
            this.readWriteLock.readLock().unlock();
        }

        @Override
        public void writeUnlock() {
            this.readWriteLock.writeLock().unlock();
        }

        @Override
        public int getSizeInKB() {
            return this.sizeKb;
        }

        @Override
        public void incRef() {
            this.refCounted.incRef();
        }

        @Override
        public boolean decRef() {
            return this.refCounted.decRef();
        }

        @Generated
        public KNNEngine getKnnEngine() {
            return this.knnEngine;
        }

        @Generated
        public String getVectorFileName() {
            return this.vectorFileName;
        }

        @Generated
        public String getOpenSearchIndexName() {
            return this.openSearchIndexName;
        }

        @Generated
        public boolean isBinaryIndex() {
            return this.isBinaryIndex;
        }
    }
}

