/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.ui.views;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Keymap;
import org.netbeans.spi.debugger.ui.ViewFactory;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;

public final class ToolTipView
extends JComponent
implements HelpCtx.Provider {
    public static final String TOOLTIP_VIEW_NAME = "ToolTipView";
    private static final String TOOLTIP_HELP_ID = "NetbeansDebuggerToolTipNode";
    private static volatile String expression;
    private static volatile Object variable;
    private transient JComponent contentComponent;

    private ToolTipView(String expression, Object v, String icon) {
        ToolTipView.expression = expression;
        variable = v;
        JComponent c = ViewFactory.getDefault().createViewComponent(icon, TOOLTIP_VIEW_NAME, TOOLTIP_HELP_ID, null);
        this.setLayout(new BorderLayout());
        this.add((Component)c, "Center");
    }

    public static String getExpression() {
        return expression;
    }

    public static Object getVariable() {
        return variable;
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        variable = null;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(TOOLTIP_HELP_ID);
    }

    @Override
    public boolean requestFocusInWindow() {
        super.requestFocusInWindow();
        if (this.contentComponent == null) {
            return false;
        }
        return this.contentComponent.requestFocusInWindow();
    }

    public static synchronized ToolTipView createToolTipView(String expression, Object variable) {
        return new ToolTipView(expression, variable, "org/netbeans/modules/debugger/resources/localsView/local_variable_16.png");
    }

    public static class ExpandableTooltip
    extends JPanel {
        private static final String UI_PREFIX = "ToolTip";
        private JButton expButton;
        private JButton pinButton;
        private JComponent textToolTip;
        private boolean widthCheck = true;
        private boolean sizeSet = false;

        public ExpandableTooltip(String toolTipText, boolean expandable, boolean pinnable) {
            Font font = UIManager.getFont("ToolTip.font");
            Color backColor = UIManager.getColor("ToolTip.background");
            Color foreColor = UIManager.getColor("ToolTip.foreground");
            if (backColor != null) {
                this.setBackground(backColor);
            }
            this.setOpaque(true);
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(this.getForeground()), BorderFactory.createEmptyBorder(0, 3, 0, 3)));
            this.setLayout(new BoxLayout(this, 0));
            if (pinnable) {
                this.pinButton = new JButton(ImageUtilities.loadImageIcon((String)"org/netbeans/editor/resources/pin.png", (boolean)false));
                this.pinButton.setBorder(new EmptyBorder(0, 3, 0, 0));
                this.pinButton.setBorderPainted(false);
                this.pinButton.setContentAreaFilled(false);
                this.add(this.pinButton);
            }
            if (expandable) {
                Icon expIcon = UIManager.getIcon("Tree.collapsedIcon");
                this.expButton = new JButton(expIcon);
                this.expButton.setBorder(new EmptyBorder(0, 0, 0, 5));
                this.expButton.setBorderPainted(false);
                this.expButton.setContentAreaFilled(false);
                this.add(this.expButton);
            }
            JTextArea l = ExpandableTooltip.createMultiLineToolTip(toolTipText, true);
            if (font != null) {
                l.setFont(font);
            }
            if (foreColor != null) {
                l.setForeground(foreColor);
            }
            if (backColor != null) {
                l.setBackground(backColor);
            }
            l.setBorder(new EmptyBorder(0, 3, 0, 3));
            this.textToolTip = l;
            this.add(l);
            if (expandable || pinnable) {
                InputMap im = new InputMap();
                im.setParent(this.getInputMap());
                this.setInputMap(0, im);
                ActionMap am = new ActionMap();
                am.setParent(this.getActionMap());
                this.setActionMap(am);
                im.put(KeyStroke.getKeyStroke(32, 0), "expand");
                im.put(KeyStroke.getKeyStroke(10, 0), "pin");
                if (expandable) {
                    am.put("expand", new AbstractAction(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            expButton.doClick();
                        }
                    });
                }
                if (pinnable) {
                    am.put("pin", new AbstractAction(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            SwingUtilities.invokeLater(() -> pinButton.doClick());
                        }
                    });
                }
            }
        }

        public void addExpansionListener(ActionListener treeExpansionListener) {
            this.expButton.addActionListener(treeExpansionListener);
        }

        public void addPinListener(ActionListener treeExpansionListener) {
            this.pinButton.addActionListener(treeExpansionListener);
        }

        public void setWidthCheck(boolean widthCheck) {
            this.widthCheck = widthCheck;
        }

        @Override
        public Dimension getPreferredSize() {
            if (!this.sizeSet) {
                return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
            }
            Dimension preferredSize = super.getPreferredSize();
            return new Dimension(Integer.MAX_VALUE, preferredSize.height);
        }

        @Override
        public void setSize(int width, int height) {
            Dimension prefSize = this.getPreferredSize();
            Dimension button1Size = this.expButton != null ? this.expButton.getPreferredSize() : new Dimension(0, 0);
            Dimension button2Size = this.pinButton.getPreferredSize();
            if (this.widthCheck) {
                Insets insets = this.getInsets();
                int textWidth = width - insets.left - button1Size.width - button2Size.width - insets.right;
                height = Math.max(Math.max(height, button1Size.height), button2Size.height);
                this.textToolTip.setSize(textWidth, height);
                Dimension textPreferredSize = this.textToolTip.getPreferredSize();
                super.setSize(insets.left + button1Size.width + button2Size.width + textPreferredSize.width + insets.right, insets.top + Math.max(Math.max(button1Size.height, textPreferredSize.height), button2Size.height) + insets.bottom);
            } else {
                if (height >= prefSize.height) {
                    height = prefSize.height;
                }
                super.setSize(width, height);
            }
            this.sizeSet = true;
        }

        private static JTextArea createMultiLineToolTip(String toolTipText, boolean wrapLines) {
            TextToolTip ta = new TextToolTip(wrapLines);
            ta.setText(toolTipText);
            return ta;
        }

        private static class TextToolTip
        extends JTextArea {
            private static final String ELIPSIS = "...";
            private final boolean wrapLines;

            public TextToolTip(boolean wrapLines) {
                this.wrapLines = wrapLines;
                this.setLineWrap(false);
            }

            @Override
            public void setSize(int width, int height) {
                Dimension prefSize = this.getPreferredSize();
                if (width >= prefSize.width) {
                    width = prefSize.width;
                } else {
                    if (this.wrapLines) {
                        this.setLineWrap(true);
                        this.setWrapStyleWord(true);
                    }
                    super.setSize(width, Integer.MAX_VALUE);
                    prefSize = this.getPreferredSize();
                }
                if (height >= prefSize.height) {
                    height = prefSize.height;
                } else {
                    super.setSize(width, Integer.MAX_VALUE);
                    int offset = this.viewToModel(new Point(0, height));
                    Document doc = this.getDocument();
                    try {
                        if (offset > ELIPSIS.length()) {
                            doc.remove(offset -= ELIPSIS.length(), doc.getLength() - offset);
                            doc.insertString(offset, ELIPSIS, null);
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                    height = Math.min(height, this.getPreferredSize().height);
                }
                super.setSize(width, height);
            }

            @Override
            public void setKeymap(Keymap map) {
                super.setKeymap(TextToolTip.addKeymap(null, map));
            }
        }
    }
}

