/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.antlr.refactoring;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.netbeans.api.editor.document.LineDocument;
import org.netbeans.api.editor.document.LineDocumentUtils;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.languages.antlr.AntlrParser;
import org.netbeans.modules.languages.antlr.AntlrParserResult;
import org.netbeans.modules.languages.antlr.refactoring.Bundle;
import org.netbeans.modules.languages.antlr.refactoring.SymbolInformation;
import org.netbeans.modules.languages.antlr.v4.Antlr4ParserResult;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.WhereUsedQuery;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.netbeans.modules.refactoring.spi.RefactoringPluginFactory;
import org.netbeans.modules.refactoring.spi.SimpleRefactoringElementImplementation;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.PositionBounds;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

public class Refactoring {

    public static class AntlrRefactoringElementImpl
    extends SimpleRefactoringElementImplementation {
        private final String annotatedLine;
        private final FileObject file;
        private final PositionBounds bounds;

        public AntlrRefactoringElementImpl(String annotatedLine, FileObject file, PositionBounds bounds) {
            this.annotatedLine = annotatedLine;
            this.file = file;
            this.bounds = bounds;
        }

        public String getText() {
            return "Element usage";
        }

        public String getDisplayText() {
            return this.annotatedLine;
        }

        public void performChange() {
            throw new UnsupportedOperationException();
        }

        public Lookup getLookup() {
            return Lookup.EMPTY;
        }

        public FileObject getParentFile() {
            return this.file;
        }

        public PositionBounds getPosition() {
            return this.bounds;
        }
    }

    public static class FactoryImpl
    implements RefactoringPluginFactory {
        public RefactoringPlugin createInstance(AbstractRefactoring refactoring) {
            WhereUsedQuery q;
            SymbolInformation symbolInformation;
            if (refactoring instanceof WhereUsedQuery && (symbolInformation = (SymbolInformation)(q = (WhereUsedQuery)refactoring).getRefactoringSource().lookup(SymbolInformation.class)) != null) {
                return new WhereUsedRefactoringPlugin(q, symbolInformation);
            }
            return null;
        }
    }

    private static final class WhereUsedRefactoringPlugin
    implements RefactoringPlugin {
        private final WhereUsedQuery query;
        private final SymbolInformation symbolInformation;
        private final AtomicBoolean cancel = new AtomicBoolean();

        public WhereUsedRefactoringPlugin(WhereUsedQuery query, SymbolInformation symbolInformation) {
            this.query = query;
            this.symbolInformation = symbolInformation;
        }

        public Problem preCheck() {
            return null;
        }

        public Problem checkParameters() {
            return null;
        }

        public Problem fastCheckParameters() {
            return null;
        }

        public void cancelRequest() {
            this.cancel.set(true);
        }

        public Problem prepare(RefactoringElementsBag refactoringElements) {
            try {
                String name = this.symbolInformation.getName();
                FileObject sourceFO = this.symbolInformation.getSourceFile();
                HashMap imports = new HashMap();
                if ("text/x-antlr4".equals(sourceFO.getMIMEType())) {
                    FileObject parent = sourceFO.getParent();
                    for (FileObject cf : parent.getChildren()) {
                        if (this.cancel.get()) {
                            throw new CancellationException();
                        }
                        if (!"text/x-antlr4".equals(cf.getMIMEType())) continue;
                        Antlr4ParserResult result = (Antlr4ParserResult)AntlrParser.getParserResult(cf);
                        result.getImports().forEach(s -> {
                            FileObject referencedFO = parent.getFileObject(s, "g4");
                            if (referencedFO != null) {
                                imports.computeIfAbsent(cf, cd2 -> new HashSet()).add(referencedFO);
                            }
                        });
                    }
                }
                ArrayList<FileObject> toScan = new ArrayList<FileObject>();
                HashSet<FileObject> scannedFileObjects = new HashSet<FileObject>();
                toScan.add(sourceFO);
                while (!toScan.isEmpty()) {
                    if (this.cancel.get()) {
                        throw new CancellationException();
                    }
                    FileObject fo = (FileObject)toScan.remove(0);
                    if (scannedFileObjects.contains(fo)) continue;
                    scannedFileObjects.add(fo);
                    AntlrParserResult<?> result = AntlrParser.getParserResult(fo);
                    AntlrParserResult.Reference ref = result.references.get(name);
                    TreeSet<OffsetRange> ranges = new TreeSet<OffsetRange>();
                    if (ref != null && ref.defOffset != null) {
                        ranges.add(ref.defOffset);
                    }
                    ranges.addAll(result.getOccurrences(name));
                    for (OffsetRange offsetRange : ranges) {
                        try {
                            CloneableEditorSupport es = (CloneableEditorSupport)fo.getLookup().lookup(CloneableEditorSupport.class);
                            EditorCookie ec = (EditorCookie)fo.getLookup().lookup(EditorCookie.class);
                            StyledDocument doc = ec.openDocument();
                            LineDocument ldoc = (LineDocument)doc;
                            int rowStart = LineDocumentUtils.getLineStart((LineDocument)ldoc, (int)offsetRange.getStart());
                            int rowEnd = LineDocumentUtils.getLineEnd((LineDocument)ldoc, (int)offsetRange.getEnd());
                            PositionBounds bounds = new PositionBounds(es.createPositionRef(offsetRange.getStart(), Position.Bias.Forward), es.createPositionRef(offsetRange.getEnd(), Position.Bias.Forward));
                            String lineText = doc.getText(rowStart, rowEnd - rowStart);
                            String annotatedLine = lineText.substring(0, offsetRange.getStart() - rowStart) + "<strong>" + lineText.substring(offsetRange.getStart() - rowStart, offsetRange.getEnd() - rowStart) + "</strong>" + lineText.substring(offsetRange.getEnd() - rowStart);
                            refactoringElements.add((AbstractRefactoring)this.query, (RefactoringElementImplementation)new AntlrRefactoringElementImpl(annotatedLine, fo, bounds));
                        }
                        catch (IOException | BadLocationException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                            Object var13_18 = null;
                        }
                    }
                    toScan.addAll(imports.getOrDefault(fo, Collections.emptySet()));
                    for (Map.Entry entry : imports.entrySet()) {
                        if (!((Set)entry.getValue()).contains(fo)) continue;
                        toScan.add((FileObject)entry.getKey());
                    }
                }
                return null;
            }
            catch (CancellationException ex) {
                return new Problem(false, Bundle.TXT_Canceled());
            }
        }
    }
}

