/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.git.jgit.commands;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitStatus;
import org.netbeans.libs.git.jgit.GitClassFactory;
import org.netbeans.libs.git.jgit.Utils;
import org.netbeans.libs.git.jgit.commands.StatusCommand;
import org.netbeans.libs.git.progress.ProgressMonitor;
import org.netbeans.libs.git.progress.StatusListener;

public class ConflictCommand
extends StatusCommand {
    private final ProgressMonitor monitor;
    private final File[] roots;

    public ConflictCommand(Repository repository, GitClassFactory gitFactory, File[] roots, ProgressMonitor monitor, StatusListener listener) {
        super(repository, "HEAD", roots, gitFactory, monitor, listener);
        this.monitor = monitor;
        this.roots = roots;
    }

    @Override
    protected String getCommandDescription() {
        StringBuilder sb = new StringBuilder("git show conflicts");
        for (File root : this.roots) {
            sb.append(" ").append(root.getAbsolutePath());
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void run() throws GitException {
        Repository repository = this.getRepository();
        try {
            DirCache cache = repository.readDirCache();
            try {
                String workTreePath = repository.getWorkTree().getAbsolutePath();
                Collection<PathFilter> pathFilters = Utils.getPathFilters(repository.getWorkTree(), this.roots);
                TreeWalk treeWalk = new TreeWalk(repository);
                if (!pathFilters.isEmpty()) {
                    treeWalk.setFilter(PathFilterGroup.create(pathFilters));
                }
                treeWalk.setRecursive(true);
                treeWalk.reset();
                treeWalk.addTree((AbstractTreeIterator)new DirCacheIterator(cache));
                String lastPath = null;
                GitStatus[] conflicts = new GitStatus[3];
                while (treeWalk.next() && !this.monitor.isCanceled()) {
                    GitStatus status;
                    long indexTS;
                    String path = treeWalk.getPathString();
                    if (!path.equals(lastPath)) {
                        this.handleConflict(conflicts, workTreePath);
                    }
                    lastPath = path;
                    File file = new File(workTreePath + File.separator + path);
                    DirCacheIterator indexIterator = (DirCacheIterator)treeWalk.getTree(0, DirCacheIterator.class);
                    DirCacheEntry indexEntry = indexIterator != null ? indexIterator.getDirCacheEntry() : null;
                    int stage = indexEntry == null ? 0 : indexEntry.getStage();
                    long l = indexTS = indexEntry == null ? -1L : indexEntry.getLastModifiedInstant().toEpochMilli();
                    if (stage == 0) continue;
                    conflicts[stage - 1] = status = this.getClassFactory().createStatus(true, path, workTreePath, file, GitStatus.Status.STATUS_NORMAL, GitStatus.Status.STATUS_NORMAL, GitStatus.Status.STATUS_NORMAL, null, false, null, indexTS);
                }
                this.handleConflict(conflicts, workTreePath);
            }
            finally {
                cache.unlock();
            }
        }
        catch (CorruptObjectException ex) {
            throw new GitException(ex);
        }
        catch (IOException ex) {
            throw new GitException(ex);
        }
    }
}

