/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.jaxws.nodes;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.api.jaxws.client.JAXWSClientSupport;
import org.netbeans.modules.websvc.api.jaxws.project.CatalogUtils;
import org.netbeans.modules.websvc.api.jaxws.project.WSUtils;
import org.netbeans.modules.websvc.api.jaxws.project.config.Client;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModel;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModelListener;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModeler;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlService;
import org.netbeans.modules.websvc.core.JaxWsUtils;
import org.netbeans.modules.websvc.core.jaxws.nodes.JaxWsClientNode;
import org.netbeans.modules.websvc.core.jaxws.nodes.ServiceNode;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class JaxWsClientChildren
extends Children.Keys<WsdlService> {
    Client client;
    WsdlModel wsdlModel;
    FileObject srcRoot;

    public JaxWsClientChildren(Client client, FileObject srcRoot) {
        this.client = client;
        this.srcRoot = srcRoot;
    }

    protected void addNotify() {
        final WsdlModeler wsdlModeler = ((JaxWsClientNode)this.getNode()).getWsdlModeler();
        if (wsdlModeler != null) {
            JAXWSClientSupport clientSupport = JAXWSClientSupport.getJaxWsClientSupport((FileObject)this.srcRoot);
            if (clientSupport != null) {
                wsdlModeler.setCatalog(clientSupport.getCatalog());
            }
            this.wsdlModel = wsdlModeler.getWsdlModel();
            if (this.wsdlModel == null) {
                wsdlModeler.generateWsdlModel(new WsdlModelListener(){
                    final /* synthetic */ JaxWsClientChildren this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public void modelCreated(WsdlModel model) {
                        this.this$0.wsdlModel = model;
                        ((JaxWsClientNode)this.this$0.getNode()).changeIcon();
                        if (model == null) {
                            DialogDisplayer.getDefault().notify((NotifyDescriptor)new JaxWsUtils.WsImportClientFailedMessage(wsdlModeler.getCreationException()));
                        }
                        this.this$0.updateKeys();
                    }
                });
            } else {
                this.updateKeys();
            }
        }
    }

    protected void removeNotify() {
        this.setKeys(Collections.emptySet());
    }

    private void updateKeys() {
        List keys = null;
        if (this.wsdlModel != null) {
            keys = this.wsdlModel.getServices();
        }
        this.setKeys(keys == null ? Collections.emptyList() : keys);
    }

    protected Node[] createNodes(WsdlService key) {
        return new Node[]{new ServiceNode(key)};
    }

    void refreshKeys(boolean downloadWsdl) {
        this.refreshKeys(downloadWsdl, "");
    }

    void refreshKeys(boolean downloadWsdl, String newWsdlUrl) {
        Project project;
        super.addNotify();
        JAXWSClientSupport support = JAXWSClientSupport.getJaxWsClientSupport((FileObject)this.srcRoot);
        final JaxWsClientNode clientNode = (JaxWsClientNode)this.getNode();
        if (downloadWsdl) {
            try {
                FileObject webInfWsdlFolder;
                String clientName = clientNode.getName();
                String oldWsdlUrl = this.client.getWsdlUrl();
                boolean jaxWsModelChanged = false;
                FileObject localWsdl = null;
                if (newWsdlUrl.length() > 0 && !oldWsdlUrl.equals(newWsdlUrl)) {
                    localWsdl = WSUtils.retrieveResource((FileObject)support.getLocalWsdlFolderForClient(clientName, true), (URI)new URI(newWsdlUrl));
                    jaxWsModelChanged = true;
                } else {
                    WSUtils.retrieveResource((FileObject)support.getLocalWsdlFolderForClient(clientName, true), (URI)new URI(oldWsdlUrl));
                }
                if (jaxWsModelChanged) {
                    this.client.setWsdlUrl(newWsdlUrl);
                    FileObject xmlResourcesFo = support.getLocalWsdlFolderForClient(clientName, false);
                    if (xmlResourcesFo != null) {
                        String localWsdlUrl = FileUtil.getRelativePath((FileObject)xmlResourcesFo, (FileObject)localWsdl);
                        this.client.setLocalWsdlFile(localWsdlUrl);
                    }
                    clientNode.getJaxWsModel().write();
                }
                FileObject sourceRoot = (FileObject)this.getNode().getLookup().lookup(FileObject.class);
                Project project2 = FileOwnerQuery.getOwner((FileObject)this.srcRoot);
                FileObject xmlResorcesFo = support.getLocalWsdlFolderForClient(clientName, false);
                if (xmlResorcesFo != null && (webInfWsdlFolder = support.getWsdlFolder(true)) != null) {
                    try {
                        FileObject jaxWsCatalog = webInfWsdlFolder.getParent().getFileObject("jax-ws-catalog.xml");
                        FileObject catalog = project2.getProjectDirectory().getFileObject("catalog.xml");
                        if (jaxWsCatalog != null && catalog != null) {
                            CatalogUtils.copyCatalogEntriesForClient((FileObject)catalog, (FileObject)jaxWsCatalog, (String)clientName);
                        }
                        WSUtils.copyFiles((FileObject)xmlResorcesFo, (FileObject)webInfWsdlFolder);
                    }
                    catch (IOException ex) {
                        Logger.getLogger(JaxWsClientChildren.class.getName()).log(Level.INFO, "Cannot copy files to " + webInfWsdlFolder, ex);
                    }
                }
            }
            catch (URISyntaxException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
            catch (UnknownHostException ex) {
                ErrorManager.getDefault().annotate((Throwable)ex, NbBundle.getMessage(JaxWsClientChildren.class, (String)"MSG_ConnectionProblem"));
                return;
            }
            catch (IOException ex) {
                ErrorManager.getDefault().annotate((Throwable)ex, NbBundle.getMessage(JaxWsClientChildren.class, (String)"MSG_ConnectionProblem"));
                return;
            }
        }
        final WsdlModeler wsdlModeler = clientNode.getWsdlModeler();
        clientNode.setModelGenerationFinished(false);
        clientNode.changeIcon();
        if (wsdlModeler != null) {
            wsdlModeler.generateWsdlModel(new WsdlModelListener(){
                final /* synthetic */ JaxWsClientChildren this$0;
                {
                    this.this$0 = this$0;
                }

                public void modelCreated(WsdlModel model) {
                    Client client;
                    this.this$0.wsdlModel = model;
                    clientNode.setModelGenerationFinished(true);
                    clientNode.changeIcon();
                    if (model == null) {
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new JaxWsUtils.WsImportClientFailedMessage(wsdlModeler.getCreationException()));
                    }
                    this.this$0.updateKeys();
                    if (model != null && (client = clientNode.getJaxWsModel().findClientByName(clientNode.getName())) != null) {
                        String javaName;
                        int dotPosition;
                        WsdlService wsdlService = null;
                        boolean jaxWsModelChanged = false;
                        List wsdlServices = model.getServices();
                        if (wsdlServices != null && wsdlServices.size() > 0) {
                            wsdlService = (WsdlService)wsdlServices.get(0);
                        }
                        String oldPkgName = client.getPackageName();
                        if (wsdlService != null && !client.isPackageNameForceReplace() && (dotPosition = (javaName = wsdlService.getJavaName()).lastIndexOf(".")) >= 0) {
                            String newPkgName = javaName.substring(0, dotPosition);
                            if (oldPkgName == null && newPkgName != null || !oldPkgName.equals(newPkgName)) {
                                client.setPackageName(newPkgName);
                                jaxWsModelChanged = true;
                            }
                        }
                        if (jaxWsModelChanged) {
                            try {
                                clientNode.getJaxWsModel().write();
                            }
                            catch (IOException ex) {
                                ErrorManager.getDefault().notify(65536, (Throwable)ex);
                            }
                        }
                    }
                }
            });
        }
        if ((project = FileOwnerQuery.getOwner((FileObject)this.srcRoot)) != null) {
            FileObject buildImplFo = project.getProjectDirectory().getFileObject("build.xml");
            try {
                String name = this.client.getName();
                ExecutorTask wsimportTask = ActionUtils.runTarget((FileObject)buildImplFo, (String[])new String[]{"wsimport-client-clean-" + name, "wsimport-client-generate"}, null);
                wsimportTask.waitFinished();
            }
            catch (IOException ex) {
                ErrorManager.getDefault().log(ex.getLocalizedMessage());
            }
            catch (IllegalArgumentException ex) {
                ErrorManager.getDefault().log(ex.getLocalizedMessage());
            }
        }
    }

    WsdlModel getWsdlModel() {
        return this.wsdlModel;
    }
}

