/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.snaptracer.impl.timeline;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.List;
import org.netbeans.lib.profiler.charts.ChartContext;
import org.netbeans.lib.profiler.charts.ChartItem;
import org.netbeans.lib.profiler.charts.ChartItemChange;
import org.netbeans.lib.profiler.charts.ItemSelection;
import org.netbeans.lib.profiler.charts.swing.LongRect;
import org.netbeans.lib.profiler.charts.xy.XYItem;
import org.netbeans.lib.profiler.charts.xy.XYItemChange;
import org.netbeans.lib.profiler.charts.xy.XYItemPainter;
import org.netbeans.lib.profiler.charts.xy.XYItemSelection;
import org.netbeans.lib.profiler.charts.xy.synchronous.SynchronousXYChartContext;
import org.netbeans.lib.profiler.charts.xy.synchronous.SynchronousXYItem;

abstract class TimelineXYPainter
extends XYItemPainter.Abstract {
    private final int viewExtent;
    private final boolean bottomBased;
    private boolean painting;
    protected final double dataFactor;

    TimelineXYPainter(int viewExtent, boolean bottomBased, double dataFactor) {
        this.viewExtent = viewExtent;
        this.bottomBased = bottomBased;
        this.dataFactor = dataFactor;
        this.painting = true;
    }

    protected abstract void paint(XYItem var1, List<ItemSelection> var2, List<ItemSelection> var3, Graphics2D var4, Rectangle var5, SynchronousXYChartContext var6);

    protected abstract Color getDefiningColor();

    void setPainting(boolean painting) {
        this.painting = painting;
    }

    boolean isPainting() {
        return this.painting;
    }

    public LongRect getItemBounds(ChartItem item) {
        XYItem xyItem = (XYItem)item;
        return this.getDataBounds(xyItem.getBounds());
    }

    public LongRect getItemBounds(ChartItem item, ChartContext context) {
        XYItem xyItem = (XYItem)item;
        return this.getViewBounds(xyItem.getBounds(), context);
    }

    public boolean isBoundsChange(ChartItemChange itemChange) {
        XYItemChange change = (XYItemChange)itemChange;
        return !LongRect.equals((LongRect)change.getOldValuesBounds(), (LongRect)change.getNewValuesBounds());
    }

    public boolean isAppearanceChange(ChartItemChange itemChange) {
        XYItemChange change = (XYItemChange)itemChange;
        LongRect dirtyBounds = change.getDirtyValuesBounds();
        return dirtyBounds.width != 0L || dirtyBounds.height != 0L;
    }

    public LongRect getDirtyBounds(ChartItemChange itemChange, ChartContext context) {
        XYItemChange change = (XYItemChange)itemChange;
        return this.getViewBounds(change.getDirtyValuesBounds(), context);
    }

    public boolean supportsHovering(ChartItem item) {
        return true;
    }

    public boolean supportsSelecting(ChartItem item) {
        return true;
    }

    public LongRect getSelectionBounds(ItemSelection selection, ChartContext context) {
        XYItemSelection sel = (XYItemSelection)selection;
        XYItem item = sel.getItem();
        int selectedValueIndex = sel.getValueIndex();
        if (selectedValueIndex == -1 || selectedValueIndex >= item.getValuesCount()) {
            return new LongRect(0L, 0L, (long)context.getViewportWidth(), (long)context.getViewportHeight());
        }
        return this.getViewBounds(item, selectedValueIndex, context);
    }

    public XYItemSelection getClosestSelection(ChartItem item, int viewX, int viewY, ChartContext context) {
        SynchronousXYChartContext contx = (SynchronousXYChartContext)context;
        int nearestTimestampIndex = contx.getNearestTimestampIndex(viewX, viewY);
        if (nearestTimestampIndex == -1) {
            return null;
        }
        SynchronousXYItem xyItem = (SynchronousXYItem)item;
        return new XYItemSelection.Default((XYItem)xyItem, nearestTimestampIndex, Integer.MAX_VALUE);
    }

    public final void paintItem(ChartItem item, List<ItemSelection> highlighted, List<ItemSelection> selected, Graphics2D g, Rectangle dirtyArea, ChartContext context) {
        if (!this.painting) {
            return;
        }
        XYItem it = (XYItem)item;
        if (it.getValuesCount() < 1) {
            return;
        }
        if (context.getViewWidth() == 0L || context.getViewHeight() == 0L) {
            return;
        }
        SynchronousXYChartContext ctx = (SynchronousXYChartContext)context;
        this.paint((XYItem)item, highlighted, selected, g, dirtyArea, ctx);
    }

    public double getItemView(double dataY, XYItem item, ChartContext context) {
        return context.getViewY(dataY * this.dataFactor);
    }

    public double getItemValue(double viewY, XYItem item, ChartContext context) {
        return context.getDataY(viewY / this.dataFactor);
    }

    public double getItemValueScale(XYItem item, ChartContext context) {
        double scale = context.getViewHeight(this.dataFactor);
        if (scale <= 0.0) {
            scale = -1.0;
        }
        return scale;
    }

    private LongRect getDataBounds(LongRect itemBounds) {
        LongRect bounds = new LongRect(itemBounds);
        bounds.y = (long)((double)bounds.y * this.dataFactor);
        bounds.height = (long)((double)bounds.height * this.dataFactor);
        if (this.bottomBased) {
            bounds.height += bounds.y;
            bounds.y = 0L;
        }
        return bounds;
    }

    private LongRect getViewBounds(LongRect itemBounds, ChartContext context) {
        LongRect dataBounds = this.getDataBounds(itemBounds);
        LongRect viewBounds = context.getViewRect(dataBounds);
        LongRect.addBorder((LongRect)viewBounds, (long)this.viewExtent);
        return viewBounds;
    }

    private LongRect getViewBounds(XYItem item, int valueIndex, ChartContext context) {
        long xValue = item.getXValue(valueIndex);
        long yValue = (long)((double)item.getYValue(valueIndex) * this.dataFactor);
        return context.getViewRect(new LongRect(xValue, yValue, 0L, 0L));
    }
}

