/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jshell.project;

import java.io.IOException;
import java.util.Collection;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.Project;
import org.netbeans.modules.jshell.env.JShellEnvironment;
import org.netbeans.modules.jshell.env.ShellRegistry;
import org.netbeans.modules.jshell.env.ShellStatus;
import org.netbeans.modules.jshell.launch.ShellAgent;
import org.netbeans.modules.jshell.launch.ShellLaunchEvent;
import org.netbeans.modules.jshell.launch.ShellLaunchListener;
import org.netbeans.modules.jshell.launch.ShellLaunchManager;
import org.netbeans.modules.jshell.launch.ShellOptions;
import org.netbeans.modules.jshell.project.Bundle;
import org.netbeans.modules.jshell.project.ProjectShellEnv;
import org.netbeans.spi.project.AuxiliaryProperties;
import org.openide.filesystems.FileObject;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.Exceptions;

public class LaunchedProjectOpener
implements ShellLaunchListener {
    private static LaunchedProjectOpener INSTANCE = null;
    private ShellOptions opts = ShellOptions.get();

    public static void init() {
    }

    @Override
    public void connectionInitiated(ShellLaunchEvent ev) {
    }

    @Override
    public void handshakeCompleted(final ShellLaunchEvent ev) {
        SwingUtilities.invokeLater(new Runnable(){
            final /* synthetic */ LaunchedProjectOpener this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                this.this$0.maybeOpenAgentShell(ev.getAgent());
            }
        });
    }

    public void maybeOpenAgentShell(ShellAgent agent) {
        String s;
        Project p = agent.getProject();
        if (p == null) {
            return;
        }
        AuxiliaryProperties auxProps = (AuxiliaryProperties)p.getLookup().lookup(AuxiliaryProperties.class);
        if (auxProps != null && (s = auxProps.get("jshell.run.show", true)) != null) {
            if (Boolean.parseBoolean(s)) {
                this.openAgentShell(agent);
            }
            return;
        }
        if (this.opts.isOpenConsole()) {
            this.openAgentShell(agent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openAgentShell(ShellAgent agent) {
        Project p = agent.getProject();
        String dispName = agent.getDisplayName();
        ProjectShellEnv attachEnv = new ProjectShellEnv(agent, p, Bundle.Title_JShellOnDebugger(dispName), agent.getDebuggerMachine() == null ? "run" : "debug");
        if (this.opts.isReuseDeadConsoles()) {
            Collection<JShellEnvironment> existing = ShellRegistry.get().openedShells(p);
            for (JShellEnvironment ex : existing) {
                if (ex.getProject() == p && ex.getStatus() == ShellStatus.SHUTDOWN && this.closeCloneableEditor(ex)) break;
            }
        }
        boolean ok = false;
        try {
            ShellRegistry.get().startJShell(attachEnv);
            attachEnv.open();
            ok = true;
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        finally {
            if (!ok) {
                attachEnv.getSession().closeSession();
            }
        }
    }

    private boolean closeCloneableEditor(JShellEnvironment env) {
        FileObject consoleDoc = env.getConsoleFile();
        CloneableEditorSupport editor = (CloneableEditorSupport)consoleDoc.getLookup().lookup(CloneableEditorSupport.class);
        if (editor == null || editor.getOpenedPanes() == null) {
            return false;
        }
        return editor.close();
    }

    @Override
    public void agentDestroyed(ShellLaunchEvent ev) {
    }

    @Override
    public void connectionClosed(ShellLaunchEvent ev) {
    }

    public static LaunchedProjectOpener get() {
        return INSTANCE;
    }

    public ShellAgent getProjectAgent(JShellEnvironment env) {
        if (!(env instanceof ProjectShellEnv)) {
            return null;
        }
        return ((ProjectShellEnv)env).getAgent();
    }

    static {
        INSTANCE = new LaunchedProjectOpener();
        ShellLaunchManager.getInstance().addLaunchListener(INSTANCE);
    }
}

