/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.wizards;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.modules.php.project.ui.wizards.Bundle;
import org.netbeans.modules.php.project.ui.wizards.NewPhpProjectWizardIterator;
import org.netbeans.modules.php.spi.phpmodule.PhpModuleExtender;
import org.openide.WizardDescriptor;
import org.openide.util.HelpCtx;

public class PhpExtenderPanel
implements WizardDescriptor.Panel<WizardDescriptor>,
WizardDescriptor.FinishablePanel<WizardDescriptor> {
    static final String VALID = "PhpExtenderPanel.valid";
    private final PhpModuleExtender extender;
    private final String[] steps;
    private final int stepIndex;
    private volatile WizardDescriptor descriptor = null;
    private JComponent component;

    @SuppressWarnings(value={"EI_EXPOSE_REP2"}, justification="Intentional")
    public PhpExtenderPanel(PhpModuleExtender extender, String[] steps, int stepIndex) {
        assert (extender != null);
        assert (steps != null);
        this.extender = extender;
        this.steps = steps;
        this.stepIndex = stepIndex;
    }

    public JComponent getComponent() {
        assert (EventQueue.isDispatchThread());
        if (this.component == null) {
            this.component = this.extender.getComponent();
            if (this.component == null) {
                this.component = new JPanel(new BorderLayout());
                this.component.add((Component)new JLabel(Bundle.PhpExtenderPanel_noUi(this.extender.getDisplayName())), "North");
            }
            this.component.setName(this.extender.getDisplayName());
            this.component.putClientProperty("WizardPanel_contentSelectedIndex", this.stepIndex);
            this.component.putClientProperty("WizardPanel_contentData", this.steps);
        }
        return this.component;
    }

    public HelpCtx getHelp() {
        return this.extender.getHelp();
    }

    public void readSettings(WizardDescriptor settings) {
        this.descriptor = settings;
    }

    public void storeSettings(WizardDescriptor settings) {
    }

    public boolean isValid() {
        this.descriptor.putProperty("WizardPanel_errorMessage", (Object)" ");
        boolean valid = this.extender.isValid();
        String error = this.extender.getErrorMessage();
        String warning = this.extender.getWarningMessage();
        if (!valid && error == null) {
            throw new IllegalStateException("Extender " + this.extender.getIdentifier() + " invalid but error message is null");
        }
        if (valid && error != null) {
            throw new IllegalStateException("Extender " + this.extender.getIdentifier() + " valid but error message is not null");
        }
        if (error != null) {
            this.descriptor.putProperty("WizardPanel_errorMessage", (Object)error);
            this.setValid(false);
            return false;
        }
        if (warning != null) {
            this.descriptor.putProperty("WizardPanel_warningMessage", (Object)warning);
        }
        this.setValid(true);
        return true;
    }

    public void addChangeListener(ChangeListener listener) {
        this.extender.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.extender.removeChangeListener(listener);
    }

    public boolean isFinishPanel() {
        return NewPhpProjectWizardIterator.areAllStepsValid(this.descriptor);
    }

    private void setValid(boolean valid) {
        ConcurrentHashMap<PhpModuleExtender, Boolean> validity = (ConcurrentHashMap<PhpModuleExtender, Boolean>)this.descriptor.getProperty(VALID);
        if (validity == null) {
            validity = new ConcurrentHashMap<PhpModuleExtender, Boolean>();
            this.descriptor.putProperty(VALID, validity);
        }
        validity.put(this.extender, valid);
    }
}

