/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.connections.api;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.netbeans.modules.php.project.PhpPreferences;
import org.openide.util.Parameters;

public final class RemotePreferences {
    private static final Logger LOGGER = Logger.getLogger(RemotePreferences.class.getName());
    private static final String REMOTE_CONNECTIONS = "RemoteConnections";
    private static final String GENERAL_PREFERENCES = "general";
    private final String type;
    private final boolean importEnabled;

    private RemotePreferences(String type, boolean importEnabled) {
        Parameters.notNull((CharSequence)"type", (Object)type);
        this.type = type;
        this.importEnabled = importEnabled;
    }

    public static RemotePreferences forType(String type, boolean importEnabled) {
        return new RemotePreferences(type, importEnabled);
    }

    public static Map<String, Map<String, String>> getServerConfigs() {
        HashMap<String, Map<String, String>> serverConfigs = new HashMap<String, Map<String, String>>();
        Preferences remoteConnections = RemotePreferences.getServerConfigsPreferences();
        try {
            for (String name : remoteConnections.childrenNames()) {
                if (name.equals(GENERAL_PREFERENCES)) continue;
                Preferences node = remoteConnections.node(name);
                TreeMap<String, String> value = new TreeMap<String, String>();
                for (String key : node.keys()) {
                    value.put(key, node.get(key, null));
                }
                serverConfigs.put(name, value);
            }
        }
        catch (BackingStoreException bse) {
            LOGGER.log(Level.INFO, "Error while reading existing remote connections", bse);
        }
        return serverConfigs;
    }

    public Preferences getPreferences() {
        return PhpPreferences.getPreferences(this.importEnabled).node(REMOTE_CONNECTIONS).node(GENERAL_PREFERENCES).node(this.type);
    }

    public static Preferences getServerConfigsPreferences() {
        return PhpPreferences.getPreferences(true).node(REMOTE_CONNECTIONS);
    }
}

