/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jellytools;

import java.awt.Container;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.netbeans.jellytools.EditorOperator;
import org.netbeans.jellytools.MainWindowOperator;
import org.netbeans.jellytools.TopComponentOperator;
import org.netbeans.jemmy.JemmyException;
import org.netbeans.jemmy.QueueTool;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.JButtonOperator;
import org.netbeans.jemmy.operators.JTableOperator;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class EditorWindowOperator {
    private static JButtonOperator _btLeft;
    private static JButtonOperator _btRight;
    private static JButtonOperator _btDown;

    @Deprecated
    public EditorWindowOperator() {
    }

    public static JButtonOperator btLeft() {
        if (_btLeft == null) {
            _btLeft = new JButtonOperator(new ContainerOperator(EditorWindowOperator.getEditor().findTabDisplayer()), 0);
        }
        return _btLeft;
    }

    public static JButtonOperator btRight() {
        if (_btRight == null) {
            _btRight = new JButtonOperator(new ContainerOperator(EditorWindowOperator.getEditor().findTabDisplayer()), 1);
        }
        return _btRight;
    }

    public static JButtonOperator btDown() {
        if (_btDown == null) {
            _btDown = new JButtonOperator(new ContainerOperator(EditorWindowOperator.getEditor().findTabDisplayer()), 2);
        }
        return _btDown;
    }

    public static void closeDiscard() {
        EditorWindowOperator.closeDiscard(EditorWindowOperator.findEditorMode());
    }

    public static void closeDiscard(final Mode mode) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    Iterator<TopComponent> iter = Arrays.asList(mode.getTopComponents()).iterator();
                    while (iter.hasNext()) {
                        EditorOperator.close(iter.next(), false);
                    }
                }
            });
        }
        catch (InterruptedException ex) {
            throw new JemmyException("Interrupted!", (Throwable)ex);
        }
        catch (InvocationTargetException ex) {
            throw new JemmyException("Exception while closing.", (Throwable)ex);
        }
    }

    public static EditorOperator selectPage(String label) {
        return new EditorOperator(label);
    }

    public static EditorOperator selectPage(int index) {
        try {
            new TopComponentOperator((JComponent)((TopComponent)EditorWindowOperator.getEditor().findTabbedAdapter().getModel().getTab(index).getComponent()));
        }
        catch (IndexOutOfBoundsException e) {
            throw new JemmyException("Index " + index + " out of bounds.", (Throwable)e);
        }
        return EditorWindowOperator.getEditor();
    }

    public static EditorOperator getEditor() {
        final Mode mode = EditorWindowOperator.findEditorMode();
        String name = (String)new QueueTool().invokeSmoothly(new QueueTool.QueueAction("getSelectedTopComponent().getName()"){

            public Object launch() {
                return mode.getSelectedTopComponent().getName();
            }
        });
        return new EditorOperator(name);
    }

    public static EditorOperator getEditor(String label) {
        return EditorWindowOperator.selectPage(label);
    }

    public static EditorOperator getEditor(int index) {
        return EditorWindowOperator.selectPage(index);
    }

    public static boolean jumpLeft() {
        if (EditorWindowOperator.btLeft().isEnabled()) {
            Container cont = EditorWindowOperator.getEditor().findTabDisplayer();
            new ContainerOperator(cont).clickMouse(cont.getX() + 1, cont.getY() + cont.getHeight() / 2, 1);
            return true;
        }
        return false;
    }

    public static void moveTabsRight() {
        EditorWindowOperator.btRight().push();
    }

    public static void moveTabsLeft() {
        EditorWindowOperator.btLeft().push();
    }

    public static void selectDocument(int index) {
        EditorWindowOperator.btDown().push();
        JTableOperator tableOper = new JTableOperator((ContainerOperator)MainWindowOperator.getDefault());
        tableOper.selectCell(index, 0);
    }

    public static void selectDocument(String name) {
        EditorWindowOperator.btDown().push();
        JTableOperator tableOper = new JTableOperator((ContainerOperator)MainWindowOperator.getDefault());
        int row = tableOper.findCellRow(name);
        if (row <= -1) {
            throw new JemmyException("Cannot select document \"" + name + "\".");
        }
        tableOper.selectCell(row, 0);
    }

    public static void verify() {
        EditorWindowOperator.getEditor().verify();
    }

    private static Mode findEditorMode() {
        return (Mode)new QueueTool().invokeSmoothly(new QueueTool.QueueAction("findMode"){

            public Object launch() {
                return WindowManager.getDefault().findMode("editor");
            }
        });
    }
}

