/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.editor.completion;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.text.JTextComponent;
import org.netbeans.api.db.sql.support.SQLIdentifiers;
import org.netbeans.modules.db.metadata.model.api.Catalog;
import org.netbeans.modules.db.metadata.model.api.Metadata;
import org.netbeans.modules.db.metadata.model.api.MetadataElement;
import org.netbeans.modules.db.metadata.model.api.Schema;
import org.netbeans.modules.db.metadata.model.api.Tuple;
import org.netbeans.modules.db.metadata.model.api.View;
import org.netbeans.modules.db.sql.analyzer.QualIdent;
import org.netbeans.modules.db.sql.editor.OptionsUtils;
import org.netbeans.modules.db.sql.editor.api.completion.SQLCompletionResultSet;
import org.netbeans.modules.db.sql.editor.api.completion.SubstitutionHandler;
import org.netbeans.modules.db.sql.editor.completion.SQLCompletionItem;
import org.netbeans.spi.editor.completion.CompletionResultSet;

public class SQLCompletionItems
implements Iterable<SQLCompletionItem> {
    private final List<SQLCompletionItem> items = new ArrayList<SQLCompletionItem>();
    private final SQLIdentifiers.Quoter quoter;
    private final SubstitutionHandler substitutionHandler;

    public SQLCompletionItems(SQLIdentifiers.Quoter quoter, SubstitutionHandler substitutionHandler) {
        this.quoter = quoter;
        this.substitutionHandler = substitutionHandler;
    }

    public void addKeywords(String prefix, int substitutionOffset, String ... keywords) {
        for (String keyword : keywords) {
            if (!SQLCompletionItems.filter(keyword, prefix)) continue;
            this.items.add(SQLCompletionItem.keyword(keyword, substitutionOffset, this.substitutionHandler));
        }
    }

    public Set<String> addCatalogs(Metadata metadata, Set<String> restrict, String prefix, boolean quote, int substitutionOffset) {
        TreeSet<String> result = new TreeSet<String>();
        SQLCompletionItems.filterMetadata(metadata.getCatalogs(), restrict, prefix, catalog -> {
            String catalogName = catalog.getName();
            this.items.add(SQLCompletionItem.catalog(catalogName, this.doQuote(catalogName, quote), substitutionOffset, this.substitutionHandler));
        });
        return result;
    }

    public Set<String> addSchemas(Catalog catalog, Set<String> restrict, String prefix, boolean quote, int substitutionOffset) {
        TreeSet<String> result = new TreeSet<String>();
        SQLCompletionItems.filterMetadata(catalog.getSchemas(), restrict, prefix, schema -> {
            if (!schema.isSynthetic()) {
                String schemaName = schema.getName();
                this.items.add(SQLCompletionItem.schema(schemaName, this.doQuote(schemaName, quote), substitutionOffset, this.substitutionHandler));
            }
        });
        return result;
    }

    public void addTables(Schema schema, Set<String> restrict, String prefix, boolean quote, int substitutionOffset) {
        this.addTables(schema, null, restrict, prefix, quote, substitutionOffset, false);
    }

    public void addTablesAtInsertInto(Schema schema, QualIdent fullyTypedIdent, Set<String> restrict, String prefix, boolean quote, int substitutionOffset) {
        this.addTables(schema, fullyTypedIdent, restrict, prefix, quote, substitutionOffset, true);
    }

    private void addTables(Schema schema, QualIdent fullyTypedIdent, Set<String> restrict, String prefix, boolean quote, int substitutionOffset, boolean ownHandler) {
        String schema4display = fullyTypedIdent == null ? "" : fullyTypedIdent.getSimpleName() + '.';
        int ownOffset = fullyTypedIdent == null ? substitutionOffset : substitutionOffset - (fullyTypedIdent.getSimpleName().length() + 1);
        SQLCompletionItems.filterMetadata(schema.getTables(), restrict, prefix, table -> {
            String tableName = table.getName();
            this.items.add(SQLCompletionItem.table(tableName, this.doQuote(tableName, quote), ownOffset, ownHandler ? new ExtendedSubstitutionHandler(this.substitutionHandler, schema4display, " (") : this.substitutionHandler));
        });
    }

    public void addViews(Schema schema, Set<String> restrict, String prefix, boolean quote, int substitutionOffset) {
        this.addViews(schema, null, restrict, prefix, quote, substitutionOffset, false);
    }

    public void addViewsAtInsertInto(Schema schema, QualIdent fullyTypedIdent, Set<String> restrict, String prefix, boolean quote, int substitutionOffset) {
        this.addViews(schema, fullyTypedIdent, restrict, prefix, quote, substitutionOffset, true);
    }

    private void addViews(Schema schema, QualIdent fullyTypedIdent, Set<String> restrict, String prefix, boolean quote, int substitutionOffset, boolean ownHandler) {
        String schema4display = fullyTypedIdent == null ? "" : fullyTypedIdent.getSimpleName() + '.';
        int ownOffset = fullyTypedIdent == null ? substitutionOffset : substitutionOffset - (fullyTypedIdent.getSimpleName().length() + 1);
        SQLCompletionItems.filterMetadata(schema.getViews(), restrict, prefix, view -> {
            String viewName = view.getName();
            this.items.add(SQLCompletionItem.view(viewName, this.doQuote(viewName, quote), ownOffset, ownHandler ? new ExtendedSubstitutionHandler(this.substitutionHandler, schema4display, " (") : this.substitutionHandler));
        });
    }

    public void addAliases(Map<String, QualIdent> aliases, String prefix, boolean quote, int substitutionOffset) {
        SQLCompletionItems.filterMap(aliases, null, prefix, (alias, tableName) -> this.items.add(SQLCompletionItem.alias(alias, tableName, alias, substitutionOffset, this.substitutionHandler)));
    }

    public void addColumnsWithTupleName(Tuple tuple, QualIdent fullyTypedIdent, String prefix, boolean quote, int substitutionOffset) {
        this.addColumns(tuple, fullyTypedIdent, prefix, quote, substitutionOffset, true);
    }

    public void addColumns(Tuple tuple, String prefix, boolean quote, int substitutionOffset) {
        this.addColumns(tuple, null, prefix, quote, substitutionOffset, false);
    }

    private void addColumns(Tuple tuple, QualIdent fullyTypedIdent, String prefix, boolean quote, int substitutionOffset, boolean ownHandler) {
        Schema schema = tuple.getParent();
        Catalog catalog = schema.getParent();
        ArrayList<String> parts = new ArrayList<String>(3);
        if (!catalog.isDefault()) {
            parts.add(catalog.getName());
        }
        if (!schema.isSynthetic() && !schema.isDefault()) {
            parts.add(schema.getName());
        }
        parts.add(tuple.getName());
        QualIdent qualTableName = new QualIdent(parts);
        String table4display = fullyTypedIdent == null ? tuple.getName() : fullyTypedIdent.getFirstQualifier() + '.' + fullyTypedIdent.getSecondQualifier();
        int ownOffset = fullyTypedIdent == null ? substitutionOffset : substitutionOffset - (fullyTypedIdent.getFirstQualifier().length() + fullyTypedIdent.getSecondQualifier().length() + 2);
        SQLCompletionItems.filterMetadata(tuple.getColumns(), null, prefix, column -> {
            String columnName = column.getName();
            this.items.add(SQLCompletionItem.column(tuple instanceof View, qualTableName, columnName, column.getTypeName(), this.doQuote(columnName, quote), ownOffset, ownHandler ? new ExtendedSubstitutionHandler(this.substitutionHandler, table4display + " (", null) : this.substitutionHandler));
        });
    }

    public void fill(CompletionResultSet resultSet) {
        resultSet.addAllItems(this.items);
    }

    public void fill(SQLCompletionResultSet resultSet) {
        resultSet.addAllItems(this.items);
    }

    @Override
    public Iterator<SQLCompletionItem> iterator() {
        return this.items.iterator();
    }

    private String doQuote(String identifier, boolean always) {
        if (always) {
            return this.quoter.quoteAlways(identifier);
        }
        return this.quoter.quoteIfNeeded(identifier);
    }

    private static boolean startsWithIgnoreCase(String text, String prefix) {
        return text.regionMatches(true, 0, prefix, 0, prefix.length());
    }

    private static boolean containsIgnoreCase(String text, String prefix) {
        return text.toLowerCase(Locale.ROOT).contains(prefix.toLowerCase(Locale.ROOT));
    }

    private static boolean filter(String string, String prefix) {
        if (prefix == null) {
            return true;
        }
        if (OptionsUtils.isSqlCompletionSubwords()) {
            return SQLCompletionItems.containsIgnoreCase(string, prefix);
        }
        return SQLCompletionItems.startsWithIgnoreCase(string, prefix);
    }

    private static <P> void filterMap(Map<String, P> strings, Set<String> restrict, String prefix, ParamHandler<String, P> handler) {
        for (Map.Entry<String, P> entry : strings.entrySet()) {
            String string = entry.getKey();
            if (restrict != null && !restrict.contains(string) || !SQLCompletionItems.filter(string, prefix)) continue;
            handler.handle(string, entry.getValue());
        }
    }

    private static <T extends MetadataElement> void filterMetadata(Collection<T> elements, Set<String> restrict, String prefix, Handler<T> handler) {
        for (MetadataElement element : elements) {
            String name = element.getName();
            if (name == null || restrict != null && !restrict.contains(name) || !SQLCompletionItems.filter(name, prefix)) continue;
            handler.handle(element);
        }
    }

    private static interface Handler<T> {
        public void handle(T var1);
    }

    private static interface ParamHandler<T, P> {
        public void handle(T var1, P var2);
    }

    private static final class ExtendedSubstitutionHandler
    implements SubstitutionHandler {
        private final SubstitutionHandler original;
        private final String prefix;
        private final String postfix;

        public ExtendedSubstitutionHandler(SubstitutionHandler handler, String prefix, String postfix) {
            this.original = handler;
            this.prefix = prefix == null ? "" : prefix;
            this.postfix = postfix == null ? "" : postfix;
        }

        @Override
        public void substituteText(JTextComponent component, int offset, String text) {
            this.original.substituteText(component, offset, this.prefix + text + this.postfix);
        }
    }
}

