/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.colorpicker;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.colorpicker.ColorPicker;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.WidgetBuilder;

public class ColorPickerRenderer
extends CoreRenderer {
    public void decode(FacesContext context, UIComponent component) {
        ColorPicker colorPicker = (ColorPicker)component;
        String paramName = colorPicker.getClientId(context) + "_input";
        Map params = context.getExternalContext().getRequestParameterMap();
        if (params.containsKey(paramName)) {
            String submittedValue = (String)params.get(paramName);
            colorPicker.setSubmittedValue(submittedValue);
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        ColorPicker colorPicker = (ColorPicker)component;
        this.encodeMarkup(context, colorPicker);
        this.encodeScript(context, colorPicker);
    }

    protected void encodeMarkup(FacesContext context, ColorPicker colorPicker) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = colorPicker.getClientId(context);
        String inputId = clientId + "_input";
        String value = (String)colorPicker.getValue();
        boolean isPopup = colorPicker.getMode().equals("popup");
        String styleClass = colorPicker.getStyleClass();
        styleClass = styleClass == null ? "ui-colorpicker" : "ui-colorpicker " + styleClass;
        writer.startElement("span", null);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (colorPicker.getStyle() != null) {
            writer.writeAttribute("style", (Object)colorPicker.getStyle(), "style");
        }
        if (isPopup) {
            this.encodeButton(context, clientId, value);
        } else {
            this.encodeInline(context, clientId);
        }
        writer.startElement("input", null);
        writer.writeAttribute("id", (Object)inputId, null);
        writer.writeAttribute("name", (Object)inputId, null);
        writer.writeAttribute("type", (Object)"hidden", null);
        if (value != null) {
            writer.writeAttribute("value", (Object)value, null);
        }
        writer.endElement("input");
        writer.endElement("span");
    }

    protected void encodeButton(FacesContext context, String clientId, String value) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("button", null);
        writer.writeAttribute("id", (Object)(clientId + "_button"), null);
        writer.writeAttribute("type", (Object)"button", null);
        writer.writeAttribute("class", (Object)"ui-button ui-widget ui-state-default ui-corner-all ui-button-text-only", null);
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-button-text ui-c", null);
        writer.write("<span id=\"" + clientId + "_livePreview\" style=\"overflow:hidden;width:1em;height:1em;display:block;border:solid 1px #000;text-indent:1em;white-space:nowrap;");
        if (value != null) {
            writer.write("background-color:#" + value);
        }
        writer.write("\">Live Preview</span>");
        writer.endElement("span");
        writer.endElement("button");
    }

    protected void encodeInline(FacesContext context, String clientId) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)(clientId + "_inline"), "id");
        writer.endElement("div");
    }

    protected void encodeScript(FacesContext context, ColorPicker colorPicker) throws IOException {
        String clientId = colorPicker.getClientId(context);
        String value = (String)colorPicker.getValue();
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.initWithDomReady("ColorPicker", colorPicker.resolveWidgetVar(), clientId, "colorpicker").attr("mode", colorPicker.getMode()).attr("color", value, null);
        wb.finish();
    }
}

