/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.devops.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.devops.model.UpdateBuildRunDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateBuildRunRequest
extends BmcRequest<UpdateBuildRunDetails> {
    private String buildRunId;
    private UpdateBuildRunDetails updateBuildRunDetails;
    private String ifMatch;
    private String opcRequestId;

    public String getBuildRunId() {
        return this.buildRunId;
    }

    public UpdateBuildRunDetails getUpdateBuildRunDetails() {
        return this.updateBuildRunDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public UpdateBuildRunDetails getBody$() {
        return this.updateBuildRunDetails;
    }

    public Builder toBuilder() {
        return new Builder().buildRunId(this.buildRunId).updateBuildRunDetails(this.updateBuildRunDetails).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",buildRunId=").append(String.valueOf(this.buildRunId));
        sb.append(",updateBuildRunDetails=").append(String.valueOf((Object)this.updateBuildRunDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateBuildRunRequest)) {
            return false;
        }
        UpdateBuildRunRequest other = (UpdateBuildRunRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.buildRunId, other.buildRunId) && Objects.equals((Object)this.updateBuildRunDetails, (Object)other.updateBuildRunDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.buildRunId == null ? 43 : this.buildRunId.hashCode());
        result = result * 59 + (this.updateBuildRunDetails == null ? 43 : this.updateBuildRunDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateBuildRunRequest, UpdateBuildRunDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String buildRunId = null;
        private UpdateBuildRunDetails updateBuildRunDetails = null;
        private String ifMatch = null;
        private String opcRequestId = null;

        public Builder buildRunId(String buildRunId) {
            this.buildRunId = buildRunId;
            return this;
        }

        public Builder updateBuildRunDetails(UpdateBuildRunDetails updateBuildRunDetails) {
            this.updateBuildRunDetails = updateBuildRunDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateBuildRunRequest o) {
            this.buildRunId(o.getBuildRunId());
            this.updateBuildRunDetails(o.getUpdateBuildRunDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateBuildRunRequest build() {
            UpdateBuildRunRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateBuildRunDetails body) {
            this.updateBuildRunDetails(body);
            return this;
        }

        public UpdateBuildRunRequest buildWithoutInvocationCallback() {
            UpdateBuildRunRequest request = new UpdateBuildRunRequest();
            request.buildRunId = this.buildRunId;
            request.updateBuildRunDetails = this.updateBuildRunDetails;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

