/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.devops.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.devops.model.DeployArtifactSource;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="deployArtifactSourceType")
@JsonFilter(value="explicitlySetFilter")
public final class OcirDeployArtifactSource
extends DeployArtifactSource {
    @JsonProperty(value="imageUri")
    private final String imageUri;
    @JsonProperty(value="imageDigest")
    private final String imageDigest;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public OcirDeployArtifactSource(String imageUri, String imageDigest) {
        this.imageUri = imageUri;
        this.imageDigest = imageDigest;
    }

    public String getImageUri() {
        return this.imageUri;
    }

    public String getImageDigest() {
        return this.imageDigest;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("OcirDeployArtifactSource(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", imageUri=").append(String.valueOf(this.imageUri));
        sb.append(", imageDigest=").append(String.valueOf(this.imageDigest));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OcirDeployArtifactSource)) {
            return false;
        }
        OcirDeployArtifactSource other = (OcirDeployArtifactSource)((Object)o);
        return Objects.equals(this.imageUri, other.imageUri) && Objects.equals(this.imageDigest, other.imageDigest) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.imageUri == null ? 43 : this.imageUri.hashCode());
        result = result * 59 + (this.imageDigest == null ? 43 : this.imageDigest.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="imageUri")
        private String imageUri;
        @JsonProperty(value="imageDigest")
        private String imageDigest;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder imageUri(String imageUri) {
            this.imageUri = imageUri;
            this.__explicitlySet__.add("imageUri");
            return this;
        }

        public Builder imageDigest(String imageDigest) {
            this.imageDigest = imageDigest;
            this.__explicitlySet__.add("imageDigest");
            return this;
        }

        public OcirDeployArtifactSource build() {
            OcirDeployArtifactSource model = new OcirDeployArtifactSource(this.imageUri, this.imageDigest);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(OcirDeployArtifactSource model) {
            if (model.wasPropertyExplicitlySet("imageUri")) {
                this.imageUri(model.getImageUri());
            }
            if (model.wasPropertyExplicitlySet("imageDigest")) {
                this.imageDigest(model.getImageDigest());
            }
            return this;
        }
    }
}

