/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.swing;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.netbeans.lib.profiler.ui.UIUtils;

class EditableHistoryCombo
extends JComboBox {
    private Runnable onTextChange;

    EditableHistoryCombo() {
        super(new ComboHistoryModel(10));
        this.setEditable(true);
        this.setPrototypeDisplayValue("org.netbeans.lib.profiler.ui.swing.XXXXX");
        Dimension dim = this.getPreferredSize();
        dim.height = !UIUtils.isNimbusLookAndFeel() ? this.getMinimumSize().height : new JTextField((String)"X").getPreferredSize().height;
        this.setMinimumSize(dim);
        this.setPreferredSize(dim);
        this.setMaximumSize(dim);
        JTextComponent comp = this.getTextComponent();
        if (comp != null) {
            comp.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.onChange();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.onChange();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.onChange();
                }

                private void onChange() {
                    if (EditableHistoryCombo.this.onTextChange != null) {
                        EditableHistoryCombo.this.onTextChange.run();
                    }
                }
            });
        }
    }

    JTextComponent getTextComponent() {
        Component comp = this.getEditor().getEditorComponent();
        return comp instanceof JTextComponent ? (JTextComponent)comp : null;
    }

    String getText() {
        JTextComponent textC = this.getTextComponent();
        return textC != null ? textC.getText() : this.getSelectedItem().toString();
    }

    void setOnTextChangeHandler(Runnable handler) {
        this.onTextChange = handler;
    }

    private static class ComboHistoryModel
    extends DefaultComboBoxModel {
        private final int historySize;

        ComboHistoryModel(int historySize) {
            this.historySize = historySize;
        }

        @Override
        public void addElement(Object item) {
            this.insertElementAt(item, 0);
        }

        @Override
        public void insertElementAt(Object item, int index) {
            int current = this.getIndexOf(item);
            if (current == index) {
                return;
            }
            if (current != -1) {
                this.removeElementAt(current);
            }
            super.insertElementAt(item, index);
            if (this.getSize() > this.historySize) {
                this.removeElementAt(this.historySize);
            }
            this.setSelectedItem(item);
        }
    }
}

