/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class ListBootVolumesRequest
extends BmcRequest<Void> {
    private String availabilityDomain;
    private String compartmentId;
    private Integer limit;
    private String page;
    private String volumeGroupId;

    public String getAvailabilityDomain() {
        return this.availabilityDomain;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public String getVolumeGroupId() {
        return this.volumeGroupId;
    }

    public Builder toBuilder() {
        return new Builder().availabilityDomain(this.availabilityDomain).compartmentId(this.compartmentId).limit(this.limit).page(this.page).volumeGroupId(this.volumeGroupId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",availabilityDomain=").append(String.valueOf(this.availabilityDomain));
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",volumeGroupId=").append(String.valueOf(this.volumeGroupId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListBootVolumesRequest)) {
            return false;
        }
        ListBootVolumesRequest other = (ListBootVolumesRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.availabilityDomain, other.availabilityDomain) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals(this.volumeGroupId, other.volumeGroupId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.availabilityDomain == null ? 43 : this.availabilityDomain.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.volumeGroupId == null ? 43 : this.volumeGroupId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListBootVolumesRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String availabilityDomain = null;
        private String compartmentId = null;
        private Integer limit = null;
        private String page = null;
        private String volumeGroupId = null;

        public Builder availabilityDomain(String availabilityDomain) {
            this.availabilityDomain = availabilityDomain;
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder volumeGroupId(String volumeGroupId) {
            this.volumeGroupId = volumeGroupId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListBootVolumesRequest o) {
            this.availabilityDomain(o.getAvailabilityDomain());
            this.compartmentId(o.getCompartmentId());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.volumeGroupId(o.getVolumeGroupId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListBootVolumesRequest build() {
            ListBootVolumesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListBootVolumesRequest buildWithoutInvocationCallback() {
            ListBootVolumesRequest request = new ListBootVolumesRequest();
            request.availabilityDomain = this.availabilityDomain;
            request.compartmentId = this.compartmentId;
            request.limit = this.limit;
            request.page = this.page;
            request.volumeGroupId = this.volumeGroupId;
            return request;
        }
    }
}

