/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetIpv6Request
extends BmcRequest<Void> {
    private String ipv6Id;
    private String opcRequestId;

    public String getIpv6Id() {
        return this.ipv6Id;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().ipv6Id(this.ipv6Id).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",ipv6Id=").append(String.valueOf(this.ipv6Id));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetIpv6Request)) {
            return false;
        }
        GetIpv6Request other = (GetIpv6Request)((Object)o);
        return super.equals(o) && Objects.equals(this.ipv6Id, other.ipv6Id) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.ipv6Id == null ? 43 : this.ipv6Id.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetIpv6Request, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String ipv6Id = null;
        private String opcRequestId = null;

        public Builder ipv6Id(String ipv6Id) {
            this.ipv6Id = ipv6Id;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetIpv6Request o) {
            this.ipv6Id(o.getIpv6Id());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetIpv6Request build() {
            GetIpv6Request request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetIpv6Request buildWithoutInvocationCallback() {
            GetIpv6Request request = new GetIpv6Request();
            request.ipv6Id = this.ipv6Id;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

