/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.core.model.InstanceAgentConfig;
import com.oracle.bmc.core.model.InstanceAvailabilityConfig;
import com.oracle.bmc.core.model.InstanceOptions;
import com.oracle.bmc.core.model.InstanceShapeConfig;
import com.oracle.bmc.core.model.InstanceSourceDetails;
import com.oracle.bmc.core.model.LaunchOptions;
import com.oracle.bmc.core.model.PlatformConfig;
import com.oracle.bmc.core.model.PreemptibleInstanceConfigDetails;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class Instance
extends ExplicitlySetBmcModel {
    @JsonProperty(value="availabilityDomain")
    private final String availabilityDomain;
    @JsonProperty(value="capacityReservationId")
    private final String capacityReservationId;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="dedicatedVmHostId")
    private final String dedicatedVmHostId;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="extendedMetadata")
    private final Map<String, Object> extendedMetadata;
    @JsonProperty(value="faultDomain")
    private final String faultDomain;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="imageId")
    private final String imageId;
    @JsonProperty(value="ipxeScript")
    private final String ipxeScript;
    @JsonProperty(value="launchMode")
    private final LaunchMode launchMode;
    @JsonProperty(value="launchOptions")
    private final LaunchOptions launchOptions;
    @JsonProperty(value="instanceOptions")
    private final InstanceOptions instanceOptions;
    @JsonProperty(value="availabilityConfig")
    private final InstanceAvailabilityConfig availabilityConfig;
    @JsonProperty(value="preemptibleInstanceConfig")
    private final PreemptibleInstanceConfigDetails preemptibleInstanceConfig;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="metadata")
    private final Map<String, String> metadata;
    @JsonProperty(value="region")
    private final String region;
    @JsonProperty(value="shape")
    private final String shape;
    @JsonProperty(value="shapeConfig")
    private final InstanceShapeConfig shapeConfig;
    @JsonProperty(value="isCrossNumaNode")
    private final Boolean isCrossNumaNode;
    @JsonProperty(value="sourceDetails")
    private final InstanceSourceDetails sourceDetails;
    @JsonProperty(value="systemTags")
    private final Map<String, Map<String, Object>> systemTags;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="agentConfig")
    private final InstanceAgentConfig agentConfig;
    @JsonProperty(value="timeMaintenanceRebootDue")
    private final Date timeMaintenanceRebootDue;
    @JsonProperty(value="platformConfig")
    private final PlatformConfig platformConfig;
    @JsonProperty(value="instanceConfigurationId")
    private final String instanceConfigurationId;

    @Deprecated
    @ConstructorProperties(value={"availabilityDomain", "capacityReservationId", "compartmentId", "dedicatedVmHostId", "definedTags", "displayName", "extendedMetadata", "faultDomain", "freeformTags", "id", "imageId", "ipxeScript", "launchMode", "launchOptions", "instanceOptions", "availabilityConfig", "preemptibleInstanceConfig", "lifecycleState", "metadata", "region", "shape", "shapeConfig", "isCrossNumaNode", "sourceDetails", "systemTags", "timeCreated", "agentConfig", "timeMaintenanceRebootDue", "platformConfig", "instanceConfigurationId"})
    public Instance(String availabilityDomain, String capacityReservationId, String compartmentId, String dedicatedVmHostId, Map<String, Map<String, Object>> definedTags, String displayName, Map<String, Object> extendedMetadata, String faultDomain, Map<String, String> freeformTags, String id, String imageId, String ipxeScript, LaunchMode launchMode, LaunchOptions launchOptions, InstanceOptions instanceOptions, InstanceAvailabilityConfig availabilityConfig, PreemptibleInstanceConfigDetails preemptibleInstanceConfig, LifecycleState lifecycleState, Map<String, String> metadata, String region, String shape, InstanceShapeConfig shapeConfig, Boolean isCrossNumaNode, InstanceSourceDetails sourceDetails, Map<String, Map<String, Object>> systemTags, Date timeCreated, InstanceAgentConfig agentConfig, Date timeMaintenanceRebootDue, PlatformConfig platformConfig, String instanceConfigurationId) {
        this.availabilityDomain = availabilityDomain;
        this.capacityReservationId = capacityReservationId;
        this.compartmentId = compartmentId;
        this.dedicatedVmHostId = dedicatedVmHostId;
        this.definedTags = definedTags;
        this.displayName = displayName;
        this.extendedMetadata = extendedMetadata;
        this.faultDomain = faultDomain;
        this.freeformTags = freeformTags;
        this.id = id;
        this.imageId = imageId;
        this.ipxeScript = ipxeScript;
        this.launchMode = launchMode;
        this.launchOptions = launchOptions;
        this.instanceOptions = instanceOptions;
        this.availabilityConfig = availabilityConfig;
        this.preemptibleInstanceConfig = preemptibleInstanceConfig;
        this.lifecycleState = lifecycleState;
        this.metadata = metadata;
        this.region = region;
        this.shape = shape;
        this.shapeConfig = shapeConfig;
        this.isCrossNumaNode = isCrossNumaNode;
        this.sourceDetails = sourceDetails;
        this.systemTags = systemTags;
        this.timeCreated = timeCreated;
        this.agentConfig = agentConfig;
        this.timeMaintenanceRebootDue = timeMaintenanceRebootDue;
        this.platformConfig = platformConfig;
        this.instanceConfigurationId = instanceConfigurationId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getAvailabilityDomain() {
        return this.availabilityDomain;
    }

    public String getCapacityReservationId() {
        return this.capacityReservationId;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getDedicatedVmHostId() {
        return this.dedicatedVmHostId;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Map<String, Object> getExtendedMetadata() {
        return this.extendedMetadata;
    }

    public String getFaultDomain() {
        return this.faultDomain;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public String getId() {
        return this.id;
    }

    public String getImageId() {
        return this.imageId;
    }

    public String getIpxeScript() {
        return this.ipxeScript;
    }

    public LaunchMode getLaunchMode() {
        return this.launchMode;
    }

    public LaunchOptions getLaunchOptions() {
        return this.launchOptions;
    }

    public InstanceOptions getInstanceOptions() {
        return this.instanceOptions;
    }

    public InstanceAvailabilityConfig getAvailabilityConfig() {
        return this.availabilityConfig;
    }

    public PreemptibleInstanceConfigDetails getPreemptibleInstanceConfig() {
        return this.preemptibleInstanceConfig;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public String getRegion() {
        return this.region;
    }

    public String getShape() {
        return this.shape;
    }

    public InstanceShapeConfig getShapeConfig() {
        return this.shapeConfig;
    }

    public Boolean getIsCrossNumaNode() {
        return this.isCrossNumaNode;
    }

    public InstanceSourceDetails getSourceDetails() {
        return this.sourceDetails;
    }

    public Map<String, Map<String, Object>> getSystemTags() {
        return this.systemTags;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public InstanceAgentConfig getAgentConfig() {
        return this.agentConfig;
    }

    public Date getTimeMaintenanceRebootDue() {
        return this.timeMaintenanceRebootDue;
    }

    public PlatformConfig getPlatformConfig() {
        return this.platformConfig;
    }

    public String getInstanceConfigurationId() {
        return this.instanceConfigurationId;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Instance(");
        sb.append("super=").append(super.toString());
        sb.append("availabilityDomain=").append(String.valueOf(this.availabilityDomain));
        sb.append(", capacityReservationId=").append(String.valueOf(this.capacityReservationId));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", dedicatedVmHostId=").append(String.valueOf(this.dedicatedVmHostId));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", extendedMetadata=").append(String.valueOf(this.extendedMetadata));
        sb.append(", faultDomain=").append(String.valueOf(this.faultDomain));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", id=").append(String.valueOf(this.id));
        sb.append(", imageId=").append(String.valueOf(this.imageId));
        sb.append(", ipxeScript=").append(String.valueOf(this.ipxeScript));
        sb.append(", launchMode=").append(String.valueOf((Object)this.launchMode));
        sb.append(", launchOptions=").append(String.valueOf((Object)this.launchOptions));
        sb.append(", instanceOptions=").append(String.valueOf((Object)this.instanceOptions));
        sb.append(", availabilityConfig=").append(String.valueOf((Object)this.availabilityConfig));
        sb.append(", preemptibleInstanceConfig=").append(String.valueOf((Object)this.preemptibleInstanceConfig));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", metadata=").append(String.valueOf(this.metadata));
        sb.append(", region=").append(String.valueOf(this.region));
        sb.append(", shape=").append(String.valueOf(this.shape));
        sb.append(", shapeConfig=").append(String.valueOf((Object)this.shapeConfig));
        sb.append(", isCrossNumaNode=").append(String.valueOf(this.isCrossNumaNode));
        sb.append(", sourceDetails=").append(String.valueOf((Object)this.sourceDetails));
        sb.append(", systemTags=").append(String.valueOf(this.systemTags));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", agentConfig=").append(String.valueOf((Object)this.agentConfig));
        sb.append(", timeMaintenanceRebootDue=").append(String.valueOf(this.timeMaintenanceRebootDue));
        sb.append(", platformConfig=").append(String.valueOf((Object)this.platformConfig));
        sb.append(", instanceConfigurationId=").append(String.valueOf(this.instanceConfigurationId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Instance)) {
            return false;
        }
        Instance other = (Instance)((Object)o);
        return Objects.equals(this.availabilityDomain, other.availabilityDomain) && Objects.equals(this.capacityReservationId, other.capacityReservationId) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.dedicatedVmHostId, other.dedicatedVmHostId) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.extendedMetadata, other.extendedMetadata) && Objects.equals(this.faultDomain, other.faultDomain) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.id, other.id) && Objects.equals(this.imageId, other.imageId) && Objects.equals(this.ipxeScript, other.ipxeScript) && Objects.equals((Object)this.launchMode, (Object)other.launchMode) && Objects.equals((Object)this.launchOptions, (Object)other.launchOptions) && Objects.equals((Object)this.instanceOptions, (Object)other.instanceOptions) && Objects.equals((Object)this.availabilityConfig, (Object)other.availabilityConfig) && Objects.equals((Object)this.preemptibleInstanceConfig, (Object)other.preemptibleInstanceConfig) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.metadata, other.metadata) && Objects.equals(this.region, other.region) && Objects.equals(this.shape, other.shape) && Objects.equals((Object)this.shapeConfig, (Object)other.shapeConfig) && Objects.equals(this.isCrossNumaNode, other.isCrossNumaNode) && Objects.equals((Object)this.sourceDetails, (Object)other.sourceDetails) && Objects.equals(this.systemTags, other.systemTags) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals((Object)this.agentConfig, (Object)other.agentConfig) && Objects.equals(this.timeMaintenanceRebootDue, other.timeMaintenanceRebootDue) && Objects.equals((Object)this.platformConfig, (Object)other.platformConfig) && Objects.equals(this.instanceConfigurationId, other.instanceConfigurationId) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.availabilityDomain == null ? 43 : this.availabilityDomain.hashCode());
        result = result * 59 + (this.capacityReservationId == null ? 43 : this.capacityReservationId.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.dedicatedVmHostId == null ? 43 : this.dedicatedVmHostId.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.extendedMetadata == null ? 43 : this.extendedMetadata.hashCode());
        result = result * 59 + (this.faultDomain == null ? 43 : this.faultDomain.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.imageId == null ? 43 : this.imageId.hashCode());
        result = result * 59 + (this.ipxeScript == null ? 43 : this.ipxeScript.hashCode());
        result = result * 59 + (this.launchMode == null ? 43 : this.launchMode.hashCode());
        result = result * 59 + (this.launchOptions == null ? 43 : this.launchOptions.hashCode());
        result = result * 59 + (this.instanceOptions == null ? 43 : this.instanceOptions.hashCode());
        result = result * 59 + (this.availabilityConfig == null ? 43 : this.availabilityConfig.hashCode());
        result = result * 59 + (this.preemptibleInstanceConfig == null ? 43 : this.preemptibleInstanceConfig.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.metadata == null ? 43 : this.metadata.hashCode());
        result = result * 59 + (this.region == null ? 43 : this.region.hashCode());
        result = result * 59 + (this.shape == null ? 43 : this.shape.hashCode());
        result = result * 59 + (this.shapeConfig == null ? 43 : this.shapeConfig.hashCode());
        result = result * 59 + (this.isCrossNumaNode == null ? 43 : this.isCrossNumaNode.hashCode());
        result = result * 59 + (this.sourceDetails == null ? 43 : this.sourceDetails.hashCode());
        result = result * 59 + (this.systemTags == null ? 43 : this.systemTags.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.agentConfig == null ? 43 : this.agentConfig.hashCode());
        result = result * 59 + (this.timeMaintenanceRebootDue == null ? 43 : this.timeMaintenanceRebootDue.hashCode());
        result = result * 59 + (this.platformConfig == null ? 43 : this.platformConfig.hashCode());
        result = result * 59 + (this.instanceConfigurationId == null ? 43 : this.instanceConfigurationId.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum LifecycleState implements BmcEnum
    {
        Moving("MOVING"),
        Provisioning("PROVISIONING"),
        Running("RUNNING"),
        Starting("STARTING"),
        Stopping("STOPPING"),
        Stopped("STOPPED"),
        CreatingImage("CREATING_IMAGE"),
        Terminating("TERMINATING"),
        Terminated("TERMINATED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleState.class);
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum LaunchMode implements BmcEnum
    {
        Native("NATIVE"),
        Emulated("EMULATED"),
        Paravirtualized("PARAVIRTUALIZED"),
        Custom("CUSTOM"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LaunchMode> map;

        private LaunchMode(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LaunchMode create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LaunchMode', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LaunchMode.class);
            map = new HashMap<String, LaunchMode>();
            for (LaunchMode v : LaunchMode.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="availabilityDomain")
        private String availabilityDomain;
        @JsonProperty(value="capacityReservationId")
        private String capacityReservationId;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="dedicatedVmHostId")
        private String dedicatedVmHostId;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="extendedMetadata")
        private Map<String, Object> extendedMetadata;
        @JsonProperty(value="faultDomain")
        private String faultDomain;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="imageId")
        private String imageId;
        @JsonProperty(value="ipxeScript")
        private String ipxeScript;
        @JsonProperty(value="launchMode")
        private LaunchMode launchMode;
        @JsonProperty(value="launchOptions")
        private LaunchOptions launchOptions;
        @JsonProperty(value="instanceOptions")
        private InstanceOptions instanceOptions;
        @JsonProperty(value="availabilityConfig")
        private InstanceAvailabilityConfig availabilityConfig;
        @JsonProperty(value="preemptibleInstanceConfig")
        private PreemptibleInstanceConfigDetails preemptibleInstanceConfig;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="metadata")
        private Map<String, String> metadata;
        @JsonProperty(value="region")
        private String region;
        @JsonProperty(value="shape")
        private String shape;
        @JsonProperty(value="shapeConfig")
        private InstanceShapeConfig shapeConfig;
        @JsonProperty(value="isCrossNumaNode")
        private Boolean isCrossNumaNode;
        @JsonProperty(value="sourceDetails")
        private InstanceSourceDetails sourceDetails;
        @JsonProperty(value="systemTags")
        private Map<String, Map<String, Object>> systemTags;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="agentConfig")
        private InstanceAgentConfig agentConfig;
        @JsonProperty(value="timeMaintenanceRebootDue")
        private Date timeMaintenanceRebootDue;
        @JsonProperty(value="platformConfig")
        private PlatformConfig platformConfig;
        @JsonProperty(value="instanceConfigurationId")
        private String instanceConfigurationId;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder availabilityDomain(String availabilityDomain) {
            this.availabilityDomain = availabilityDomain;
            this.__explicitlySet__.add("availabilityDomain");
            return this;
        }

        public Builder capacityReservationId(String capacityReservationId) {
            this.capacityReservationId = capacityReservationId;
            this.__explicitlySet__.add("capacityReservationId");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder dedicatedVmHostId(String dedicatedVmHostId) {
            this.dedicatedVmHostId = dedicatedVmHostId;
            this.__explicitlySet__.add("dedicatedVmHostId");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder extendedMetadata(Map<String, Object> extendedMetadata) {
            this.extendedMetadata = extendedMetadata;
            this.__explicitlySet__.add("extendedMetadata");
            return this;
        }

        public Builder faultDomain(String faultDomain) {
            this.faultDomain = faultDomain;
            this.__explicitlySet__.add("faultDomain");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder imageId(String imageId) {
            this.imageId = imageId;
            this.__explicitlySet__.add("imageId");
            return this;
        }

        public Builder ipxeScript(String ipxeScript) {
            this.ipxeScript = ipxeScript;
            this.__explicitlySet__.add("ipxeScript");
            return this;
        }

        public Builder launchMode(LaunchMode launchMode) {
            this.launchMode = launchMode;
            this.__explicitlySet__.add("launchMode");
            return this;
        }

        public Builder launchOptions(LaunchOptions launchOptions) {
            this.launchOptions = launchOptions;
            this.__explicitlySet__.add("launchOptions");
            return this;
        }

        public Builder instanceOptions(InstanceOptions instanceOptions) {
            this.instanceOptions = instanceOptions;
            this.__explicitlySet__.add("instanceOptions");
            return this;
        }

        public Builder availabilityConfig(InstanceAvailabilityConfig availabilityConfig) {
            this.availabilityConfig = availabilityConfig;
            this.__explicitlySet__.add("availabilityConfig");
            return this;
        }

        public Builder preemptibleInstanceConfig(PreemptibleInstanceConfigDetails preemptibleInstanceConfig) {
            this.preemptibleInstanceConfig = preemptibleInstanceConfig;
            this.__explicitlySet__.add("preemptibleInstanceConfig");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder metadata(Map<String, String> metadata) {
            this.metadata = metadata;
            this.__explicitlySet__.add("metadata");
            return this;
        }

        public Builder region(String region) {
            this.region = region;
            this.__explicitlySet__.add("region");
            return this;
        }

        public Builder shape(String shape) {
            this.shape = shape;
            this.__explicitlySet__.add("shape");
            return this;
        }

        public Builder shapeConfig(InstanceShapeConfig shapeConfig) {
            this.shapeConfig = shapeConfig;
            this.__explicitlySet__.add("shapeConfig");
            return this;
        }

        public Builder isCrossNumaNode(Boolean isCrossNumaNode) {
            this.isCrossNumaNode = isCrossNumaNode;
            this.__explicitlySet__.add("isCrossNumaNode");
            return this;
        }

        public Builder sourceDetails(InstanceSourceDetails sourceDetails) {
            this.sourceDetails = sourceDetails;
            this.__explicitlySet__.add("sourceDetails");
            return this;
        }

        public Builder systemTags(Map<String, Map<String, Object>> systemTags) {
            this.systemTags = systemTags;
            this.__explicitlySet__.add("systemTags");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder agentConfig(InstanceAgentConfig agentConfig) {
            this.agentConfig = agentConfig;
            this.__explicitlySet__.add("agentConfig");
            return this;
        }

        public Builder timeMaintenanceRebootDue(Date timeMaintenanceRebootDue) {
            this.timeMaintenanceRebootDue = timeMaintenanceRebootDue;
            this.__explicitlySet__.add("timeMaintenanceRebootDue");
            return this;
        }

        public Builder platformConfig(PlatformConfig platformConfig) {
            this.platformConfig = platformConfig;
            this.__explicitlySet__.add("platformConfig");
            return this;
        }

        public Builder instanceConfigurationId(String instanceConfigurationId) {
            this.instanceConfigurationId = instanceConfigurationId;
            this.__explicitlySet__.add("instanceConfigurationId");
            return this;
        }

        public Instance build() {
            Instance model = new Instance(this.availabilityDomain, this.capacityReservationId, this.compartmentId, this.dedicatedVmHostId, this.definedTags, this.displayName, this.extendedMetadata, this.faultDomain, this.freeformTags, this.id, this.imageId, this.ipxeScript, this.launchMode, this.launchOptions, this.instanceOptions, this.availabilityConfig, this.preemptibleInstanceConfig, this.lifecycleState, this.metadata, this.region, this.shape, this.shapeConfig, this.isCrossNumaNode, this.sourceDetails, this.systemTags, this.timeCreated, this.agentConfig, this.timeMaintenanceRebootDue, this.platformConfig, this.instanceConfigurationId);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(Instance model) {
            if (model.wasPropertyExplicitlySet("availabilityDomain")) {
                this.availabilityDomain(model.getAvailabilityDomain());
            }
            if (model.wasPropertyExplicitlySet("capacityReservationId")) {
                this.capacityReservationId(model.getCapacityReservationId());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("dedicatedVmHostId")) {
                this.dedicatedVmHostId(model.getDedicatedVmHostId());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("extendedMetadata")) {
                this.extendedMetadata(model.getExtendedMetadata());
            }
            if (model.wasPropertyExplicitlySet("faultDomain")) {
                this.faultDomain(model.getFaultDomain());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("imageId")) {
                this.imageId(model.getImageId());
            }
            if (model.wasPropertyExplicitlySet("ipxeScript")) {
                this.ipxeScript(model.getIpxeScript());
            }
            if (model.wasPropertyExplicitlySet("launchMode")) {
                this.launchMode(model.getLaunchMode());
            }
            if (model.wasPropertyExplicitlySet("launchOptions")) {
                this.launchOptions(model.getLaunchOptions());
            }
            if (model.wasPropertyExplicitlySet("instanceOptions")) {
                this.instanceOptions(model.getInstanceOptions());
            }
            if (model.wasPropertyExplicitlySet("availabilityConfig")) {
                this.availabilityConfig(model.getAvailabilityConfig());
            }
            if (model.wasPropertyExplicitlySet("preemptibleInstanceConfig")) {
                this.preemptibleInstanceConfig(model.getPreemptibleInstanceConfig());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("metadata")) {
                this.metadata(model.getMetadata());
            }
            if (model.wasPropertyExplicitlySet("region")) {
                this.region(model.getRegion());
            }
            if (model.wasPropertyExplicitlySet("shape")) {
                this.shape(model.getShape());
            }
            if (model.wasPropertyExplicitlySet("shapeConfig")) {
                this.shapeConfig(model.getShapeConfig());
            }
            if (model.wasPropertyExplicitlySet("isCrossNumaNode")) {
                this.isCrossNumaNode(model.getIsCrossNumaNode());
            }
            if (model.wasPropertyExplicitlySet("sourceDetails")) {
                this.sourceDetails(model.getSourceDetails());
            }
            if (model.wasPropertyExplicitlySet("systemTags")) {
                this.systemTags(model.getSystemTags());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("agentConfig")) {
                this.agentConfig(model.getAgentConfig());
            }
            if (model.wasPropertyExplicitlySet("timeMaintenanceRebootDue")) {
                this.timeMaintenanceRebootDue(model.getTimeMaintenanceRebootDue());
            }
            if (model.wasPropertyExplicitlySet("platformConfig")) {
                this.platformConfig(model.getPlatformConfig());
            }
            if (model.wasPropertyExplicitlySet("instanceConfigurationId")) {
                this.instanceConfigurationId(model.getInstanceConfigurationId());
            }
            return this;
        }
    }
}

