/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class AppCatalogListingResourceVersion
extends ExplicitlySetBmcModel {
    @JsonProperty(value="listingId")
    private final String listingId;
    @JsonProperty(value="timePublished")
    private final Date timePublished;
    @JsonProperty(value="listingResourceId")
    private final String listingResourceId;
    @JsonProperty(value="listingResourceVersion")
    private final String listingResourceVersion;
    @JsonProperty(value="availableRegions")
    private final List<String> availableRegions;
    @JsonProperty(value="compatibleShapes")
    private final List<String> compatibleShapes;
    @JsonProperty(value="accessiblePorts")
    private final List<Integer> accessiblePorts;
    @JsonProperty(value="allowedActions")
    private final List<AllowedActions> allowedActions;

    @Deprecated
    @ConstructorProperties(value={"listingId", "timePublished", "listingResourceId", "listingResourceVersion", "availableRegions", "compatibleShapes", "accessiblePorts", "allowedActions"})
    public AppCatalogListingResourceVersion(String listingId, Date timePublished, String listingResourceId, String listingResourceVersion, List<String> availableRegions, List<String> compatibleShapes, List<Integer> accessiblePorts, List<AllowedActions> allowedActions) {
        this.listingId = listingId;
        this.timePublished = timePublished;
        this.listingResourceId = listingResourceId;
        this.listingResourceVersion = listingResourceVersion;
        this.availableRegions = availableRegions;
        this.compatibleShapes = compatibleShapes;
        this.accessiblePorts = accessiblePorts;
        this.allowedActions = allowedActions;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getListingId() {
        return this.listingId;
    }

    public Date getTimePublished() {
        return this.timePublished;
    }

    public String getListingResourceId() {
        return this.listingResourceId;
    }

    public String getListingResourceVersion() {
        return this.listingResourceVersion;
    }

    public List<String> getAvailableRegions() {
        return this.availableRegions;
    }

    public List<String> getCompatibleShapes() {
        return this.compatibleShapes;
    }

    public List<Integer> getAccessiblePorts() {
        return this.accessiblePorts;
    }

    public List<AllowedActions> getAllowedActions() {
        return this.allowedActions;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("AppCatalogListingResourceVersion(");
        sb.append("super=").append(super.toString());
        sb.append("listingId=").append(String.valueOf(this.listingId));
        sb.append(", timePublished=").append(String.valueOf(this.timePublished));
        sb.append(", listingResourceId=").append(String.valueOf(this.listingResourceId));
        sb.append(", listingResourceVersion=").append(String.valueOf(this.listingResourceVersion));
        sb.append(", availableRegions=").append(String.valueOf(this.availableRegions));
        sb.append(", compatibleShapes=").append(String.valueOf(this.compatibleShapes));
        sb.append(", accessiblePorts=").append(String.valueOf(this.accessiblePorts));
        sb.append(", allowedActions=").append(String.valueOf(this.allowedActions));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AppCatalogListingResourceVersion)) {
            return false;
        }
        AppCatalogListingResourceVersion other = (AppCatalogListingResourceVersion)((Object)o);
        return Objects.equals(this.listingId, other.listingId) && Objects.equals(this.timePublished, other.timePublished) && Objects.equals(this.listingResourceId, other.listingResourceId) && Objects.equals(this.listingResourceVersion, other.listingResourceVersion) && Objects.equals(this.availableRegions, other.availableRegions) && Objects.equals(this.compatibleShapes, other.compatibleShapes) && Objects.equals(this.accessiblePorts, other.accessiblePorts) && Objects.equals(this.allowedActions, other.allowedActions) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.listingId == null ? 43 : this.listingId.hashCode());
        result = result * 59 + (this.timePublished == null ? 43 : this.timePublished.hashCode());
        result = result * 59 + (this.listingResourceId == null ? 43 : this.listingResourceId.hashCode());
        result = result * 59 + (this.listingResourceVersion == null ? 43 : this.listingResourceVersion.hashCode());
        result = result * 59 + (this.availableRegions == null ? 43 : this.availableRegions.hashCode());
        result = result * 59 + (this.compatibleShapes == null ? 43 : this.compatibleShapes.hashCode());
        result = result * 59 + (this.accessiblePorts == null ? 43 : this.accessiblePorts.hashCode());
        result = result * 59 + (this.allowedActions == null ? 43 : this.allowedActions.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum AllowedActions implements BmcEnum
    {
        Snapshot("SNAPSHOT"),
        BootVolumeDetach("BOOT_VOLUME_DETACH"),
        PreserveBootVolume("PRESERVE_BOOT_VOLUME"),
        SerialConsoleAccess("SERIAL_CONSOLE_ACCESS"),
        BootRecovery("BOOT_RECOVERY"),
        BackupBootVolume("BACKUP_BOOT_VOLUME"),
        CaptureConsoleHistory("CAPTURE_CONSOLE_HISTORY"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, AllowedActions> map;

        private AllowedActions(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static AllowedActions create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'AllowedActions', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(AllowedActions.class);
            map = new HashMap<String, AllowedActions>();
            for (AllowedActions v : AllowedActions.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="listingId")
        private String listingId;
        @JsonProperty(value="timePublished")
        private Date timePublished;
        @JsonProperty(value="listingResourceId")
        private String listingResourceId;
        @JsonProperty(value="listingResourceVersion")
        private String listingResourceVersion;
        @JsonProperty(value="availableRegions")
        private List<String> availableRegions;
        @JsonProperty(value="compatibleShapes")
        private List<String> compatibleShapes;
        @JsonProperty(value="accessiblePorts")
        private List<Integer> accessiblePorts;
        @JsonProperty(value="allowedActions")
        private List<AllowedActions> allowedActions;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder listingId(String listingId) {
            this.listingId = listingId;
            this.__explicitlySet__.add("listingId");
            return this;
        }

        public Builder timePublished(Date timePublished) {
            this.timePublished = timePublished;
            this.__explicitlySet__.add("timePublished");
            return this;
        }

        public Builder listingResourceId(String listingResourceId) {
            this.listingResourceId = listingResourceId;
            this.__explicitlySet__.add("listingResourceId");
            return this;
        }

        public Builder listingResourceVersion(String listingResourceVersion) {
            this.listingResourceVersion = listingResourceVersion;
            this.__explicitlySet__.add("listingResourceVersion");
            return this;
        }

        public Builder availableRegions(List<String> availableRegions) {
            this.availableRegions = availableRegions;
            this.__explicitlySet__.add("availableRegions");
            return this;
        }

        public Builder compatibleShapes(List<String> compatibleShapes) {
            this.compatibleShapes = compatibleShapes;
            this.__explicitlySet__.add("compatibleShapes");
            return this;
        }

        public Builder accessiblePorts(List<Integer> accessiblePorts) {
            this.accessiblePorts = accessiblePorts;
            this.__explicitlySet__.add("accessiblePorts");
            return this;
        }

        public Builder allowedActions(List<AllowedActions> allowedActions) {
            this.allowedActions = allowedActions;
            this.__explicitlySet__.add("allowedActions");
            return this;
        }

        public AppCatalogListingResourceVersion build() {
            AppCatalogListingResourceVersion model = new AppCatalogListingResourceVersion(this.listingId, this.timePublished, this.listingResourceId, this.listingResourceVersion, this.availableRegions, this.compatibleShapes, this.accessiblePorts, this.allowedActions);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(AppCatalogListingResourceVersion model) {
            if (model.wasPropertyExplicitlySet("listingId")) {
                this.listingId(model.getListingId());
            }
            if (model.wasPropertyExplicitlySet("timePublished")) {
                this.timePublished(model.getTimePublished());
            }
            if (model.wasPropertyExplicitlySet("listingResourceId")) {
                this.listingResourceId(model.getListingResourceId());
            }
            if (model.wasPropertyExplicitlySet("listingResourceVersion")) {
                this.listingResourceVersion(model.getListingResourceVersion());
            }
            if (model.wasPropertyExplicitlySet("availableRegions")) {
                this.availableRegions(model.getAvailableRegions());
            }
            if (model.wasPropertyExplicitlySet("compatibleShapes")) {
                this.compatibleShapes(model.getCompatibleShapes());
            }
            if (model.wasPropertyExplicitlySet("accessiblePorts")) {
                this.accessiblePorts(model.getAccessiblePorts());
            }
            if (model.wasPropertyExplicitlySet("allowedActions")) {
                this.allowedActions(model.getAllowedActions());
            }
            return this;
        }
    }
}

