/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.multiview.ui;

import java.awt.Container;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import org.netbeans.modules.xml.multiview.SectionNode;
import org.netbeans.modules.xml.multiview.Utils;
import org.netbeans.modules.xml.multiview.ui.BoxPanel;
import org.netbeans.modules.xml.multiview.ui.SectionInnerPanel;
import org.netbeans.modules.xml.multiview.ui.SectionNodeInnerPanel;
import org.netbeans.modules.xml.multiview.ui.SectionPanel;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.openide.nodes.Node;

public class SectionNodePanel
extends SectionPanel {
    private final boolean openFirstChild;

    public SectionNodePanel(SectionNode node) {
        this(node, true);
    }

    public SectionNodePanel(final SectionNode node, boolean openFirstChild) {
        super((SectionView)node.getSectionNodeView(), (Node)node, node.getDisplayName(), (Object)node);
        this.openFirstChild = openFirstChild;
        if (node.getKey() instanceof SectionView) {
            this.setInnerViewMode();
        } else if (node.isExpanded()) {
            this.setExpandedViewMode();
        }
        node.addPropertyChangeListener(new PropertyChangeListener(){
            final /* synthetic */ SectionNodePanel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("displayName".equals(evt.getPropertyName())) {
                    this.this$0.setTitle(node.getDisplayName());
                }
            }
        });
    }

    protected void setExpandedViewMode() {
        this.getTitleButton().setVisible(true);
        this.getFoldButton().setVisible(false);
        this.getHeaderSeparator().setVisible(false);
        EmptyBorder emptyBorder = new EmptyBorder(0, 4, 4, 4);
        Border lineBorder = new JTextField().getBorder();
        this.setBorder(new CompoundBorder(emptyBorder, new CompoundBorder(lineBorder, emptyBorder)));
        this.openInnerPanel();
        this.getFillerLine().setVisible(false);
        this.getFillerEnd().setVisible(false);
    }

    protected void setInnerViewMode() {
        this.getTitleButton().setVisible(false);
        this.getFoldButton().setVisible(false);
        this.getHeaderSeparator().setVisible(false);
        this.openInnerPanel();
        this.getFillerLine().setVisible(false);
        this.getFillerEnd().setVisible(false);
    }

    @Override
    protected SectionInnerPanel createInnerpanel() {
        SectionNodeInnerPanel innerPanel = ((SectionNode)this.getNode()).createInnerPanel();
        if (innerPanel == null) {
            innerPanel = new BoxPanel(((SectionNode)this.getNode()).getSectionNodeView());
        }
        return innerPanel;
    }

    @Override
    protected void openInnerPanel() {
        Node[] childNodes;
        super.openInnerPanel();
        if (this.openFirstChild && (childNodes = ((SectionNode)this.getNode()).getChildren().getNodes()) != null && childNodes.length > 0) {
            SectionNodePanel panel = ((SectionNode)childNodes[0]).getSectionNodePanel();
            panel.getFoldButton().setSelected(true);
            panel.openInnerPanel();
        }
    }

    @Override
    protected void closeInnerPanel() {
        if (this.getFoldButton().isVisible()) {
            if (this.getSectionView().getActivePanel() == this) {
                for (Container parent = this.getParent(); parent != null; parent = parent.getParent()) {
                    if (!(parent instanceof SectionPanel)) continue;
                    final SectionPanel sectionPanel = (SectionPanel)parent;
                    Utils.runInAwtDispatchThread(new Runnable(){
                        final /* synthetic */ SectionNodePanel this$0;
                        {
                            this.this$0 = this$0;
                        }

                        @Override
                        public void run() {
                            sectionPanel.setActive(true);
                        }
                    });
                    break;
                }
            }
            super.closeInnerPanel();
        }
    }

    @Override
    public void open() {
        Node parentNode = this.getNode().getParentNode();
        if (parentNode instanceof SectionNode) {
            ((SectionNode)parentNode).getSectionNodePanel().open();
        }
        if (this.getInnerPanel() == null) {
            super.open();
        }
    }
}

