/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.metadata.model.jdbc;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.db.metadata.model.MetadataUtilities;
import org.netbeans.modules.db.metadata.model.api.Column;
import org.netbeans.modules.db.metadata.model.api.MetadataException;
import org.netbeans.modules.db.metadata.model.api.Parameter;
import org.netbeans.modules.db.metadata.model.api.Schema;
import org.netbeans.modules.db.metadata.model.api.Value;
import org.netbeans.modules.db.metadata.model.jdbc.JDBCColumn;
import org.netbeans.modules.db.metadata.model.jdbc.JDBCParameter;
import org.netbeans.modules.db.metadata.model.jdbc.JDBCSchema;
import org.netbeans.modules.db.metadata.model.jdbc.JDBCUtils;
import org.netbeans.modules.db.metadata.model.jdbc.JDBCValue;
import org.netbeans.modules.db.metadata.model.spi.ProcedureImplementation;

public class JDBCProcedure
extends ProcedureImplementation {
    private static final Logger LOGGER = Logger.getLogger(JDBCProcedure.class.getName());
    private final JDBCSchema jdbcSchema;
    private final String name;
    private Map<String, Column> columns;
    private Map<String, Parameter> parameters;
    private Value returnValue;

    public JDBCProcedure(JDBCSchema jdbcSchema, String name) {
        this.jdbcSchema = jdbcSchema;
        this.name = name;
    }

    @Override
    public final Schema getParent() {
        return this.jdbcSchema.getSchema();
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final Collection<Column> getColumns() {
        return this.initColumns().values();
    }

    @Override
    public final Column getColumn(String name) {
        return MetadataUtilities.find(name, this.initColumns());
    }

    @Override
    public final void refresh() {
        this.columns = null;
        this.parameters = null;
    }

    @Override
    public Collection<Parameter> getParameters() {
        return this.initParameters().values();
    }

    @Override
    public Parameter getParameter(String name) {
        return this.initParameters().get(name);
    }

    @Override
    public Value getReturnValue() {
        return this.initReturnValue();
    }

    public String toString() {
        return "JDBCProcedure[name='" + this.name + "']";
    }

    protected JDBCColumn createJDBCColumn(int position, ResultSet rs) throws SQLException {
        return new JDBCColumn(this.getProcedure(), position, JDBCValue.createProcedureValue(rs, this.getProcedure()));
    }

    protected JDBCParameter createJDBCParameter(int position, ResultSet rs) throws SQLException {
        Parameter.Direction direction = JDBCUtils.getProcedureDirection(rs.getShort("COLUMN_TYPE"));
        return new JDBCParameter(this.getProcedure(), JDBCValue.createProcedureValue(rs, this.getProcedure()), direction, position);
    }

    protected JDBCValue createJDBCValue(ResultSet rs) throws SQLException {
        return JDBCValue.createProcedureValue(rs, this.getProcedure());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void createProcedureInfo() {
        LOGGER.log(Level.FINE, "Initializing procedure info in {0}", this);
        LinkedHashMap<String, Column> newColumns = new LinkedHashMap<String, Column>();
        LinkedHashMap<String, Parameter> newParams = new LinkedHashMap<String, Parameter>();
        int resultCount = 0;
        int paramCount = 0;
        DatabaseMetaData dmd = this.jdbcSchema.getJDBCCatalog().getJDBCMetadata().getDmd();
        String catalogName = this.jdbcSchema.getJDBCCatalog().getName();
        String schemaName = this.jdbcSchema.getName();
        try (ResultSet rs = dmd.getProcedureColumns(catalogName, schemaName, this.name, "%");){
            block13: while (rs.next()) {
                short columnType = rs.getShort("COLUMN_TYPE");
                switch (columnType) {
                    case 3: {
                        this.addColumn(++resultCount, rs, newColumns);
                        continue block13;
                    }
                    case 0: 
                    case 1: 
                    case 2: 
                    case 4: {
                        this.addParameter(++paramCount, rs, newParams);
                        continue block13;
                    }
                    case 5: {
                        this.setReturnValue(rs);
                        continue block13;
                    }
                }
                LOGGER.log(Level.INFO, "Encountered unexpected column type {0} when retrieving metadadta for procedure {1}", new Object[]{columnType, this.name});
            }
        }
        catch (RuntimeException e) {
            throw new RuntimeException(String.format("Failed to retrieve procedure info for catalog: '%s', schema: '%s', procedure: '%s'", catalogName, schemaName, this.name), e);
        }
        catch (SQLException e) {
            throw new MetadataException(String.format("Failed to retrieve procedure info for catalog: '%s', schema: '%s', procedure: '%s'", catalogName, schemaName, this.name), e);
        }
        this.columns = Collections.unmodifiableMap(newColumns);
        this.parameters = Collections.unmodifiableMap(newParams);
    }

    private void addColumn(int position, ResultSet rs, Map<String, Column> newColumns) throws SQLException {
        Column column = this.createJDBCColumn(position, rs).getColumn();
        newColumns.put(column.getName(), column);
        LOGGER.log(Level.FINE, "Created column {0}", column);
    }

    private void addParameter(int position, ResultSet rs, Map<String, Parameter> newParams) throws SQLException {
        Parameter param = this.createJDBCParameter(position, rs).getParameter();
        newParams.put(param.getName(), param);
        LOGGER.log(Level.FINE, "Created parameter {0}", param);
    }

    private void setReturnValue(ResultSet rs) throws SQLException {
        this.returnValue = this.createJDBCValue(rs).getValue();
        LOGGER.log(Level.FINE, "Created return value {0}", this.returnValue);
    }

    private Map<String, Column> initColumns() {
        if (this.columns != null) {
            return this.columns;
        }
        this.createProcedureInfo();
        return this.columns;
    }

    private Map<String, Parameter> initParameters() {
        if (this.parameters != null) {
            return this.parameters;
        }
        this.createProcedureInfo();
        return this.parameters;
    }

    private Value initReturnValue() {
        if (this.parameters != null) {
            return this.returnValue;
        }
        this.createProcedureInfo();
        return this.returnValue;
    }
}

