/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins;

import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.builtins.JSNonProxy;
import com.oracle.truffle.js.runtime.builtins.JSObjectFactory;
import com.oracle.truffle.js.runtime.builtins.JSOrdinary;
import com.oracle.truffle.js.runtime.builtins.JSRawJSONObject;
import com.oracle.truffle.js.runtime.objects.JSAttributes;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSShape;
import com.oracle.truffle.js.runtime.objects.Null;
import com.oracle.truffle.js.runtime.objects.PropertyProxy;

public final class JSRawJSON
extends JSNonProxy {
    public static final JSRawJSON INSTANCE = new JSRawJSON();
    public static final PropertyProxy RAW_JSON_PROXY = new PropertyProxy(){

        @Override
        public Object get(JSDynamicObject store) {
            return ((JSRawJSONObject)store).getRawJSON();
        }
    };

    private JSRawJSON() {
    }

    public static JSRawJSONObject create(JSContext context, JSRealm realm, TruffleString value) {
        JSObjectFactory factory = context.getRawJSONFactory();
        Shape shape = factory.getShape(realm);
        JSRawJSONObject newObj = new JSRawJSONObject(shape, value);
        return factory.trackAllocation(newObj);
    }

    public static Shape makeInitialShape(JSContext context) {
        Shape initialShape = JSShape.newBuilder(context, INSTANCE, Null.instance).shapeFlags(7).addConstantProperty((Object)JSObject.HIDDEN_PROTO, (Object)Null.instance, 0).addConstantProperty((Object)Strings.RAW_JSON, (Object)RAW_JSON_PROXY, 0x10 | JSAttributes.notConfigurableEnumerableNotWritable()).build();
        return initialShape;
    }

    @Override
    public TruffleString getClassName(JSDynamicObject object) {
        return JSOrdinary.CLASS_NAME;
    }
}

