/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seplatform.platformdefinition;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharConversionException;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.queries.SourceLevelQuery;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.java.j2seplatform.platformdefinition.DefaultPlatformImpl;
import org.netbeans.modules.java.j2seplatform.platformdefinition.J2SEPlatformImpl;
import org.netbeans.modules.java.j2seplatform.platformdefinition.J2SEPlatformNode;
import org.netbeans.modules.java.j2seplatform.platformdefinition.Util;
import org.netbeans.modules.java.j2seplatform.wizard.J2SEWizardIterator;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.Environment;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.XMLDataObject;
import org.openide.modules.SpecificationVersion;
import org.openide.nodes.Node;
import org.openide.util.BaseUtilities;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class PlatformConvertor
implements Environment.Provider,
InstanceCookie.Of,
PropertyChangeListener,
Runnable,
InstanceContent.Convertor<Class<Node>, Node> {
    private static final Logger LOG = Logger.getLogger(PlatformConvertor.class.getName());
    private static final String CLASSIC = "classic";
    private static final String MODERN = "modern";
    private static final String JAVAC13 = "javac1.3";
    public static final String[] IMPORTANT_TOOLS = new String[]{"javac", "java", "javadoc"};
    private static final String PLATFORM_STOREGE = "Services/Platforms/org-netbeans-api-java-Platform";
    private static final String PLATFORM_DTD_ID = "-//NetBeans//DTD Java PlatformDefinition 1.0//EN";
    private static final String URL_EMBEDDING = "!/";
    private static final RequestProcessor RP = new RequestProcessor(PlatformConvertor.class.getName(), 1, false, false);
    private InstanceContent cookies = new InstanceContent();
    private XMLDataObject holder;
    private boolean defaultPlatform;
    private Lookup lookup;
    private RequestProcessor.Task saveTask;
    private Reference<JavaPlatform> refPlatform = new WeakReference<Object>(null);
    private LinkedList<PropertyChangeEvent> keepAlive = new LinkedList();
    private static final int DELAY = 2000;
    static final String ELEMENT_PROPERTIES = "properties";
    static final String ELEMENT_SYSPROPERTIES = "sysproperties";
    static final String ELEMENT_PROPERTY = "property";
    static final String ELEMENT_PLATFORM = "platform";
    static final String ELEMENT_JDKHOME = "jdkhome";
    static final String ELEMENT_SOURCEPATH = "sources";
    static final String ELEMENT_JAVADOC = "javadoc";
    static final String ELEMENT_RESOURCE = "resource";
    static final String ATTR_PLATFORM_NAME = "name";
    static final String ATTR_PLATFORM_DEFAULT = "default";
    static final String ATTR_PROPERTY_NAME = "name";
    static final String ATTR_PROPERTY_VALUE = "value";

    private PlatformConvertor() {
    }

    public static PlatformConvertor createProvider(FileObject reg) {
        return new PlatformConvertor();
    }

    public Lookup getEnvironment(DataObject obj) {
        if (obj instanceof XMLDataObject) {
            return new PlatformConvertor((XMLDataObject)obj).getLookup();
        }
        return Lookup.EMPTY;
    }

    private PlatformConvertor(@NonNull XMLDataObject object) {
        Parameters.notNull((CharSequence)"object", (Object)object);
        this.holder = object;
        this.holder.getPrimaryFile().addFileChangeListener((FileChangeListener)new FileChangeAdapter(){

            public void fileDeleted(final FileEvent fe) {
                if (!PlatformConvertor.this.defaultPlatform) {
                    try {
                        ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){
                            final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = this$1;
                            }

                            public Void run() throws IOException {
                                String systemName = fe.getFile().getName();
                                String propPrefix = "platforms." + systemName + ".";
                                boolean changed = false;
                                EditableProperties props = PropertyUtils.getGlobalProperties();
                                Iterator it = props.keySet().iterator();
                                while (it.hasNext()) {
                                    String key = (String)it.next();
                                    if (!key.startsWith(propPrefix)) continue;
                                    it.remove();
                                    changed = true;
                                }
                                if (changed) {
                                    PropertyUtils.putGlobalProperties((EditableProperties)props);
                                }
                                return null;
                            }
                        });
                    }
                    catch (MutexException e) {
                        Exceptions.printStackTrace((Throwable)e);
                    }
                }
            }
        });
        this.cookies = new InstanceContent();
        this.cookies.add((Object)this);
        this.lookup = new AbstractLookup((AbstractLookup.Content)this.cookies);
        this.cookies.add(Node.class, (InstanceContent.Convertor)this);
    }

    Lookup getLookup() {
        return this.lookup;
    }

    public Class instanceClass() {
        return JavaPlatform.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object instanceCreate() throws IOException, ClassNotFoundException {
        PlatformConvertor platformConvertor = this;
        synchronized (platformConvertor) {
            JavaPlatform o = this.refPlatform.get();
            if (o != null) {
                return o;
            }
            H handler = new H();
            try {
                XMLReader reader = XMLUtil.createXMLReader();
                InputSource is = new InputSource(this.holder.getPrimaryFile().getInputStream());
                is.setSystemId(this.holder.getPrimaryFile().toURL().toExternalForm());
                reader.setContentHandler(handler);
                reader.setErrorHandler(handler);
                reader.setEntityResolver(handler);
                reader.parse(is);
            }
            catch (SAXException ex) {
                Exception cause = ex.getException();
                if (cause instanceof IOException) {
                    throw (IOException)cause;
                }
                throw new IOException(cause);
            }
            JavaPlatform inst = this.createPlatform(handler);
            this.refPlatform = new WeakReference<JavaPlatform>(inst);
            return inst;
        }
    }

    JavaPlatform createPlatform(H handler) throws IOException {
        JavaPlatform p;
        if (handler.isDefault) {
            p = DefaultPlatformImpl.create(handler.properties, handler.sources, handler.javadoc);
            this.defaultPlatform = true;
        } else {
            p = new J2SEPlatformImpl(handler.name, handler.installFolders, handler.properties, Util.filterProbe(handler.sysProperties, null), handler.sources, handler.javadoc);
            this.defaultPlatform = false;
        }
        this.validate(p);
        p.addPropertyChangeListener((PropertyChangeListener)this);
        return p;
    }

    public String instanceName() {
        return this.holder.getName();
    }

    public boolean instanceOf(Class<?> type) {
        return type.isAssignableFrom(JavaPlatform.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        PlatformConvertor platformConvertor = this;
        synchronized (platformConvertor) {
            if (this.saveTask == null) {
                this.saveTask = RP.create((Runnable)this);
            }
        }
        platformConvertor = this;
        synchronized (platformConvertor) {
            this.keepAlive.add(evt);
        }
        this.saveTask.schedule(2000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        PropertyChangeEvent e;
        PlatformConvertor platformConvertor = this;
        synchronized (platformConvertor) {
            e = this.keepAlive.removeFirst();
        }
        J2SEPlatformImpl plat = (J2SEPlatformImpl)e.getSource();
        try {
            this.holder.getPrimaryFile().getFileSystem().runAtomicAction((FileSystem.AtomicAction)new W(plat, (MultiDataObject)this.holder, this.defaultPlatform));
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)Exceptions.attachSeverity((Throwable)ex, (Level)Level.INFO));
        }
    }

    public Node convert(Class<Node> key) {
        try {
            J2SEPlatformImpl p = (J2SEPlatformImpl)this.instanceCreate();
            return new J2SEPlatformNode(p, (DataObject)this.holder);
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    public String displayName(Class<Node> key) {
        return key.getName();
    }

    public String id(Class<Node> key) {
        return key.getName();
    }

    public Class<Node> type(Class<Node> key) {
        return key;
    }

    public static JavaPlatform create(J2SEPlatformImpl prototype) throws IOException, IllegalArgumentException {
        Parameters.notNull((CharSequence)"prototype", (Object)prototype);
        String systemName = prototype.getProperties().get("platform.ant.name");
        if (systemName == null) {
            throw new IllegalArgumentException("platform.ant.name");
        }
        FileObject platformsFolder = FileUtil.getConfigFile((String)PLATFORM_STOREGE);
        if (platformsFolder.getFileObject(systemName, "xml") != null) {
            throw new IllegalArgumentException(systemName);
        }
        DataObject dobj = PlatformConvertor.create(prototype, DataFolder.findFolder((FileObject)platformsFolder), systemName);
        return (JavaPlatform)dobj.getNodeDelegate().getLookup().lookup(JavaPlatform.class);
    }

    @NonNull
    public static String getFreeAntName(@NonNull String name) {
        String antName;
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException();
        }
        FileObject platformsFolder = FileUtil.getConfigFile((String)PLATFORM_STOREGE);
        if (platformsFolder.getFileObject(antName = PropertyUtils.getUsablePropertyName((String)name), "xml") != null) {
            String baseName = antName;
            int index = 1;
            antName = baseName + Integer.toString(index);
            while (platformsFolder.getFileObject(antName, "xml") != null) {
                antName = baseName + Integer.toString(++index);
            }
        }
        return antName;
    }

    public static void generatePlatformProperties(JavaPlatform platform, String systemName, EditableProperties props) throws IOException {
        String homePropName = PlatformConvertor.createName(systemName, "home");
        String bootClassPathPropName = PlatformConvertor.createName(systemName, "bootclasspath");
        String compilerType = PlatformConvertor.createName(systemName, "compiler");
        if (props.getProperty(homePropName) != null || props.getProperty(bootClassPathPropName) != null || props.getProperty(compilerType) != null) {
            String msg = NbBundle.getMessage(J2SEWizardIterator.class, (String)"ERROR_InvalidName");
            throw (IllegalStateException)Exceptions.attachLocalizedMessage((Throwable)new IllegalStateException(msg), (String)msg);
        }
        Collection installFolders = platform.getInstallFolders();
        if (installFolders.size() > 0) {
            File jdkHome = FileUtil.toFile((FileObject)((FileObject)installFolders.iterator().next()));
            props.setProperty(homePropName, jdkHome.getAbsolutePath());
            ClassPath bootCP = platform.getBootstrapLibraries();
            StringBuilder sbootcp = new StringBuilder();
            for (ClassPath.Entry entry : bootCP.entries()) {
                URL url = entry.getURL();
                String pathInArchive = "";
                boolean wasFolder = false;
                if (FileUtil.isArchiveArtifact((URL)url)) {
                    String path = url.getPath();
                    int index = path.lastIndexOf(URL_EMBEDDING);
                    if (index >= 0) {
                        wasFolder = index > 0 && path.charAt(index - 1) == '/';
                        pathInArchive = path.substring(index + URL_EMBEDDING.length());
                    }
                    url = FileUtil.getArchiveFile((URL)url);
                }
                String rootPath = BaseUtilities.toFile((URI)URI.create(url.toExternalForm())).getAbsolutePath();
                if (!pathInArchive.isEmpty()) {
                    StringBuilder rpb = new StringBuilder(rootPath.length() + File.separator.length() + URL_EMBEDDING.length() + pathInArchive.length());
                    rpb.append(rootPath);
                    if (wasFolder && !rootPath.endsWith(File.separator)) {
                        rpb.append(File.separator);
                    }
                    rpb.append(URL_EMBEDDING);
                    rpb.append(pathInArchive);
                    rootPath = rpb.toString();
                }
                if (sbootcp.length() > 0) {
                    sbootcp.append(File.pathSeparator);
                }
                sbootcp.append(PlatformConvertor.normalizePath(rootPath, jdkHome, homePropName));
            }
            if (sbootcp != null) {
                props.setProperty(bootClassPathPropName, sbootcp.toString());
            }
            props.setProperty(compilerType, PlatformConvertor.getCompilerType(platform));
            for (int i = 0; i < IMPORTANT_TOOLS.length; ++i) {
                String name = IMPORTANT_TOOLS[i];
                FileObject tool = platform.findTool(name);
                if (tool != null) {
                    if (PlatformConvertor.isDefaultLocation(tool, platform.getInstallFolders())) continue;
                    String toolName = PlatformConvertor.createName(systemName, name);
                    props.setProperty(toolName, PlatformConvertor.normalizePath(PlatformConvertor.getToolPath(tool), jdkHome, homePropName));
                    continue;
                }
                throw new BrokenPlatformException(name);
            }
        }
    }

    public static String createName(String platName, String propType) {
        return "platforms." + platName + "." + propType;
    }

    private void validate(@NonNull JavaPlatform plat) throws IOException {
        SpecificationVersion ver = plat.getSpecification().getVersion();
        if (ver.compareTo(SourceLevelQuery.MINIMAL_SOURCE_LEVEL) < 0) {
            IOException veto = new IOException(String.format("Unsupported platform source level: %s", ver));
            throw (IOException)Exceptions.attachSeverity((Throwable)veto, (Level)Level.FINEST);
        }
    }

    private static DataObject create(final J2SEPlatformImpl plat, DataFolder f, final String idName) throws IOException {
        W w = new W(plat, f, idName);
        f.getPrimaryFile().getFileSystem().runAtomicAction((FileSystem.AtomicAction)w);
        try {
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                public Void run() throws Exception {
                    EditableProperties props = PropertyUtils.getGlobalProperties();
                    PlatformConvertor.generatePlatformProperties(plat, idName, props);
                    PropertyUtils.putGlobalProperties((EditableProperties)props);
                    return null;
                }
            });
        }
        catch (MutexException me) {
            Exception originalException = me.getException();
            if (originalException instanceof RuntimeException) {
                throw (RuntimeException)originalException;
            }
            if (originalException instanceof IOException) {
                throw (IOException)originalException;
            }
            throw new IllegalStateException();
        }
        return w.holder;
    }

    private static String getCompilerType(JavaPlatform platform) {
        assert (platform != null);
        String prop = (String)platform.getSystemProperties().get("java.specification.version");
        if (prop == null) {
            LOG.log(Level.INFO, "Broken platform system properties, no java.specification.version", new IllegalArgumentException(String.format("platform: %s System Properties: %s", platform.getDisplayName(), platform.getSystemProperties())));
            return MODERN;
        }
        SpecificationVersion specificationVersion = new SpecificationVersion(prop);
        SpecificationVersion jdk13 = new SpecificationVersion("1.3");
        int c = specificationVersion.compareTo(jdk13);
        if (c < 0) {
            return CLASSIC;
        }
        if (c == 0) {
            return JAVAC13;
        }
        return MODERN;
    }

    private static boolean isDefaultLocation(FileObject tool, Collection<FileObject> installFolders) {
        assert (tool != null && installFolders != null);
        if (installFolders.size() != 1) {
            return false;
        }
        FileObject root = installFolders.iterator().next();
        String relativePath = FileUtil.getRelativePath((FileObject)root, (FileObject)tool);
        if (relativePath == null) {
            return false;
        }
        StringTokenizer tk = new StringTokenizer(relativePath, "/");
        return tk.countTokens() == 2 && "bin".equals(tk.nextToken());
    }

    private static File getToolPath(FileObject tool) {
        assert (tool != null);
        return Utilities.toFile((URI)URI.create(tool.toURL().toExternalForm()));
    }

    private static String normalizePath(File path, File jdkHome, String propName) {
        return PlatformConvertor.normalizePath(path.getAbsolutePath(), jdkHome, propName);
    }

    private static String normalizePath(String absolutePath, File jdkHome, String propName) {
        String jdkLoc = jdkHome.getAbsolutePath();
        if (!jdkLoc.endsWith(File.separator)) {
            jdkLoc = jdkLoc + File.separator;
        }
        if (absolutePath.startsWith(jdkLoc)) {
            return "${" + propName + "}" + File.separator + absolutePath.substring(jdkLoc.length());
        }
        return absolutePath;
    }

    private static final class H
    extends DefaultHandler
    implements EntityResolver {
        Map<String, String> properties;
        Map<String, String> sysProperties;
        List<URL> sources;
        List<URL> javadoc;
        List<URL> installFolders;
        String name;
        boolean isDefault;
        private Map<String, String> propertyMap;
        private StringBuffer buffer;
        private List<URL> path;

        private H() {
        }

        @Override
        public void startDocument() throws SAXException {
        }

        @Override
        public void endDocument() throws SAXException {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
            if (qName != null) {
                switch (qName) {
                    case "platform": {
                        this.name = attrs.getValue("name");
                        this.isDefault = "yes".equals(attrs.getValue(PlatformConvertor.ATTR_PLATFORM_DEFAULT));
                        break;
                    }
                    case "properties": {
                        if (this.properties == null) {
                            this.properties = new HashMap<String, String>(17);
                        }
                        this.propertyMap = this.properties;
                        break;
                    }
                    case "sysproperties": {
                        if (this.sysProperties == null) {
                            this.sysProperties = new HashMap<String, String>(17);
                        }
                        this.propertyMap = this.sysProperties;
                        break;
                    }
                    case "property": {
                        if (this.propertyMap == null) {
                            throw new SAXException("property w/o properties or sysproperties");
                        }
                        String name = attrs.getValue("name");
                        if (name == null || "".equals(name)) {
                            throw new SAXException("missing name");
                        }
                        String val = attrs.getValue(PlatformConvertor.ATTR_PROPERTY_VALUE);
                        this.propertyMap.put(name, val);
                        break;
                    }
                    case "sources": {
                        this.sources = new ArrayList<URL>();
                        this.path = this.sources;
                        break;
                    }
                    case "javadoc": {
                        this.javadoc = new ArrayList<URL>();
                        this.path = this.javadoc;
                        break;
                    }
                    case "jdkhome": {
                        this.installFolders = new ArrayList<URL>();
                        this.path = this.installFolders;
                        break;
                    }
                    case "resource": {
                        this.buffer = new StringBuffer();
                    }
                }
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (qName != null) {
                switch (qName) {
                    case "properties": 
                    case "sysproperties": {
                        this.propertyMap = null;
                        break;
                    }
                    case "sources": 
                    case "javadoc": {
                        this.path = null;
                        break;
                    }
                    case "resource": {
                        try {
                            this.path.add(new URL(this.buffer.toString()));
                        }
                        catch (MalformedURLException mue) {
                            Exceptions.printStackTrace((Throwable)mue);
                        }
                        this.buffer = null;
                    }
                }
            }
        }

        @Override
        public void characters(char[] chars, int start, int length) throws SAXException {
            if (this.buffer != null) {
                this.buffer.append(chars, start, length);
            }
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
            if (PlatformConvertor.PLATFORM_DTD_ID.equals(publicId)) {
                return new InputSource(new ByteArrayInputStream(new byte[0]));
            }
            return null;
        }
    }

    private static final class W
    implements FileSystem.AtomicAction {
        J2SEPlatformImpl instance;
        MultiDataObject holder;
        String name;
        DataFolder f;
        boolean defaultPlatform;

        W(J2SEPlatformImpl instance, MultiDataObject holder, boolean defaultPlatform) {
            this.instance = instance;
            this.holder = holder;
            this.defaultPlatform = defaultPlatform;
        }

        W(J2SEPlatformImpl instance, DataFolder f, String n) {
            this.instance = instance;
            this.name = n;
            this.f = f;
            this.defaultPlatform = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() throws IOException {
            FileLock lck;
            FileObject data;
            try (ByteArrayOutputStream buffer = new ByteArrayOutputStream();){
                this.write(buffer);
            }
            if (this.holder != null) {
                data = this.holder.getPrimaryEntry().getFile();
                lck = this.holder.getPrimaryEntry().takeLock();
            } else {
                FileObject folder = this.f.getPrimaryFile();
                String fn = FileUtil.findFreeFileName((FileObject)folder, (String)this.name, (String)"xml");
                data = folder.createData(fn, "xml");
                lck = data.lock();
            }
            try (OutputStream out = data.getOutputStream(lck);){
                out.write(buffer.toByteArray());
                out.flush();
            }
            finally {
                lck.releaseLock();
            }
            if (this.holder == null) {
                this.holder = (MultiDataObject)DataObject.find((FileObject)data);
            }
        }

        void write(OutputStream out) throws IOException {
            List<URL> pdl;
            List psl;
            Map<String, String> props = this.instance.getProperties();
            Map sysProps = this.instance.getSystemProperties();
            Document doc = XMLUtil.createDocument((String)PlatformConvertor.ELEMENT_PLATFORM, null, (String)PlatformConvertor.PLATFORM_DTD_ID, (String)"http://www.netbeans.org/dtds/java-platformdefinition-1_0.dtd");
            Element platformElement = doc.getDocumentElement();
            platformElement.setAttribute("name", this.instance.getDisplayName());
            platformElement.setAttribute(PlatformConvertor.ATTR_PLATFORM_DEFAULT, this.defaultPlatform ? "yes" : "no");
            if (!this.defaultPlatform) {
                Element jdkHomeElement = doc.createElement(PlatformConvertor.ELEMENT_JDKHOME);
                Iterator<FileObject> it = this.instance.getInstallFolders().iterator();
                while (it.hasNext()) {
                    URL url = it.next().toURL();
                    Element resourceElement = doc.createElement(PlatformConvertor.ELEMENT_RESOURCE);
                    resourceElement.appendChild(doc.createTextNode(url.toExternalForm()));
                    jdkHomeElement.appendChild(resourceElement);
                }
                platformElement.appendChild(jdkHomeElement);
            }
            Element propsElement = doc.createElement(PlatformConvertor.ELEMENT_PROPERTIES);
            this.writeProperties(props, propsElement, doc);
            platformElement.appendChild(propsElement);
            if (!this.defaultPlatform) {
                Element sysPropsElement = doc.createElement(PlatformConvertor.ELEMENT_SYSPROPERTIES);
                this.writeProperties(sysProps, sysPropsElement, doc);
                platformElement.appendChild(sysPropsElement);
            }
            if ((psl = this.instance.getSourceFolders().entries()).size() > 0 && this.shouldWriteSources()) {
                Element sourcesElement = doc.createElement(PlatformConvertor.ELEMENT_SOURCEPATH);
                Iterator it = psl.iterator();
                while (it.hasNext()) {
                    URL url = ((ClassPath.Entry)it.next()).getURL();
                    Element resourceElement = doc.createElement(PlatformConvertor.ELEMENT_RESOURCE);
                    resourceElement.appendChild(doc.createTextNode(url.toExternalForm()));
                    sourcesElement.appendChild(resourceElement);
                }
                platformElement.appendChild(sourcesElement);
            }
            if ((pdl = this.instance.getJavadocFolders()).size() > 0 && this.shouldWriteJavadoc()) {
                Element javadocElement = doc.createElement(PlatformConvertor.ELEMENT_JAVADOC);
                for (URL url : pdl) {
                    Element resourceElement = doc.createElement(PlatformConvertor.ELEMENT_RESOURCE);
                    resourceElement.appendChild(doc.createTextNode(url.toExternalForm()));
                    javadocElement.appendChild(resourceElement);
                }
                platformElement.appendChild(javadocElement);
            }
            XMLUtil.write((Document)doc, (OutputStream)out, (String)"UTF8");
        }

        void writeProperties(Map<String, String> props, Element element, Document doc) throws IOException {
            TreeSet<String> sortedProps = new TreeSet<String>(props.keySet());
            for (String n : sortedProps) {
                String val = props.get(n);
                try {
                    XMLUtil.toAttributeValue((String)n);
                    XMLUtil.toAttributeValue((String)val);
                    Element propElement = doc.createElement(PlatformConvertor.ELEMENT_PROPERTY);
                    propElement.setAttribute("name", n);
                    propElement.setAttribute(PlatformConvertor.ATTR_PROPERTY_VALUE, val);
                    element.appendChild(propElement);
                }
                catch (CharConversionException e) {
                    LOG.log(Level.WARNING, "Cannot store property: {0} value: {1}", new Object[]{n, val});
                }
            }
        }

        private boolean shouldWriteSources() {
            ArrayList<URL> roots = new ArrayList<URL>();
            for (ClassPath.Entry entry : this.instance.getSourceFolders().entries()) {
                roots.add(entry.getURL());
            }
            return !roots.equals(this.instance.defaultSources());
        }

        private boolean shouldWriteJavadoc() {
            return !this.instance.getJavadocFolders().equals(this.instance.defaultJavadoc());
        }
    }

    public static class BrokenPlatformException
    extends IOException {
        private final String toolName;

        public BrokenPlatformException(String toolName) {
            super("Cannot locate " + toolName + " command");
            this.toolName = toolName;
        }

        public String getMissingTool() {
            return this.toolName;
        }
    }
}

