/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.bookmark;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.time.LocalDate;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import mediathek.daten.DatenFilm;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class BookmarkData {
    private final PropertyChangeSupport support = new PropertyChangeSupport(this);
    @JsonProperty(value="seen")
    private boolean seen = false;
    private String url;
    @JsonIgnore
    private DatenFilm filmdata;
    private String note;
    private LocalDate availableUntil;
    private LocalDate bookmarkAdded;
    private String filmHashCode;
    private String originalSender;
    private String originalTitle;
    private String originalThema;

    public BookmarkData() {
    }

    public BookmarkData(DatenFilm film) {
        this();
        this.url = film.getUrlNormalQuality();
        this.filmdata = film;
        this.originalSender = film.getSender();
        this.originalTitle = film.getTitle();
        this.originalThema = film.getThema();
    }

    public String getOriginalSender() {
        return this.originalSender;
    }

    public void setOriginalSender(String originalSender) {
        this.originalSender = originalSender;
    }

    public String getOriginalThema() {
        return this.originalThema;
    }

    public void setOriginalThema(String originalThema) {
        this.originalThema = originalThema;
    }

    public String getOriginalTitle() {
        return this.originalTitle;
    }

    public void setOriginalTitle(String originalTitle) {
        this.originalTitle = originalTitle;
    }

    @JsonIgnore
    public String getSender() {
        if (this.filmdata != null) {
            return this.filmdata.getSender();
        }
        return Objects.requireNonNullElse(this.originalSender, "NO SENDER");
    }

    @JsonIgnore
    public String getThema() {
        if (this.filmdata != null) {
            return this.filmdata.getThema();
        }
        return Objects.requireNonNullElse(this.originalThema, "NO THEMA");
    }

    @JsonIgnore
    public String getTitle() {
        if (this.filmdata != null) {
            return this.filmdata.getTitle();
        }
        return Objects.requireNonNullElse(this.originalTitle, "NO TITLE");
    }

    @JsonIgnore
    public int getDauer() {
        if (this.filmdata != null) {
            return this.filmdata.getFilmLength();
        }
        return -1;
    }

    @JsonIgnore
    public Date getSendedatum() {
        if (this.filmdata != null) {
            return this.filmdata.getDatumFilm();
        }
        return null;
    }

    public LocalDate getBookmarkAdded() {
        return this.bookmarkAdded;
    }

    public void setBookmarkAdded(LocalDate bookmarkAdded) {
        LocalDate oldDate = this.bookmarkAdded;
        this.bookmarkAdded = bookmarkAdded;
        this.support.firePropertyChange("bookmarkAdded", oldDate, bookmarkAdded);
    }

    public String getFilmHashCode() {
        return this.filmHashCode;
    }

    public void setFilmHashCode(String filmHashCode) {
        String oldHash = this.filmHashCode;
        this.filmHashCode = filmHashCode;
        this.url = null;
        this.support.firePropertyChange("hashCode", oldHash, filmHashCode);
    }

    public LocalDate getAvailableUntil() {
        return this.availableUntil;
    }

    public void setAvailableUntil(LocalDate availableUntil) {
        LocalDate oldDate = this.availableUntil;
        this.availableUntil = availableUntil;
        this.support.firePropertyChange("availableUntil", oldDate, availableUntil);
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        String oldUrl = this.url;
        this.url = url;
        this.support.firePropertyChange("url", oldUrl, url);
    }

    @JsonIgnore
    public String getNormalQualityUrl() {
        if (this.filmdata != null) {
            return this.filmdata.getUrlNormalQuality();
        }
        return null;
    }

    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        String oldNote = this.note;
        this.note = note;
        this.support.firePropertyChange("note", oldNote, note);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.support.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.support.removePropertyChangeListener(l);
    }

    @JsonIgnore
    public Optional<String> getNoteOptional() {
        return Optional.ofNullable(this.note);
    }

    public boolean getSeen() {
        return this.seen;
    }

    public void setSeen(boolean seen) {
        boolean oldSeen = this.seen;
        this.seen = seen;
        this.support.firePropertyChange("seen", oldSeen, seen);
    }

    @JsonIgnore
    public boolean getNotSeen() {
        return !this.seen;
    }

    @JsonIgnore
    public boolean isNotInFilmList() {
        return this.filmdata == null;
    }

    @JsonIgnore
    public DatenFilm getDatenFilm() {
        return this.filmdata;
    }

    @JsonIgnore
    public void setDatenFilm(DatenFilm filmdata) {
        DatenFilm oldFilm = this.filmdata;
        this.filmdata = filmdata;
        this.support.firePropertyChange("datenFilm", oldFilm, filmdata);
    }

    @JsonIgnore
    public String getWebUrl() {
        return this.filmdata != null ? this.filmdata.getWebsiteUrl() : null;
    }

    @JsonIgnore
    public Optional<DatenFilm> getDatenFilmOptional() {
        return Optional.ofNullable(this.filmdata);
    }
}

