/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi.jffi;

import com.kenai.jffi.CallingConvention;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyProc;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.api.Convert;
import org.jruby.api.Error;
import org.jruby.ext.ffi.AbstractInvoker;
import org.jruby.ext.ffi.AllocatedDirectMemoryIO;
import org.jruby.ext.ffi.Enums;
import org.jruby.ext.ffi.FreedMemoryIO;
import org.jruby.ext.ffi.InvalidMemoryIO;
import org.jruby.ext.ffi.MemoryIO;
import org.jruby.ext.ffi.Pointer;
import org.jruby.ext.ffi.Type;
import org.jruby.ext.ffi.Util;
import org.jruby.ext.ffi.jffi.CallbackManager;
import org.jruby.ext.ffi.jffi.CodeMemoryIO;
import org.jruby.ext.ffi.jffi.MethodFactory;
import org.jruby.ext.ffi.jffi.NativeFunctionInfo;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"FFI::Function"}, parent="FFI::Pointer")
public final class Function
extends AbstractInvoker {
    private final com.kenai.jffi.Function function;
    private final NativeFunctionInfo functionInfo;
    private final IRubyObject enums;
    private final boolean saveError;
    private volatile boolean autorelease = true;

    public static RubyClass createFunctionClass(ThreadContext context, RubyModule FFI2) {
        return (RubyClass)((RubyModule)((RubyModule)FFI2.defineClassUnder(context, "Function", FFI2.getClass(context, "Pointer"), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR)).defineMethods(context, AbstractInvoker.class, Function.class)).defineConstants(context, Function.class);
    }

    Function(Ruby runtime2, RubyClass klass, MemoryIO address2, Type returnType, Type[] parameterTypes, CallingConvention convention, IRubyObject enums, boolean saveError) {
        super(runtime2, klass, parameterTypes.length, address2);
        ThreadContext context = runtime2.getCurrentContext();
        this.functionInfo = new NativeFunctionInfo(runtime2, returnType, parameterTypes, convention);
        this.function = new com.kenai.jffi.Function(address2.address(), this.functionInfo.jffiReturnType, this.functionInfo.jffiParameterTypes, this.functionInfo.convention, saveError);
        this.enums = enums;
        this.saveError = saveError;
        RubyClass singleton = this.singletonClass(context);
        singleton.addMethod(context, "call", this.createDynamicMethod(singleton));
    }

    Function(Ruby runtime2, RubyClass klass, MemoryIO address2, NativeFunctionInfo functionInfo, IRubyObject enums) {
        super(runtime2, klass, functionInfo.parameterTypes.length, address2);
        ThreadContext context = runtime2.getCurrentContext();
        this.functionInfo = functionInfo;
        this.function = new com.kenai.jffi.Function(address2.address(), functionInfo.jffiReturnType, functionInfo.jffiParameterTypes, functionInfo.convention);
        this.enums = enums;
        this.saveError = true;
        RubyClass singleton = this.singletonClass(context);
        singleton.addMethod(context, "call", this.createDynamicMethod(singleton));
    }

    @JRubyMethod(name={"new"}, meta=true, required=2, optional=2, checkArity=false)
    public static IRubyObject newInstance(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        CallingConvention callConvention;
        IRubyObject iRubyObject;
        int optionsIndex;
        int argc = Arity.checkArgumentCount(context, args2, 2, 4);
        InvalidMemoryIO fptr = null;
        Object proc2 = null;
        if (!(args2[1] instanceof RubyArray)) {
            throw Error.typeError(context, "Invalid parameter array ", args2[1], " (expected Array)");
        }
        RubyArray paramTypes = (RubyArray)args2[1];
        Type[] parameterTypes = new Type[paramTypes.size()];
        for (int i2 = 0; i2 < parameterTypes.length; ++i2) {
            parameterTypes[i2] = Util.findType(context, paramTypes.entry(i2));
        }
        if (argc > 2 && args2[2] instanceof Pointer) {
            fptr = new CodeMemoryIO(context.runtime, (Pointer)args2[2]);
            optionsIndex = 3;
        } else if (argc > 2 && (args2[2] instanceof RubyProc || args2[2].respondsTo("call"))) {
            proc2 = args2[2];
            optionsIndex = 3;
        } else if (block.isGiven()) {
            proc2 = block;
            optionsIndex = 2;
        } else {
            throw Error.typeError(context, "Invalid function address ", args2[0], " (expected FFI::Pointer)");
        }
        Type returnType = Util.findType(context, args2[0]);
        String convention = "default";
        IRubyObject enums = null;
        boolean saveError = true;
        if (argc > optionsIndex && (iRubyObject = args2[optionsIndex]) instanceof RubyHash) {
            IRubyObject rbSaveErrno;
            RubyHash options2 = (RubyHash)iRubyObject;
            IRubyObject rbConvention = options2.fastARef(Convert.asSymbol(context, "convention"));
            if (rbConvention != null && !rbConvention.isNil()) {
                convention = rbConvention.asJavaString();
            }
            if ((rbSaveErrno = options2.fastARef(Convert.asSymbol(context, "save_errno"))) != null && !rbSaveErrno.isNil()) {
                saveError = rbSaveErrno.isTrue();
            }
            if (!((enums = options2.fastARef(Convert.asSymbol(context, "enums"))) == null || enums.isNil() || enums instanceof RubyHash || enums instanceof Enums)) {
                throw Error.typeError(context, "wrong type for options[:enum] ", enums, " (expected Hash or Enums)");
            }
        }
        CallingConvention callingConvention = callConvention = "stdcall".equals(convention) ? CallingConvention.STDCALL : CallingConvention.DEFAULT;
        if (fptr == null && proc2 != null) {
            fptr = CallbackManager.getInstance().newClosure(context.runtime, returnType, parameterTypes, proc2, callConvention);
        }
        return new Function(context.runtime, (RubyClass)recv2, fptr, returnType, parameterTypes, callConvention, enums, saveError);
    }

    @JRubyMethod(name={"free"})
    public final IRubyObject free(ThreadContext context) {
        MemoryIO memoryIO = this.getMemoryIO();
        if (!(memoryIO instanceof AllocatedDirectMemoryIO)) {
            throw Error.runtimeError(context, "cannot free non-allocated function");
        }
        AllocatedDirectMemoryIO mio = (AllocatedDirectMemoryIO)((Object)memoryIO);
        mio.free();
        this.setMemoryIO(new FreedMemoryIO(context.runtime));
        return context.nil;
    }

    @JRubyMethod(name={"autorelease="})
    public final IRubyObject autorelease(ThreadContext context, IRubyObject release) {
        MemoryIO memoryIO;
        if (this.autorelease != release.isTrue() && (memoryIO = this.getMemoryIO()) instanceof AllocatedDirectMemoryIO) {
            AllocatedDirectMemoryIO amio = (AllocatedDirectMemoryIO)((Object)memoryIO);
            this.autorelease = release.isTrue();
            amio.setAutoRelease(this.autorelease);
        }
        return context.nil;
    }

    @JRubyMethod(name={"autorelease?", "autorelease"})
    public final IRubyObject autorelease_p(ThreadContext context) {
        return Convert.asBoolean(context, this.autorelease);
    }

    @Override
    public DynamicMethod createDynamicMethod(RubyModule module) {
        return MethodFactory.createDynamicMethod(this.getRuntime(), module, this.function, this.functionInfo.returnType, this.functionInfo.parameterTypes, this.functionInfo.convention, this.enums, !this.saveError);
    }
}

