/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompile.actions;

import docking.action.KeyBindingData;
import docking.action.MenuData;
import ghidra.app.decompiler.ClangFieldToken;
import ghidra.app.decompiler.ClangReturnType;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.plugin.core.decompile.DecompilerActionContext;
import ghidra.app.plugin.core.decompile.actions.AbstractDecompilerAction;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.ProgramBasedDataTypeManager;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.pcode.HighFunction;
import ghidra.program.model.pcode.HighFunctionDBUtil;
import ghidra.program.model.pcode.HighSymbol;
import ghidra.program.model.pcode.HighVariable;
import ghidra.program.model.pcode.PcodeException;
import ghidra.program.model.pcode.Varnode;
import ghidra.program.model.symbol.SourceType;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.UndefinedFunction;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import java.awt.Component;

public class RetypeLocalAction
extends AbstractDecompilerAction {
    public RetypeLocalAction() {
        super("Retype Variable");
        this.setHelpLocation(new HelpLocation("DecompilePlugin", "ActionRetypeVariable"));
        this.setPopupMenuData(new MenuData(new String[]{"Retype Variable"}, "Decompile"));
        this.setKeyBindingData(new KeyBindingData(76, 128));
    }

    protected RetypeLocalAction(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void retypeSymbol(Program program, HighSymbol highSymbol, Varnode exactSpot, DataType dt, PluginTool tool) {
        HighFunction hfunction = highSymbol.getHighFunction();
        boolean commitRequired = RetypeLocalAction.checkFullCommit(highSymbol, hfunction);
        if (commitRequired) {
            exactSpot = null;
        }
        if (exactSpot != null) {
            try {
                HighVariable var = hfunction.splitOutMergeGroup(exactSpot.getHigh(), exactSpot);
                highSymbol = var.getSymbol();
            }
            catch (PcodeException e) {
                Msg.showError((Object)((Object)this), (Component)tool.getToolFrame(), (String)"Retype Failed", (Object)e.getMessage());
                return;
            }
        }
        ProgramBasedDataTypeManager dataTypeManager = program.getDataTypeManager();
        boolean successfulMod = false;
        int transaction = program.startTransaction("Retype Variable");
        try {
            if (dt.getDataTypeManager() != dataTypeManager) {
                dt = dataTypeManager.resolve(dt, null);
            }
            if (commitRequired) {
                boolean useDataTypes = hfunction.getFunction().getSignatureSource() != SourceType.DEFAULT;
                try {
                    HighFunctionDBUtil.commitParamsToDatabase((HighFunction)hfunction, (boolean)useDataTypes, (HighFunctionDBUtil.ReturnCommitOption)HighFunctionDBUtil.ReturnCommitOption.NO_COMMIT, (SourceType)SourceType.USER_DEFINED);
                }
                catch (DuplicateNameException e) {
                    throw new AssertException("Unexpected exception", (Throwable)e);
                }
                catch (InvalidInputException e) {
                    Msg.showError((Object)((Object)this), null, (String)"Parameter Commit Failed", (Object)e.getMessage());
                }
            }
            HighFunctionDBUtil.updateDBVariable((HighSymbol)highSymbol, null, (DataType)dt, (SourceType)SourceType.USER_DEFINED);
            successfulMod = true;
        }
        catch (DuplicateNameException e) {
            throw new AssertException("Unexpected exception", (Throwable)e);
        }
        catch (InvalidInputException e) {
            Msg.showError((Object)((Object)this), (Component)tool.getToolFrame(), (String)"Retype Failed", (Object)("Failed to re-type variable '" + highSymbol.getName() + "': " + e.getMessage()));
        }
        finally {
            program.endTransaction(transaction, successfulMod);
        }
    }

    @Override
    protected boolean isEnabledForDecompilerContext(DecompilerActionContext context) {
        Function function = context.getFunction();
        if (function == null || function instanceof UndefinedFunction) {
            return false;
        }
        ClangToken tokenAtCursor = context.getTokenAtCursor();
        if (tokenAtCursor == null) {
            return false;
        }
        if (tokenAtCursor instanceof ClangFieldToken) {
            return false;
        }
        if (tokenAtCursor.Parent() instanceof ClangReturnType) {
            return false;
        }
        if (!tokenAtCursor.isVariableRef()) {
            return false;
        }
        HighSymbol highSymbol = tokenAtCursor.getHighSymbol(context.getHighFunction());
        if (highSymbol == null) {
            return false;
        }
        return !highSymbol.isGlobal();
    }

    @Override
    protected void decompilerActionPerformed(DecompilerActionContext context) {
        Program program = context.getProgram();
        PluginTool tool = context.getTool();
        ClangToken tokenAtCursor = context.getTokenAtCursor();
        DataType dataType = null;
        HighSymbol highSymbol = tokenAtCursor.getHighSymbol(context.getHighFunction());
        if (highSymbol == null) {
            return;
        }
        dataType = RetypeLocalAction.chooseDataType(tool, program, highSymbol.getDataType());
        if (dataType == null) {
            return;
        }
        this.retypeSymbol(program, highSymbol, tokenAtCursor.getVarnode(), dataType, tool);
    }
}

