/*
 * Decompiled with CFR 0.152.
 */
package ghidra.closedpatternmining;

import ghidra.closedpatternmining.FrequentSequence;
import ghidra.closedpatternmining.FrequentSequenceItem;
import ghidra.closedpatternmining.ProjectedDatabase;
import ghidra.closedpatternmining.SequenceDatabase;
import ghidra.closedpatternmining.SequenceItem;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;

public class ClosedSequenceMiner {
    private Set<FrequentSequence> frequentClosedSequences;
    private int minSupport;
    private TreeSet<FrequentSequenceItem> globallyFrequentItems;
    private SequenceDatabase database;

    public ClosedSequenceMiner(SequenceDatabase database, int minSupport) {
        this.minSupport = minSupport;
        this.frequentClosedSequences = new HashSet<FrequentSequence>();
        this.database = database;
    }

    public Set<FrequentSequence> mineClosedSequences(TaskMonitor monitor) {
        this.globallyFrequentItems = this.database.getGloballyFrequentItems(this.minSupport);
        monitor.setMaximum((long)this.globallyFrequentItems.size());
        for (FrequentSequenceItem gfItem : this.globallyFrequentItems) {
            if (monitor.isCancelled()) break;
            monitor.incrementProgress(1L);
            ArrayList<SequenceItem> singletonFrequentItem = new ArrayList<SequenceItem>();
            singletonFrequentItem.add(gfItem.getItem());
            ProjectedDatabase projectedDatabase = new ProjectedDatabase(this.database, singletonFrequentItem);
            Set<FrequentSequenceItem> backwardExtensionItems = projectedDatabase.getBackwardExtensionItems();
            if (backwardExtensionItems.size() != 0) continue;
            this.bide(projectedDatabase, monitor);
        }
        return this.frequentClosedSequences;
    }

    private void bide(ProjectedDatabase projectedDatabase, TaskMonitor monitor) {
        TreeSet<FrequentSequenceItem> locallyFrequentItems = projectedDatabase.getLocallyFrequentItems(this.globallyFrequentItems, this.minSupport);
        Set<FrequentSequenceItem> forwardExtensionItems = projectedDatabase.getForwardExtensionItems(locallyFrequentItems);
        if (forwardExtensionItems.size() == 0) {
            this.frequentClosedSequences.add(new FrequentSequence(projectedDatabase.getPrefix(), projectedDatabase.getSupport()));
        }
        for (FrequentSequenceItem fItem : locallyFrequentItems) {
            if (monitor.isCancelled()) {
                return;
            }
            ProjectedDatabase extended = new ProjectedDatabase(projectedDatabase, fItem.getItem());
            Set<FrequentSequenceItem> backwardExtensionItems = extended.getBackwardExtensionItems();
            if (backwardExtensionItems.size() != 0) continue;
            this.bide(extended, monitor);
        }
    }
}

