/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.functiongraph.graph.vertex;

import docking.ActionContext;
import docking.GenericHeader;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.ToolBarData;
import docking.widgets.fieldpanel.FieldPanel;
import docking.widgets.fieldpanel.Layout;
import docking.widgets.fieldpanel.field.Field;
import docking.widgets.fieldpanel.support.BackgroundColorModel;
import docking.widgets.label.GDLabel;
import generic.theme.GColor;
import generic.theme.GIcon;
import generic.theme.GThemeDefaults;
import generic.theme.Gui;
import ghidra.app.plugin.core.codebrowser.MarkerServiceBackgroundColorModel;
import ghidra.app.plugin.core.codebrowser.hover.ListingHoverService;
import ghidra.app.plugin.core.functiongraph.FunctionGraphPlugin;
import ghidra.app.plugin.core.functiongraph.graph.FGEdge;
import ghidra.app.plugin.core.functiongraph.graph.vertex.AbstractGraphComponentPanel;
import ghidra.app.plugin.core.functiongraph.graph.vertex.FGVertex;
import ghidra.app.plugin.core.functiongraph.graph.vertex.FGVertexListingPanel;
import ghidra.app.plugin.core.functiongraph.graph.vertex.GroupHistoryInfo;
import ghidra.app.plugin.core.functiongraph.graph.vertex.SetVertexMostRecentColorAction;
import ghidra.app.plugin.core.functiongraph.mvc.FGController;
import ghidra.app.plugin.core.functiongraph.mvc.FunctionGraphOptions;
import ghidra.app.plugin.core.marker.MarginProviderSupplier;
import ghidra.app.plugin.core.marker.MarkerMarginProvider;
import ghidra.app.services.ButtonPressedListener;
import ghidra.app.services.HoverService;
import ghidra.app.services.MarkerService;
import ghidra.app.util.AddEditDialog;
import ghidra.app.util.viewer.format.FormatManager;
import ghidra.app.util.viewer.listingpanel.ListingBackgroundColorModel;
import ghidra.app.util.viewer.listingpanel.ListingHoverProvider;
import ghidra.app.util.viewer.listingpanel.ListingModel;
import ghidra.app.util.viewer.listingpanel.MarginProvider;
import ghidra.app.util.viewer.util.AddressIndexMap;
import ghidra.app.util.viewer.util.FieldNavigator;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.framework.plugintool.util.ServiceListener;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;
import ghidra.util.ColorUtils;
import ghidra.util.HTMLUtilities;
import ghidra.util.HelpLocation;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ChangeListener;

public class ListingGraphComponentPanel
extends AbstractGraphComponentPanel {
    private GenericHeader genericHeader;
    private FGVertexListingPanel listingPanel;
    private FieldPanel fieldPanel;
    private final PluginTool tool;
    private JComponent toolTipComponent;
    private FGVertexListingPanel previewListingPanel;
    private JLabel tooltipTitleLabel;
    private final Program program;
    private AddressSetView addressSet;
    private List<ListingHoverService> installedHoverServices = new ArrayList<ListingHoverService>();
    private DockingAction xrefsAction;
    private DockingAction minimizeViewModeAction;
    private DockingAction maximizeViewModeAction;
    private DockingAction groupAction;
    private DockingAction regroupAction;
    private Color userDefinedColor = null;
    private SetVertexMostRecentColorAction setVertexMostRecentAction;
    private Color defaultBackgroundColor;
    private ServiceListener serviceChangeListener = new ServiceListener(){

        public void serviceAdded(Class<?> interfaceClass, Object service) {
            if (interfaceClass == HoverService.class) {
                ListingGraphComponentPanel.this.adjustHoverListeners();
            }
        }

        public void serviceRemoved(Class<?> interfaceClass, Object service) {
            if (interfaceClass == HoverService.class) {
                ListingGraphComponentPanel.this.adjustHoverListeners();
            }
        }
    };
    private final ChangeListener markerChangeListener = e -> {
        if (this.controller != null) {
            this.controller.repaint();
        }
    };

    ListingGraphComponentPanel(FGVertex vertex, FGController controller, PluginTool tool, Program program, AddressSetView addressSet) {
        super(controller, vertex);
        this.tool = tool;
        this.addressSet = addressSet;
        this.program = program;
        this.title = this.createTitle();
        this.setLayout(new BorderLayout());
        this.listingPanel = new FGVertexListingPanel(controller, controller.getMinimalFormatManager(), program, addressSet);
        this.listingPanel.addButtonPressedListener((ButtonPressedListener)new FieldNavigator((ServiceProvider)tool, controller.getNavigatable()));
        this.listingPanel.addButtonPressedListener(controller.getSharedHighlighterButtonPressedListener());
        this.listingPanel.setStringSelectionListener(controller.getSharedStringSelectionListener());
        MarkerService markerService = controller.getService(MarkerService.class);
        if (markerService != null) {
            MarkerServiceBackgroundColorModel colorModel = new MarkerServiceBackgroundColorModel(markerService, this.listingPanel.getAddressIndexMap());
            this.listingPanel.setBackgroundColorModel((ListingBackgroundColorModel)colorModel);
            markerService.addChangeListener(this.markerChangeListener);
        }
        Set<MarginProviderSupplier> marginProviders = controller.getMarginProviderSuppliers();
        for (MarginProviderSupplier supplier : marginProviders) {
            MarkerMarginProvider marginProvider = supplier.createMarginProvider();
            this.listingPanel.addMarginProvider((MarginProvider)marginProvider);
        }
        this.fieldPanel = this.listingPanel.getFieldPanel();
        this.fieldPanel.setCursorOn(false);
        this.defaultBackgroundColor = this.listingPanel.getTextBackgroundColor();
        this.listingPanel.setListingHoverHandler(new ListingHoverAdapter());
        this.listingPanel.setHoverMode(true);
        tool.addServiceListener(this.serviceChangeListener);
        this.adjustHoverListeners();
        this.add((Component)((Object)this.listingPanel), "Center");
        Border beveledBorder = BorderFactory.createBevelBorder(0, (Color)new GColor("color.border.bevel.highlight"), (Color)new GColor("color.border.bevel.shadow"));
        this.setBorder(beveledBorder);
        this.addKeyListener(new FieldPanelKeyListener());
        this.genericHeader = new GenericHeader(){

            public Dimension getPreferredSize() {
                Dimension preferredSize = super.getPreferredSize();
                int maxWidth = ListingGraphComponentPanel.this.listingPanel.getPreferredSize().width;
                if (maxWidth <= 0) {
                    return preferredSize;
                }
                int toolBarWidth = this.getToolBarWidth();
                int minimumGrabArea = 60;
                int minimumWidth = minimumGrabArea + toolBarWidth;
                maxWidth = Math.max(maxWidth, minimumWidth);
                preferredSize.width = Math.max(maxWidth, 170);
                return preferredSize;
            }
        };
        this.genericHeader.setComponent((Component)this.fieldPanel);
        this.genericHeader.setTitle(this.title);
        this.genericHeader.setNoWrapToolbar(true);
        this.createActions();
        this.setFormat(false);
        this.add((Component)this.genericHeader, "North");
        this.listingPanel.setProgramLocationListener(controller);
        this.listingPanel.setProgramSelectionListener(controller);
    }

    @Override
    public Component getMaximizedViewComponent() {
        return this;
    }

    private void adjustHoverListeners() {
        ListingHoverService[] services;
        for (ListingHoverService wrapper : this.installedHoverServices) {
            this.listingPanel.removeHoverService(wrapper);
        }
        this.installedHoverServices.clear();
        for (ListingHoverService hoverService : services = (ListingHoverService[])this.tool.getServices(ListingHoverService.class)) {
            this.installedHoverServices.add(hoverService);
            this.listingPanel.addHoverService(hoverService);
        }
    }

    private void createListingPanelToolTipComponent() {
        JPanel panel = new JPanel(new BorderLayout());
        FunctionGraphOptions options = this.controller.getFunctionGraphOptions();
        boolean useFullSizeTooltip = options.useFullSizeTooltip();
        this.previewListingPanel = new FGVertexListingPanel(this.controller, this.getFormatManager(useFullSizeTooltip), this.program, this.addressSet);
        this.previewListingPanel.setTextBackgroundColor((Color)GThemeDefaults.Colors.Tooltips.BACKGROUND);
        this.previewListingPanel.getFieldPanel().setCursorOn(false);
        Dimension maxSize = new Dimension(700, 400);
        this.previewListingPanel.setMaximumSize(maxSize);
        Dimension preferredSize = this.previewListingPanel.getPreferredSize();
        preferredSize.width = Math.min(maxSize.width, preferredSize.width);
        preferredSize.height = Math.min(maxSize.height, preferredSize.height);
        this.previewListingPanel.setPreferredSize(preferredSize);
        this.tooltipTitleLabel = new GDLabel();
        this.tooltipTitleLabel.setHorizontalAlignment(10);
        this.tooltipTitleLabel.setBackground((Color)GThemeDefaults.Colors.Tooltips.BACKGROUND);
        this.tooltipTitleLabel.setOpaque(true);
        Gui.registerFont((JComponent)this.tooltipTitleLabel, (int)1);
        JPanel headerPanel = new JPanel(new BorderLayout());
        headerPanel.add(this.tooltipTitleLabel);
        headerPanel.setBorder(BorderFactory.createLineBorder((Color)GThemeDefaults.Colors.BORDER));
        panel.add((Component)headerPanel, "North");
        panel.add((Component)((Object)this.previewListingPanel), "Center");
        this.toolTipComponent = panel;
    }

    @Override
    void refreshModel() {
        this.listingPanel.refreshModel();
        if (this.previewListingPanel != null) {
            this.previewListingPanel.refreshModel();
        }
    }

    @Override
    void refreshDisplay() {
        this.title = this.createTitle();
        this.genericHeader.setTitle(this.title);
        this.previewListingPanel = null;
        this.updateDefaultBackgroundColor();
    }

    private void updateDefaultBackgroundColor() {
        FunctionGraphOptions options = this.controller.getFunctionGraphOptions();
        Color newBgColor = options.getDefaultVertexBackgroundColor();
        if (!this.defaultBackgroundColor.equals(newBgColor)) {
            this.defaultBackgroundColor = newBgColor;
            if (this.userDefinedColor == null) {
                this.listingPanel.setTextBackgroundColor(this.defaultBackgroundColor);
            }
        }
    }

    @Override
    void refreshDisplayForAddress(Address address) {
        AddressSetView view = this.listingPanel.getView();
        if (!address.equals((Object)view.getMinAddress())) {
            return;
        }
        this.refreshDisplay();
    }

    @Override
    Color getDefaultBackgroundColor() {
        return this.defaultBackgroundColor;
    }

    @Override
    Color getBackgroundColor() {
        return this.listingPanel.getTextBackgroundColor();
    }

    @Override
    Color getSelectionColor() {
        return this.fieldPanel.getSelectionColor();
    }

    private void createActions() {
        String firstGroup = "group1";
        String secondGroup = "group2";
        this.setVertexMostRecentAction = new SetVertexMostRecentColorAction(this.controller, this.vertex);
        this.setVertexMostRecentAction.setHelpLocation(new HelpLocation("FunctionGraphPlugin", "Vertex_Action_Color"));
        ToolBarData toolBarData = this.setVertexMostRecentAction.getToolBarData();
        this.setVertexMostRecentAction.setToolBarData(new ToolBarData(toolBarData.getIcon(), firstGroup));
        this.xrefsAction = new DockingAction("Jump To XRef", FunctionGraphPlugin.class.getName()){

            public void actionPerformed(ActionContext context) {
                ListingGraphComponentPanel.this.controller.showXRefsDialog();
            }
        };
        this.xrefsAction.setDescription("Jump to a XRef");
        GIcon imageIcon = new GIcon("icon.plugin.functiongraph.action.vertex.xrefs");
        this.xrefsAction.setToolBarData(new ToolBarData((Icon)imageIcon, firstGroup));
        this.xrefsAction.setHelpLocation(new HelpLocation("FunctionGraphPlugin", "Vertex_Action_XRefs"));
        this.maximizeViewModeAction = new DockingAction("View Mode", FunctionGraphPlugin.class.getName()){

            public void actionPerformed(ActionContext context) {
                ListingGraphComponentPanel.this.setFormat(true);
                ListingGraphComponentPanel.this.vertex.setShowing(true);
                ListingGraphComponentPanel.this.controller.setVertexViewMode(ListingGraphComponentPanel.this.vertex, true);
            }
        };
        this.maximizeViewModeAction.setDescription("Reverts view from graph to fullscreen");
        imageIcon = new GIcon("icon.plugin.functiongraph.action.vertex.maximize");
        this.maximizeViewModeAction.setToolBarData(new ToolBarData((Icon)imageIcon, firstGroup));
        this.maximizeViewModeAction.setHelpLocation(new HelpLocation("FunctionGraphPlugin", "Vertex_Action_Full_View"));
        this.minimizeViewModeAction = new DockingAction("View Mode", FunctionGraphPlugin.class.getName()){

            public void actionPerformed(ActionContext context) {
                ListingGraphComponentPanel.this.setFormat(false);
                ListingGraphComponentPanel.this.vertex.setShowing(true);
                ListingGraphComponentPanel.this.controller.setVertexViewMode(ListingGraphComponentPanel.this.vertex, false);
            }
        };
        this.minimizeViewModeAction.setDescription("Reverts view from fullscreen to graph");
        imageIcon = new GIcon("icon.plugin.functiongraph.action.vertex.minimize");
        this.minimizeViewModeAction.setToolBarData(new ToolBarData((Icon)imageIcon, firstGroup));
        this.minimizeViewModeAction.setHelpLocation(new HelpLocation("FunctionGraphPlugin", "Vertex_Action_Full_View"));
        this.groupAction = new DockingAction("Group Vertices", FunctionGraphPlugin.class.getName()){

            public void actionPerformed(ActionContext context) {
                ListingGraphComponentPanel.this.groupVertices();
            }
        };
        this.groupAction.setDescription("Combine selected vertices into one vertex");
        imageIcon = new GIcon("icon.plugin.functiongraph.action.vertex.group");
        this.groupAction.setToolBarData(new ToolBarData((Icon)imageIcon, secondGroup));
        this.groupAction.setHelpLocation(new HelpLocation("FunctionGraphPlugin", "Vertex_Action_Group"));
        this.regroupAction = new DockingAction("Regroup Vertices", FunctionGraphPlugin.class.getName()){

            public void actionPerformed(ActionContext context) {
                ListingGraphComponentPanel.this.regroupVertices();
            }
        };
        this.regroupAction.setDescription("Restore vertex and siblings back to group form");
        imageIcon = new GIcon("icon.plugin.functiongraph.action.vertex.regroup");
        this.regroupAction.setToolBarData(new ToolBarData((Icon)imageIcon, secondGroup));
        this.regroupAction.setHelpLocation(new HelpLocation("FunctionGraphPlugin", "Vertex_Action_Regroup"));
        this.genericHeader.actionAdded((DockingActionIf)this.setVertexMostRecentAction);
        if (this.vertex.getVertexType().isEntry()) {
            this.genericHeader.actionAdded((DockingActionIf)this.xrefsAction);
        }
        this.genericHeader.actionAdded((DockingActionIf)this.groupAction);
        this.genericHeader.update();
    }

    private void removeRedoAction() {
        this.genericHeader.actionRemoved((DockingActionIf)this.regroupAction);
        this.genericHeader.update();
    }

    private void addRedoAction() {
        GroupHistoryInfo groupInfo = this.vertex.getGroupInfo();
        this.regroupAction.setDescription("<html>Restore Group:<br>" + HTMLUtilities.toHTML((String)groupInfo.getGroupDescription()));
        this.genericHeader.actionRemoved((DockingActionIf)this.regroupAction);
        this.genericHeader.actionAdded((DockingActionIf)this.regroupAction);
        this.genericHeader.update();
    }

    ProgramSelection getProgramHighlight() {
        return this.listingPanel.getProgramHighlight();
    }

    @Override
    ProgramSelection getProgramSelection() {
        return this.listingPanel.getProgramSelection();
    }

    @Override
    String getTextSelection() {
        return this.listingPanel.getTextSelection();
    }

    @Override
    ProgramLocation getProgramLocation() {
        return this.listingPanel.getProgramLocation();
    }

    private String createTitle() {
        Address minAddress = this.addressSet.getMinAddress();
        Object newTitle = minAddress.toString();
        SymbolTable symbolTable = this.program.getSymbolTable();
        Symbol primarySymbol = symbolTable.getPrimarySymbol(minAddress);
        if (primarySymbol != null) {
            newTitle = (String)newTitle + " - " + primarySymbol.getName(false);
        }
        return newTitle;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    ListingModel getListingModel(Address address) {
        return this.listingPanel.getListingModel();
    }

    @Override
    void setCursorPosition(ProgramLocation location) {
        if (location == null) {
            return;
        }
        this.listingPanel.setCursorPosition(location);
        this.scrollToCursor();
    }

    @Override
    Rectangle getCursorBounds() {
        Rectangle cursorBounds = this.listingPanel.getCursorBounds();
        if (cursorBounds == null) {
            return null;
        }
        return SwingUtilities.convertRectangle((Component)((Object)this.listingPanel), cursorBounds, this);
    }

    @Override
    void setProgramSelection(ProgramSelection selection) {
        this.listingPanel.setSelection(selection);
    }

    @Override
    void setProgramHighlight(ProgramSelection highlight) {
        if (highlight != null) {
            this.listingPanel.setHighlight(highlight);
        }
    }

    private void scrollToCursor() {
        this.listingPanel.getFieldPanel().scrollToCursor();
    }

    private void setFormat(boolean isMaximized) {
        this.listingPanel.setFormatManager(this.getFormatManager(isMaximized));
        if (isMaximized) {
            this.genericHeader.actionAdded((DockingActionIf)this.minimizeViewModeAction);
            this.genericHeader.actionRemoved((DockingActionIf)this.maximizeViewModeAction);
        } else {
            this.genericHeader.actionRemoved((DockingActionIf)this.minimizeViewModeAction);
            this.genericHeader.actionAdded((DockingActionIf)this.maximizeViewModeAction);
        }
    }

    private FormatManager getFormatManager(boolean maximized) {
        if (maximized) {
            return this.controller.getFullFormatManager();
        }
        return this.controller.getMinimalFormatManager();
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        Component source = event.getComponent();
        if (SwingUtilities.isDescendingFrom(source, (Component)this.genericHeader)) {
            if (!(source instanceof JComponent)) {
                return null;
            }
            JComponent jComponent = (JComponent)source;
            return jComponent.getToolTipText();
        }
        return null;
    }

    @Override
    JComponent getToolTipComponentForEdge(FGEdge edge) {
        this.initializeToolTipComponentForEdge(edge);
        return this.toolTipComponent;
    }

    @Override
    JComponent getToolTipComponentForVertex() {
        Address address = this.getPreviewAddress(true);
        this.initializeToolTipComponent(address);
        this.tooltipTitleLabel.setText(this.getTitle());
        return this.toolTipComponent;
    }

    private void initializeToolTipComponentForEdge(FGEdge edge) {
        boolean isDestinationVertex = edge.getEnd() == this.vertex;
        Address address = this.getPreviewAddress(isDestinationVertex);
        if (address == null) {
            String side = isDestinationVertex ? "end" : "start";
            this.toolTipComponent = new GDLabel("Unable to find address for edge " + side + ": " + String.valueOf(edge));
            this.toolTipComponent.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
            if (this.previewListingPanel != null) {
                this.previewListingPanel = null;
            }
            return;
        }
        this.initializeToolTipComponent(address);
        if (isDestinationVertex) {
            this.tooltipTitleLabel.setText("To: " + this.getTitle());
        } else {
            this.tooltipTitleLabel.setText("From: " + this.getTitle());
        }
        this.previewListingPanel.getFieldPanel().setBackgroundColorModel((BackgroundColorModel)new HighlightingColorModel(address, this.getToolTipColorForEdge(edge)));
    }

    private void initializeToolTipComponent(Address goToAddress) {
        if (this.previewListingPanel == null) {
            this.createListingPanelToolTipComponent();
        }
        this.previewListingPanel.getFieldPanel().setCursorOn(true);
        this.previewListingPanel.goTo(goToAddress);
        this.previewListingPanel.getFieldPanel().setCursorOn(false);
    }

    private Color getToolTipColorForEdge(FGEdge edge) {
        FunctionGraphOptions options = this.controller.getFunctionGraphOptions();
        Color c = options.getColor(edge.getFlowType());
        return ColorUtils.withAlpha((Color)c, (int)125);
    }

    private Address getPreviewAddress(boolean forward) {
        AddressIterator addresses = this.addressSet.getAddresses(forward);
        Address address = addresses.next();
        while (this.getLayoutForAddress(address) == null) {
            address = addresses.next();
        }
        return address;
    }

    private Layout getLayoutForAddress(Address address) {
        return this.listingPanel.getLayout(address);
    }

    @Override
    public void doSetFocused(boolean focused) {
        this.fieldPanel.setCursorOn(focused);
        if (focused) {
            this.requestFocus();
        }
    }

    @Override
    public void requestFocus() {
        this.listingPanel.requestFocus();
    }

    @Override
    public JComponent getHeader() {
        return this.genericHeader;
    }

    @Override
    boolean isSelected() {
        return this.genericHeader.isSelected();
    }

    @Override
    boolean isFullScreenMode() {
        FormatManager fullFormatManager = this.getFormatManager(true);
        FormatManager currentFormatManager = this.listingPanel.getFormatManager();
        return currentFormatManager == fullFormatManager;
    }

    @Override
    void setFullScreenMode(boolean fullScreen) {
        this.setFormat(fullScreen);
        this.vertex.setShowing(true);
        this.controller.setVertexViewMode(this.vertex, fullScreen);
    }

    @Override
    void setSelected(boolean selected) {
        this.genericHeader.setSelected(selected);
    }

    @Override
    void updateGroupAssociationStatus(boolean groupMember) {
        if (groupMember) {
            this.addRedoAction();
        } else {
            this.removeRedoAction();
        }
    }

    @Override
    Color getUserDefinedColor() {
        return this.userDefinedColor;
    }

    @Override
    void restoreColor(Color color) {
        this.listingPanel.setTextBackgroundColor(color);
    }

    @Override
    void setBackgroundColor(Color color) {
        this.userDefinedColor = color;
        this.listingPanel.setTextBackgroundColor(color);
        this.controller.repaint();
    }

    @Override
    void clearColor() {
        this.userDefinedColor = null;
        this.listingPanel.setTextBackgroundColor(this.defaultBackgroundColor);
        this.controller.removeColor(this.vertex);
        this.controller.repaint();
    }

    @Override
    void editLabel(JComponent parentComponent) {
        AddressSetView view = this.listingPanel.getView();
        Address minAddress = view.getMinAddress();
        SymbolTable symbolTable = this.program.getSymbolTable();
        Symbol primarySymbol = symbolTable.getPrimarySymbol(minAddress);
        AddEditDialog dialog = new AddEditDialog("", this.tool);
        if (primarySymbol == null) {
            dialog.addLabel(minAddress, this.program, (Component)parentComponent);
        } else {
            dialog.editLabel(primarySymbol, this.program, (Component)parentComponent);
        }
    }

    @Override
    void dispose() {
        MarkerService markerService = this.controller.getService(MarkerService.class);
        if (markerService != null) {
            markerService.removeChangeListener(this.markerChangeListener);
        }
        this.removeAll();
        this.listingPanel.setStringSelectionListener(null);
        this.listingPanel.removeButtonPressedListener(this.controller.getSharedHighlighterButtonPressedListener());
        this.listingPanel.dispose();
        if (this.previewListingPanel != null) {
            this.previewListingPanel.dispose();
        }
        this.xrefsAction.dispose();
        this.setVertexMostRecentAction.dispose();
        this.tool.removeServiceListener(this.serviceChangeListener);
        this.installedHoverServices.clear();
        this.genericHeader.dispose();
        this.listingPanel = null;
        this.fieldPanel = null;
        this.previewListingPanel = null;
        this.tooltipTitleLabel = null;
        this.toolTipComponent = null;
        this.genericHeader = null;
        super.dispose();
    }

    private class ListingHoverAdapter
    extends ListingHoverProvider {
        protected void showPopup(JComponent comp, Field field, MouseEvent event, Rectangle fieldBounds) {
            if (!ListingGraphComponentPanel.this.controller.arePopupsEnabled()) {
                return;
            }
            Rectangle translatedRectangle = ListingGraphComponentPanel.this.controller.translateRectangleFromVertexToViewSpace(ListingGraphComponentPanel.this.vertex, fieldBounds);
            MouseEvent translatedEvent = ListingGraphComponentPanel.this.controller.translateMouseEventFromVertexToViewSpace(ListingGraphComponentPanel.this.vertex, event);
            super.showPopup(comp, field, translatedEvent, translatedRectangle);
        }
    }

    private class FieldPanelKeyListener
    implements KeyListener {
        private FieldPanelKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            KeyboardFocusManager kfm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            kfm.redispatchEvent((Component)ListingGraphComponentPanel.this.fieldPanel, e);
        }

        @Override
        public void keyReleased(KeyEvent e) {
            KeyboardFocusManager kfm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            kfm.redispatchEvent((Component)ListingGraphComponentPanel.this.fieldPanel, e);
        }

        @Override
        public void keyTyped(KeyEvent e) {
            KeyboardFocusManager kfm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            kfm.redispatchEvent((Component)ListingGraphComponentPanel.this.fieldPanel, e);
        }
    }

    private class HighlightingColorModel
    implements BackgroundColorModel {
        private Color highlightDefaultBackgroundColor;
        private Color highlightColor;
        private final Address highlightAddress;

        public HighlightingColorModel(Address highlightAddress, Color highlightColor) {
            this.highlightAddress = highlightAddress;
            this.highlightColor = highlightColor;
        }

        public Color getBackgroundColor(BigInteger index) {
            BigInteger highlightIndex = this.getHighlightIndex(this.highlightAddress);
            if (!highlightIndex.equals(index)) {
                return this.highlightDefaultBackgroundColor;
            }
            return this.highlightColor;
        }

        public Color getDefaultBackgroundColor() {
            return this.highlightDefaultBackgroundColor;
        }

        public void setDefaultBackgroundColor(Color c) {
            this.highlightDefaultBackgroundColor = c;
        }

        private BigInteger getHighlightIndex(Address address) {
            AddressIndexMap addressIndexMap = ListingGraphComponentPanel.this.listingPanel.getAddressIndexMap();
            return addressIndexMap.getIndex(address);
        }
    }
}

