/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.decorators;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.QuadCurve2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.jgrapht.Graph;
import org.jgrapht.graph.DefaultGraphType;
import org.jungrapht.visualization.decorators.AbstractEdgeShapeFunction;
import org.jungrapht.visualization.decorators.ArticulatedEdgeShapeFunction;
import org.jungrapht.visualization.decorators.ArticulatedEdgeShapeFunctions;
import org.jungrapht.visualization.decorators.ParallelEdgeShapeFunction;
import org.jungrapht.visualization.util.ArrowFactory;
import org.jungrapht.visualization.util.EdgeIndexFunction;

public interface EdgeShape {
    public static final Line2D LINE = new Line2D.Float(0.0f, 0.0f, 1.0f, 0.0f);
    public static final QuadCurve2D QUAD_CURVE = new QuadCurve2D.Float();
    public static final CubicCurve2D CUBIC_CURVE = new CubicCurve2D.Float();
    public static final Ellipse2D ELLIPSE = new Ellipse2D.Float(-0.5f, -0.5f, 1.0f, 1.0f);
    public static final Rectangle2D BOX = new Rectangle2D.Float();
    public static final Wedge WEDGE = new Wedge(10);
    public static final Loop loop = new Loop();

    public static <E> boolean isLoop(Graph<?, E> graph, E edge) {
        return graph.getEdgeSource(edge).equals(graph.getEdgeTarget(edge));
    }

    public static <V, E> Line<V, E> line() {
        return new Line();
    }

    public static <V, E> QuadCurve<V, E> quadCurve() {
        return new QuadCurve();
    }

    public static <V, E> CubicCurve<V, E> cubicCurve() {
        return new CubicCurve();
    }

    public static <V, E> Wedge<V, E> wedge() {
        return new Wedge(10);
    }

    @Deprecated
    public static <V, E> Orthogonal<V, E> orthogonal() {
        return new Orthogonal();
    }

    public static <V, E> ArticulatedLine<V, E> articulatedLine() {
        return new ArticulatedLine();
    }

    public static Shape buildFrame(RectangularShape shape, int index) {
        float x = -0.5f;
        float y = -0.5f;
        float diam = 1.0f;
        diam += diam * (float)index / 2.0f;
        x += x * (float)index / 2.0f;
        y += y * (float)index / 2.0f;
        shape.setFrame(x, y, diam, diam);
        return shape;
    }

    public static class Line<V, E>
    implements BiFunction<Graph<V, E>, E, Shape> {
        @Override
        public Shape apply(Graph<V, E> graph, E edge) {
            return EdgeShape.isLoop(graph, edge) ? ELLIPSE : LINE;
        }
    }

    public static class QuadCurve<V, E>
    extends ParallelEdgeShapeFunction<V, E> {
        @Override
        public void setEdgeIndexFunction(EdgeIndexFunction<V, E> parallelEdgeIndexFunction) {
            super.setEdgeIndexFunction(parallelEdgeIndexFunction);
            loop.setEdgeIndexFunction(parallelEdgeIndexFunction);
        }

        @Override
        public Shape apply(Graph<V, E> graph, E e) {
            if (EdgeShape.isLoop(graph, e)) {
                return loop.apply(graph, e);
            }
            int index = this.edgeIndexFunction.apply(graph, e);
            float controlY = this.controlOffsetIncrement + this.controlOffsetIncrement * (float)index;
            QUAD_CURVE.setCurve(0.0, 0.0, 0.5, controlY, 1.0, 0.0);
            return QUAD_CURVE;
        }
    }

    public static class CubicCurve<V, E>
    extends ParallelEdgeShapeFunction<V, E> {
        @Override
        public void setEdgeIndexFunction(EdgeIndexFunction<V, E> edgeIndexFunction) {
            super.setEdgeIndexFunction(edgeIndexFunction);
            loop.setEdgeIndexFunction(edgeIndexFunction);
        }

        @Override
        public Shape apply(Graph<V, E> graph, E e) {
            if (EdgeShape.isLoop(graph, e)) {
                return loop.apply(graph, e);
            }
            int index = this.edgeIndexFunction.apply(graph, e);
            float controlY = this.controlOffsetIncrement + this.controlOffsetIncrement * (float)index;
            CUBIC_CURVE.setCurve(0.0, 0.0, 0.33f, 2.0f * controlY, 0.66f, -controlY, 1.0, 0.0);
            return CUBIC_CURVE;
        }
    }

    public static class Wedge<V, E>
    extends AbstractEdgeShapeFunction<V, E> {
        private static GeneralPath triangle;
        private static GeneralPath bowtie;

        public Wedge(int width) {
            triangle = ArrowFactory.getWedgeArrow(width, 1.0f);
            triangle.transform(AffineTransform.getTranslateInstance(1.0, 0.0));
            bowtie = new GeneralPath(0);
            bowtie.moveTo(0.0f, width / 2);
            bowtie.lineTo(1.0f, -width / 2);
            bowtie.lineTo(1.0f, width / 2);
            bowtie.lineTo(0.0f, -width / 2);
            bowtie.closePath();
        }

        @Override
        public Shape apply(Graph<V, E> graph, E edge) {
            Object target;
            Object source = graph.getEdgeSource(edge);
            if (source.equals(target = graph.getEdgeTarget(edge))) {
                return loop.apply(graph, edge);
            }
            if (graph.getType() == DefaultGraphType.dag()) {
                return triangle;
            }
            return bowtie;
        }
    }

    public static class Orthogonal<V, E>
    extends ParallelEdgeShapeFunction<V, E> {
        Box box = new Box();

        @Override
        public Shape apply(Graph<V, E> graph, E e) {
            return EdgeShape.isLoop(graph, e) ? this.box.apply(graph, e) : LINE;
        }
    }

    public static class ArticulatedLine<V, E>
    extends ArticulatedEdgeShapeFunction<V, E>
    implements BiFunction<Graph<V, E>, E, Shape> {
        Collection<E> reversedEdges;

        public ArticulatedLine(Collection<E> reversedEdges) {
            this.reversedEdges = reversedEdges;
        }

        public ArticulatedLine() {
            this(Collections.emptySet());
        }

        @Override
        public Shape apply(Graph<V, E> graph, E e) {
            List points = (List)this.edgeArticulationFunction.apply(e);
            if (points.isEmpty()) {
                return EdgeShape.isLoop(graph, e) ? ELLIPSE : LINE;
            }
            if (this.reversedEdges.contains(e)) {
                return ArticulatedEdgeShapeFunctions.makeReverseUnitShape(points);
            }
            return ArticulatedEdgeShapeFunctions.makeUnitShape(points);
        }
    }

    public static class Loop<V, E>
    extends ParallelEdgeShapeFunction<V, E> {
        @Override
        public Shape apply(Graph<V, E> graph, E e) {
            return EdgeShape.buildFrame(ELLIPSE, this.edgeIndexFunction.apply(graph, e));
        }
    }

    @Deprecated
    public static class Box<V, E>
    extends ParallelEdgeShapeFunction<V, E> {
        @Override
        public Shape apply(Graph<V, E> graph, E e) {
            return EdgeShape.buildFrame(BOX, this.edgeIndexFunction.apply(graph, e));
        }
    }

    public static class SimpleLoop<E>
    implements Function<E, Shape> {
        @Override
        public Shape apply(E e) {
            return ELLIPSE;
        }
    }
}

