/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pcodeInject;

import ghidra.app.util.pcodeInject.PcodeOpEmitter;
import ghidra.javaclass.format.DescriptorDecoder;
import ghidra.javaclass.format.constantpool.AbstractConstantPoolInfoJava;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;

public class ArrayMethods {
    static final String ARRAY_REF = "arrayref";
    static final String CLASS_NAME = "className";
    static final String DIMENSION = "dim";
    static final String MULTIANEWARRAY = "multianewarrayOp";
    static final String PROCESS_ADDITIONAL_DIMENSIONS = "multianewarrayProcessAdditionalDimensionsOp";
    static final int MAX_PCODE_OP_ARGS = 7;

    private ArrayMethods() {
        throw new AssertionError();
    }

    public static void getPcodeForMultiANewArray(PcodeOpEmitter pCode, int constantPoolIndex, AbstractConstantPoolInfoJava[] constantPool, int dimensions) {
        int i;
        for (int i2 = dimensions; i2 >= 1; --i2) {
            String iAsString = Integer.toString(i2);
            pCode.emitPopCat1Value(DIMENSION + iAsString);
        }
        pCode.emitAssignVarnodeFromPcodeOpCall(CLASS_NAME, 4, "cpool", "0", Integer.toString(constantPoolIndex), "12");
        String[] multianewarrayOpArgs = null;
        if (dimensions > 6) {
            multianewarrayOpArgs = new String[7];
            multianewarrayOpArgs[0] = CLASS_NAME;
            for (i = 1; i < 7; ++i) {
                multianewarrayOpArgs[i] = DIMENSION + Integer.toString(i);
            }
        } else {
            multianewarrayOpArgs = new String[dimensions + 1];
            multianewarrayOpArgs[0] = CLASS_NAME;
            for (i = 1; i < dimensions + 1; ++i) {
                multianewarrayOpArgs[i] = DIMENSION + Integer.toString(i);
            }
        }
        pCode.emitAssignVarnodeFromPcodeOpCall(ARRAY_REF, 4, MULTIANEWARRAY, CLASS_NAME, "dim1", "dim2");
        for (i = 7; i <= dimensions; ++i) {
            String[] args = new String[]{ARRAY_REF, DIMENSION + Integer.toString(i)};
            pCode.emitVoidPcodeOpCall(PROCESS_ADDITIONAL_DIMENSIONS, args);
        }
        pCode.emitPushCat1Value(ARRAY_REF);
    }

    public static String getPrimitiveArrayToken(int code) {
        switch (code) {
            case 4: {
                return "boolean";
            }
            case 5: {
                return "char";
            }
            case 6: {
                return "float";
            }
            case 7: {
                return "double";
            }
            case 8: {
                return "byte";
            }
            case 9: {
                return "short";
            }
            case 10: {
                return "int";
            }
            case 11: {
                return "long";
            }
        }
        throw new IllegalArgumentException("Invalid primitive type code: " + code);
    }

    public static DataType getArrayBaseType(int i, DataTypeManager dtManager) {
        String primitiveType = null;
        switch (i) {
            case 4: {
                primitiveType = "Z";
                break;
            }
            case 5: {
                primitiveType = "C";
                break;
            }
            case 6: {
                primitiveType = "F";
                break;
            }
            case 7: {
                primitiveType = "D";
                break;
            }
            case 8: {
                primitiveType = "B";
                break;
            }
            case 9: {
                primitiveType = "S";
                break;
            }
            case 10: {
                primitiveType = "I";
                break;
            }
            case 11: {
                primitiveType = "J";
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid primitive type code: " + i);
            }
        }
        return DescriptorDecoder.getDataTypeOfDescriptor(primitiveType, dtManager);
    }
}

