/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.swift.types;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.swift.SwiftUtils;
import ghidra.app.util.bin.format.swift.types.TargetContextDescriptor;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public final class TargetProtocolDescriptor
extends TargetContextDescriptor {
    private String name;
    private int numRequirementsInSig;
    private int numRequirements;
    private int associatedTypeNames;

    public TargetProtocolDescriptor(BinaryReader reader) throws IOException {
        super(reader);
        this.name = reader.readNext(SwiftUtils::relativeString);
        this.numRequirementsInSig = reader.readNextInt();
        this.numRequirements = reader.readNextInt();
        this.associatedTypeNames = reader.readNextInt();
    }

    public String getName() {
        return this.name;
    }

    public int getNumRequirementsInSignature() {
        return this.numRequirementsInSig;
    }

    public int getNumRequirements() {
        return this.numRequirements;
    }

    public int getAssociatedTypeNames() {
        return this.associatedTypeNames;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public String getStructureName() {
        return TargetProtocolDescriptor.class.getSimpleName();
    }

    @Override
    public String getDescription() {
        return "protocol descriptor";
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(this.getStructureName(), 0);
        struct.add(super.toDataType(), super.getStructureName(), "");
        struct.add((DataType)SwiftUtils.PTR_STRING, "Name", "The name of the protocol");
        struct.add(DWORD, "NumRequirementsInSignature", "The number of generic requirements in the requirement signature of the protocol");
        struct.add(DWORD, "NumRequirements", "The number of requirements in the protocol");
        struct.add(DWORD, "AssociatedTypeNames", "Associated type names, as a space-separated list in the same order as the requirements");
        struct.setCategoryPath(new CategoryPath("/SwiftTypeMetadata"));
        return struct;
    }
}

