/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.script;

import docking.DialogComponentProvider;
import ghidra.app.plugin.core.script.GhidraScriptMgrPlugin;
import ghidra.app.plugin.core.script.ScriptEditorListener;
import ghidra.app.plugin.core.script.ScriptSelectionEditor;
import ghidra.app.script.ScriptInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.util.HelpLocation;
import ghidra.util.Swing;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ScriptSelectionDialog
extends DialogComponentProvider {
    private ScriptSelectionEditor editor;
    private PluginTool tool;
    private List<ScriptInfo> scriptInfos;
    private ScriptInfo userChoice;

    ScriptSelectionDialog(GhidraScriptMgrPlugin plugin, List<ScriptInfo> scriptInfos) {
        super("Run Script", true, true, true, false);
        this.tool = plugin.getTool();
        this.scriptInfos = scriptInfos;
        this.init();
        this.setHelpLocation(new HelpLocation(plugin.getName(), "Script Quick Launch"));
    }

    private void init() {
        this.buildEditor();
        this.addOKButton();
        this.addCancelButton();
    }

    private void buildEditor() {
        this.removeWorkPanel();
        this.editor = new ScriptSelectionEditor(this.scriptInfos);
        this.editor.setConsumeEnterKeyPress(false);
        this.editor.addEditorListener(new ScriptEditorListener(){

            @Override
            public void editingCancelled() {
                if (ScriptSelectionDialog.this.isVisible()) {
                    ScriptSelectionDialog.this.cancelCallback();
                }
            }

            @Override
            public void editingStopped() {
                if (ScriptSelectionDialog.this.isVisible()) {
                    ScriptSelectionDialog.this.okCallback();
                }
            }
        });
        this.editor.addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.textUpdated();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.textUpdated();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.textUpdated();
            }

            private void textUpdated() {
                ScriptSelectionDialog.this.clearStatusText();
            }
        });
        JComponent mainPanel = this.createEditorPanel();
        this.addWorkPanel(mainPanel);
        this.rootPanel.validate();
    }

    private JComponent createEditorPanel() {
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.add((Component)this.editor.getEditorComponent(), "North");
        return mainPanel;
    }

    public void show() {
        this.tool.showDialog((DialogComponentProvider)this);
    }

    public ScriptInfo getUserChoice() {
        return this.userChoice;
    }

    protected void dialogShown() {
        Swing.runLater(() -> this.editor.requestFocus());
    }

    protected void cancelCallback() {
        this.userChoice = null;
        super.cancelCallback();
    }

    protected void okCallback() {
        if (!this.editor.validateUserSelection()) {
            this.setStatusText("Invalid script name");
            return;
        }
        this.userChoice = this.editor.getEditorValue();
        this.clearStatusText();
        this.close();
    }

    public void close() {
        this.buildEditor();
        this.setStatusText("");
        super.close();
    }
}

