/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.eclipse;

import ghidra.app.plugin.core.eclipse.EclipseConnection;
import ghidra.app.services.EclipseIntegrationService;
import ghidra.framework.Application;
import ghidra.util.Msg;
import ghidra.util.task.Task;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;

class EclipseConnectorTask
extends Task {
    private EclipseIntegrationService eclipseService;
    private String address;
    private int port;
    private EclipseConnection connection;

    public EclipseConnectorTask(EclipseIntegrationService eclipseService, int port) {
        super("Eclipse Launcher Task", true, true, true);
        this.eclipseService = eclipseService;
        this.address = "127.0.0.1";
        this.port = port;
        this.connection = new EclipseConnection();
    }

    public void run(TaskMonitor monitor) {
        try {
            this.connection = new EclipseConnection(null, new Socket(this.address, this.port));
            return;
        }
        catch (IOException iOException) {
            File eclipseExecutableFile;
            try {
                eclipseExecutableFile = this.eclipseService.getEclipseExecutableFile();
            }
            catch (FileNotFoundException e1) {
                this.eclipseService.handleEclipseError(e1.getMessage(), true, null);
                try {
                    eclipseExecutableFile = this.eclipseService.getEclipseExecutableFile();
                }
                catch (FileNotFoundException e2) {
                    this.eclipseService.handleEclipseError("Failed to launch Eclipse.  The required Eclipse components have not been configured.", false, null);
                    return;
                }
            }
            if (!this.isGhidraDevInstalled(this.eclipseService)) {
                this.eclipseService.offerGhidraDevInstallation(monitor);
                if (!this.isGhidraDevInstalled(this.eclipseService)) {
                    this.eclipseService.handleEclipseError("Failed to launch Eclipse.  The GhidraDev plugin has not been installed.", false, null);
                    return;
                }
            }
            monitor.setIndeterminate(true);
            monitor.setMessage("Launching Eclipse...");
            Process process = null;
            try {
                ProcessBuilder processBuilder = this.createEclipseProcessBuilder(eclipseExecutableFile, this.eclipseService.getEclipseWorkspaceDir(), this.eclipseService.getEclipseDropinsDir());
                processBuilder.redirectErrorStream(true);
                processBuilder.directory(eclipseExecutableFile.getParentFile());
                process = processBuilder.start();
            }
            catch (Exception e) {
                this.eclipseService.handleEclipseError("Unexpected exception occurred while launching Eclipse.", false, null);
                return;
            }
            int maxWaits = 200;
            monitor.setIndeterminate(false);
            monitor.initialize((long)maxWaits);
            monitor.setMessage("Connecting to Eclipse on port " + this.port + "...");
            for (int i = 0; i < maxWaits; ++i) {
                if (monitor.isCancelled()) {
                    return;
                }
                if (!process.isAlive()) break;
                try {
                    this.connection = new EclipseConnection(process, new Socket(this.address, this.port));
                    return;
                }
                catch (UnknownHostException e) {
                    return;
                }
                catch (IOException iOException2) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    monitor.incrementProgress(1L);
                    continue;
                }
            }
            this.eclipseService.handleEclipseError("Failed to connect to Eclipse on port " + this.port + ".", true, null);
            return;
        }
    }

    public EclipseConnection getConnection() {
        return this.connection;
    }

    private ProcessBuilder createEclipseProcessBuilder(File eclipseExecutableFile, File eclipseWorkspaceDir, File eclipseDropinsDir) {
        ArrayList<String> args = new ArrayList<String>();
        args.add(eclipseExecutableFile.getAbsolutePath());
        if (eclipseWorkspaceDir != null) {
            args.add("-data");
            args.add(eclipseWorkspaceDir.getAbsolutePath());
        }
        args.add("--launcher.appendVmargs");
        args.add("-vmargs");
        args.add("-Dghidra.install.dir=" + String.valueOf(Application.getInstallationDirectory()));
        args.add("-Dorg.eclipse.equinox.p2.reconciler.dropins.directory=" + String.valueOf(eclipseDropinsDir));
        if (Boolean.getBoolean("eclipse.filelock.disable")) {
            Msg.info((Object)((Object)this), (Object)"Disabling Eclipse file locking...");
            args.add("-Dosgi.locking=none");
        }
        return new ProcessBuilder(args);
    }

    private boolean isGhidraDevInstalled(EclipseIntegrationService service) {
        try {
            return this.eclipseService.isEclipseFeatureInstalled((dir, filename) -> filename.contains("ghidradev"));
        }
        catch (FileNotFoundException e) {
            return false;
        }
    }
}

