/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.analysis;

import ghidra.app.plugin.core.analysis.AnalysisScheduler;
import ghidra.app.plugin.core.analysis.AutoAnalysisManager;
import ghidra.app.services.Analyzer;
import ghidra.framework.options.Options;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class AnalysisTaskList {
    private List<AnalysisScheduler> tasks = new CopyOnWriteArrayList<AnalysisScheduler>();
    private AutoAnalysisManager analysisMgr;
    private String name;
    private static Comparator<AnalysisScheduler> priorityComparator = new Comparator<AnalysisScheduler>(){

        @Override
        public int compare(AnalysisScheduler as1, AnalysisScheduler as2) {
            Analyzer a1 = as1.getAnalyzer();
            Analyzer a2 = as2.getAnalyzer();
            int c = a1.getPriority().priority() - a2.getPriority().priority();
            if (c == 0) {
                c = a1.getName().compareTo(a2.getName());
            }
            return c;
        }
    };

    public AnalysisTaskList(AutoAnalysisManager analysisMgr, String name) {
        this.analysisMgr = analysisMgr;
        this.name = name;
    }

    public void clear() {
        this.tasks.clear();
    }

    public Iterator<AnalysisScheduler> iterator() {
        return this.tasks.iterator();
    }

    public void add(Analyzer analyzer) {
        AnalysisScheduler myScheduler = new AnalysisScheduler(this.analysisMgr, analyzer);
        int index = Collections.binarySearch(this.tasks, myScheduler, priorityComparator);
        if (index < 0) {
            index = -index - 1;
        }
        this.tasks.add(index, myScheduler);
    }

    public void notifyResume() {
        for (AnalysisScheduler scheduler : this.tasks) {
            scheduler.schedule();
        }
    }

    public void notifyAdded(Address addr) {
        for (AnalysisScheduler scheduler : this.tasks) {
            scheduler.added(addr);
        }
    }

    public void notifyAdded(AddressSetView set) {
        for (AnalysisScheduler scheduler : this.tasks) {
            scheduler.added(set);
        }
    }

    public void notifyRemoved(AddressSetView set) {
        for (AnalysisScheduler scheduler : this.tasks) {
            scheduler.removed(set);
        }
    }

    public void notifyRemoved(Address addr) {
        for (AnalysisScheduler scheduler : this.tasks) {
            scheduler.removed(addr);
        }
    }

    public void optionsChanged(Options options) {
        for (AnalysisScheduler scheduler : this.tasks) {
            scheduler.optionsChanged(options);
        }
    }

    public void registerOptions(Options options) {
        for (AnalysisScheduler scheduler : this.tasks) {
            scheduler.registerOptions(options);
        }
    }

    public void notifyAnalysisEnded(Program program) {
        for (AnalysisScheduler scheduler : this.tasks) {
            scheduler.getAnalyzer().analysisEnded(program);
        }
    }
}

