/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.coff;

import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.format.coff.archive.CoffArchiveConstants;
import ghidra.file.formats.coff.CoffArchiveFileSystem;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.FSRLRoot;
import ghidra.formats.gfilesystem.FileSystemService;
import ghidra.formats.gfilesystem.factory.GFileSystemFactoryByteProvider;
import ghidra.formats.gfilesystem.factory.GFileSystemProbeBytesOnly;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.Arrays;

public class CoffArchiveFileSystemFactory
implements GFileSystemFactoryByteProvider<CoffArchiveFileSystem>,
GFileSystemProbeBytesOnly {
    public static final int PROBE_BYTES_REQUIRED = CoffArchiveConstants.MAGIC_LEN;

    public CoffArchiveFileSystem create(FSRLRoot targetFSRL, ByteProvider byteProvider, FileSystemService fsService, TaskMonitor monitor) throws IOException, CancelledException {
        CoffArchiveFileSystem fs = new CoffArchiveFileSystem(targetFSRL, byteProvider);
        fs.mount(monitor);
        return fs;
    }

    public int getBytesRequired() {
        return PROBE_BYTES_REQUIRED;
    }

    public boolean probeStartBytes(FSRL containerFSRL, byte[] startBytes) {
        return Arrays.equals(CoffArchiveConstants.MAGIC_BYTES, 0, CoffArchiveConstants.MAGIC_BYTES.length, startBytes, 0, CoffArchiveConstants.MAGIC_BYTES.length);
    }
}

