/*
 * Decompiled with CFR 0.152.
 */
package generic.concurrent;

import generic.util.NamedDaemonThreadFactory;
import ghidra.util.SystemUtilities;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class GThreadPool {
    private static final long DEFAULT_KEEP_ALIVE = 15L;
    private static Map<String, GThreadPool> sharedPoolMap = new HashMap<String, GThreadPool>();
    private final String name;
    private final GThreadPoolExecutor executor;

    public static GThreadPool getPrivateThreadPool(String name) {
        return new GThreadPool(name);
    }

    public static GThreadPool getSharedThreadPool(String name) {
        GThreadPool threadPool = sharedPoolMap.get(name);
        if (threadPool == null) {
            threadPool = new GThreadPool(name);
        }
        return threadPool;
    }

    public static CompletableFuture<Void> runAsync(String poolName, Runnable r) {
        GThreadPool pool = GThreadPool.getSharedThreadPool(poolName);
        Executor ex = pool.getExecutor();
        return CompletableFuture.runAsync(r, ex);
    }

    private GThreadPool(String name) {
        this.name = name;
        this.executor = new GThreadPoolExecutor();
        sharedPoolMap.put(name, this);
    }

    public void setMaxThreadCount(int maxThreadCount) {
        this.executor.setMaxThreadCount(maxThreadCount);
    }

    public int getMinThreadCount() {
        return this.executor.getMinThreadCount();
    }

    public void setMinThreadCount(int minThreadCount) {
        this.executor.setMinThreadCount(minThreadCount);
    }

    public int getMaxThreadCount() {
        return this.executor.getMaxThreadCount();
    }

    public void submit(FutureTask<?> futureTask) {
        this.executor.execute(futureTask);
    }

    public Future<?> submit(Runnable task) {
        return this.executor.submit(task);
    }

    public <T> Future<T> submit(Runnable task, T result) {
        return this.executor.submit(task, result);
    }

    public <T> Future<T> submit(Callable<T> task) {
        return this.executor.submit(task);
    }

    public void shutdownNow() {
        this.executor.shutdownNow();
    }

    public boolean isPrivate() {
        return !sharedPoolMap.containsKey(this.name);
    }

    public Executor getExecutor() {
        return this.executor;
    }

    private class GThreadPoolExecutor
    extends ThreadPoolExecutor {
        private volatile int maxThreadCount;
        private volatile int minThreadCount;
        private AtomicInteger taskCount;

        public GThreadPoolExecutor() {
            super(0, Integer.MAX_VALUE, 15L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new NamedDaemonThreadFactory(GThreadPool.this.name));
            this.maxThreadCount = SystemUtilities.getDefaultThreadPoolSize();
            this.minThreadCount = 0;
            this.taskCount = new AtomicInteger();
        }

        public int getMinThreadCount() {
            return this.minThreadCount;
        }

        public void setMinThreadCount(int minThreadCount) {
            this.minThreadCount = Math.max(minThreadCount, 0);
        }

        public int getMaxThreadCount() {
            return this.maxThreadCount;
        }

        public void setMaxThreadCount(int maxThreadCount) {
            this.maxThreadCount = Math.max(maxThreadCount, 1);
        }

        @Override
        public void execute(Runnable command) {
            this.growPoolIfNeeded();
            super.execute(command);
        }

        private void growPoolIfNeeded() {
            int count = this.taskCount.incrementAndGet();
            int corePoolSize = this.getCorePoolSize();
            if (corePoolSize >= this.maxThreadCount) {
                return;
            }
            if (this.isCurrentThreadInThisThreadPool()) {
                --count;
            }
            if (count > corePoolSize) {
                this.setCorePoolSize(corePoolSize + 1);
            }
        }

        private boolean isCurrentThreadInThisThreadPool() {
            return Thread.currentThread().getName().startsWith(GThreadPool.this.name);
        }

        private void shrinkPoolIfNotBusy() {
            int count = this.taskCount.decrementAndGet();
            int corePoolSize = this.getCorePoolSize();
            if (corePoolSize <= this.minThreadCount) {
                return;
            }
            if (count < corePoolSize) {
                this.setCorePoolSize(corePoolSize - 1);
            }
        }

        @Override
        protected void afterExecute(Runnable r, Throwable t) {
            this.shrinkPoolIfNotBusy();
            super.afterExecute(r, t);
        }
    }
}

