/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.data.exceptionhandling;

public class EHCatchHandlerTypeModifier {
    public static final EHCatchHandlerTypeModifier NO_MODIFIERS = new EHCatchHandlerTypeModifier(0);
    private static int CONST_BIT = 1;
    private static int VOLATILE_BIT = 2;
    private static int UNALIGNED_BIT = 4;
    private static int REFERENCE_BIT = 8;
    private static int RESUMABLE_BIT = 16;
    private static int ALL_CATCH_BIT = 64;
    private static int COMPLUS_BIT = Integer.MIN_VALUE;
    private int modifiers;

    public EHCatchHandlerTypeModifier(int modifiers) {
        this.modifiers = modifiers;
    }

    private boolean isBitSet(int bitToCheck) {
        return (this.modifiers & bitToCheck) == bitToCheck;
    }

    public boolean isConst() {
        return this.isBitSet(CONST_BIT);
    }

    public boolean isVolatile() {
        return this.isBitSet(VOLATILE_BIT);
    }

    public boolean isUnaligned() {
        return this.isBitSet(UNALIGNED_BIT);
    }

    public boolean isByReference() {
        return this.isBitSet(REFERENCE_BIT);
    }

    public boolean isResumable() {
        return this.isBitSet(RESUMABLE_BIT);
    }

    public boolean isAllCatch() {
        return this.isBitSet(ALL_CATCH_BIT);
    }

    public boolean isComplus() {
        return this.isBitSet(COMPLUS_BIT);
    }

    public int hashCode() {
        return this.modifiers;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EHCatchHandlerTypeModifier other = (EHCatchHandlerTypeModifier)obj;
        return this.modifiers == other.modifiers;
    }
}

