/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfsexplorer.types.hfsplus;

import java.io.PrintStream;
import org.catacombae.hfsexplorer.Util;
import org.catacombae.hfsexplorer.types.hfsplus.BTHeaderRec;
import org.catacombae.hfsexplorer.types.hfsplus.HFSPlusCatalogFile;
import org.catacombae.hfsexplorer.types.hfsplus.HFSPlusCatalogFolder;
import org.catacombae.hfsexplorer.types.hfsplus.HFSPlusCatalogKey;
import org.catacombae.hfsexplorer.types.hfsplus.HFSPlusCatalogLeafRecordData;
import org.catacombae.hfsexplorer.types.hfsplus.HFSPlusCatalogThread;
import org.catacombae.hfsexplorer.types.hfsx.HFSXCatalogKey;

public class HFSPlusCatalogLeafRecord {
    public static final int HFS_PLUS_FOLDER_RECORD = 1;
    public static final int HFS_PLUS_FILE_RECORD = 2;
    public static final int HFS_PLUS_FOLDER_THREAD_RECORD = 3;
    public static final int HFS_PLUS_FILE_THREAD_RECORD = 4;
    protected final HFSPlusCatalogKey key;
    protected final HFSPlusCatalogLeafRecordData recordData;

    public HFSPlusCatalogLeafRecord(byte[] data, int offset) {
        this(data, offset, null);
    }

    protected HFSPlusCatalogLeafRecord(byte[] data, int offset, BTHeaderRec catalogHeaderRec) {
        this.key = catalogHeaderRec == null ? new HFSPlusCatalogKey(data, offset) : new HFSXCatalogKey(data, offset, catalogHeaderRec);
        short recordType = Util.readShortBE(data, offset + this.key.length());
        if (recordType == 1) {
            this.recordData = new HFSPlusCatalogFolder(data, offset + this.key.length());
        } else if (recordType == 2) {
            this.recordData = new HFSPlusCatalogFile(data, offset + this.key.length());
        } else if (recordType == 3) {
            this.recordData = new HFSPlusCatalogThread(data, offset + this.key.length());
        } else if (recordType == 4) {
            this.recordData = new HFSPlusCatalogThread(data, offset + this.key.length());
        } else {
            throw new RuntimeException("Ivalid record type!");
        }
    }

    public HFSPlusCatalogKey getKey() {
        return this.key;
    }

    public HFSPlusCatalogLeafRecordData getData() {
        return this.recordData;
    }

    public void printFields(PrintStream ps, String prefix) {
        ps.println(prefix + " key:");
        this.key.printFields(ps, prefix + "  ");
        ps.println(prefix + " recordData:");
        this.recordData.printFields(ps, prefix + "  ");
    }

    public void print(PrintStream ps, String prefix) {
        ps.println(prefix + "HFSPlusCatalogLeafRecord:");
        this.printFields(ps, prefix);
    }
}

