/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.jit.analysis;

import ghidra.pcode.emu.jit.analysis.JitDataFlowModel;
import ghidra.pcode.emu.jit.analysis.JitType;
import ghidra.pcode.emu.jit.analysis.JitTypeBehavior;
import ghidra.pcode.emu.jit.op.JitDefOp;
import ghidra.pcode.emu.jit.op.JitOp;
import ghidra.pcode.emu.jit.var.JitOutVar;
import ghidra.pcode.emu.jit.var.JitVal;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.SequencedSet;
import java.util.Set;

public class JitTypeModel {
    private final JitDataFlowModel dfm;
    private final SequencedSet<JitVal> queue = new LinkedHashSet<JitVal>();
    private final Map<JitVal, JitTypeBehavior> assignments = new HashMap<JitVal, JitTypeBehavior>();

    public JitTypeModel(JitDataFlowModel dfm) {
        this.dfm = dfm;
        this.analyze();
    }

    protected JitTypeBehavior computeNewAssignment(JitVal v) {
        Contest contest = new Contest();
        for (JitVal.ValUse use : v.uses()) {
            Object object;
            JitTypeBehavior type = use.type();
            if (type == JitTypeBehavior.COPY && (object = use.op()) instanceof JitDefOp) {
                JitDefOp def = (JitDefOp)object;
                JitOutVar downstream = def.out();
                type = this.assignments.get(downstream);
            }
            contest.vote(type);
        }
        if (v instanceof JitOutVar) {
            JitOutVar out = (JitOutVar)v;
            JitTypeBehavior defType = JitTypeBehavior.ANY;
            JitDefOp def = out.definition();
            defType = def.type();
            if (defType == JitTypeBehavior.COPY) {
                Contest subContest = new Contest();
                for (JitVal upstream : def.inputs()) {
                    subContest.vote(this.assignments.get(upstream));
                }
                defType = subContest.winner();
            }
            contest.vote(defType);
        }
        return contest.winner();
    }

    protected void queueNeighbors(JitVal v) {
        JitOutVar out;
        JitDefOp def;
        for (JitVal.ValUse use : v.uses()) {
            JitOp jitOp;
            JitTypeBehavior type = use.type();
            if (type != JitTypeBehavior.COPY || !((jitOp = use.op()) instanceof JitDefOp)) continue;
            JitDefOp def2 = (JitDefOp)jitOp;
            this.queue.add(def2.out());
        }
        if (v instanceof JitOutVar && (def = (out = (JitOutVar)v).definition()).type() == JitTypeBehavior.COPY) {
            this.queue.addAll(def.inputs());
        }
    }

    protected void analyze() {
        Set<JitVal> vals = this.dfm.allValues();
        this.queue.addAll(vals);
        for (JitVal v : vals) {
            this.assignments.put(v, JitTypeBehavior.ANY);
        }
        while (!this.queue.isEmpty()) {
            JitTypeBehavior type;
            JitVal v = (JitVal)this.queue.removeFirst();
            JitTypeBehavior old = this.assignments.put(v, type = this.computeNewAssignment(v));
            if (old == type) continue;
            this.queueNeighbors(v);
        }
    }

    public JitType typeOf(JitVal v) {
        return this.assignments.get(v).type(v.size());
    }

    protected record Contest(Map<JitTypeBehavior, Integer> counts) {
        public Contest() {
            this(new HashMap<JitTypeBehavior, Integer>());
        }

        private void vote(JitTypeBehavior candidate, int c) {
            if (candidate == JitTypeBehavior.ANY || candidate == JitTypeBehavior.COPY) {
                return;
            }
            this.counts.compute(candidate, (k, v) -> v == null ? c : v + c);
        }

        public void vote(JitTypeBehavior candidate) {
            this.vote(candidate, 1);
        }

        public static int compareCandidateEntries(Map.Entry<JitTypeBehavior, Integer> ent1, Map.Entry<JitTypeBehavior, Integer> ent2) {
            int c = Integer.compare(ent1.getValue(), ent2.getValue());
            if (c != 0) {
                return c;
            }
            c = JitTypeBehavior.compare(ent1.getKey(), ent2.getKey());
            if (c != 0) {
                return -c;
            }
            return 0;
        }

        public JitTypeBehavior winner() {
            return this.counts.entrySet().stream().max(Contest::compareCandidateEntries).map(Map.Entry::getKey).orElse(JitTypeBehavior.ANY);
        }
    }
}

