/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.wizard.session;

import docking.widgets.button.BrowseButton;
import docking.widgets.label.GDLabel;
import generic.theme.GIcon;
import generic.theme.Gui;
import ghidra.feature.vt.gui.wizard.session.VTWizardUtils;
import ghidra.framework.main.DataTreeDialog;
import ghidra.framework.main.DataTreeDialogType;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFolder;
import ghidra.util.StringUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.commons.lang3.StringUtils;
import utility.function.Callback;

public class SessionConfigurationPanel
extends JPanel {
    private static final int VTSESSION_NAME_PROGRAM_NAME_MAX_LENGTH = 28;
    private static final int TEXT_FIELD_LENGTH = 40;
    private static final Icon SWAP_ICON = new GIcon("icon.version.tracking.new.session.swap");
    private static final Icon INFO_ICON = new GIcon("icon.version.tracking.new.session.info");
    private JTextField sourceField;
    private JTextField destinationField;
    private JButton sourceBrowseButton;
    private JButton destinationBrowseButton;
    private JButton swapProgramsButton;
    private JTextField sessionNameField;
    private JTextField folderNameField;
    private DomainFile sourceFile;
    private DomainFile destinationFile;
    private DomainFolder sessionFolder;
    private Callback statusChangedCallback;

    SessionConfigurationPanel(final Callback statusChangedCallback) {
        this.statusChangedCallback = statusChangedCallback;
        this.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        GDLabel folderLabel = new GDLabel("Project folder ");
        folderLabel.setHorizontalAlignment(4);
        folderLabel.setToolTipText("The folder to store the new Version Tracking Session");
        this.folderNameField = new JTextField();
        Gui.registerFont((Component)this.folderNameField, (String)"font.monospaced");
        this.folderNameField.setEditable(false);
        BrowseButton browseFolderButton = new BrowseButton();
        browseFolderButton.addActionListener(e -> this.browseDataTreeFolders());
        GDLabel newSessionLabel = new GDLabel("New Session Name: ");
        newSessionLabel.setToolTipText("The name for the new Version Tracking Session");
        newSessionLabel.setHorizontalAlignment(4);
        this.sessionNameField = new JTextField(40);
        this.sessionNameField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                statusChangedCallback.call();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                statusChangedCallback.call();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                statusChangedCallback.call();
            }
        });
        GDLabel sourceLabel = new GDLabel("Source Program: ");
        sourceLabel.setIcon(INFO_ICON);
        sourceLabel.setToolTipText("Analyzed program with markup to transfer");
        sourceLabel.setHorizontalAlignment(4);
        GDLabel destinationLabel = new GDLabel("Destination Program: ");
        destinationLabel.setIcon(INFO_ICON);
        destinationLabel.setToolTipText("New program that receives the transferred markup");
        destinationLabel.setHorizontalAlignment(4);
        this.sourceField = new JTextField(40);
        this.sourceField.setEditable(false);
        this.destinationField = new JTextField(40);
        this.destinationField.setEditable(false);
        this.sourceBrowseButton = this.createSourceBrowseButton();
        this.destinationBrowseButton = this.createDestinationBrowseButton();
        this.swapProgramsButton = new JButton(SWAP_ICON);
        this.swapProgramsButton.setText("swap");
        this.swapProgramsButton.setName("SWAP_BUTTON");
        this.swapProgramsButton.addActionListener(arg0 -> this.swapPrograms());
        JPanel mainPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        mainPanel.add(Box.createVerticalStrut(15), gbc);
        ++gbc.gridy;
        gbc.fill = 2;
        mainPanel.add((Component)folderLabel, gbc);
        ++gbc.gridx;
        mainPanel.add((Component)this.folderNameField, gbc);
        ++gbc.gridx;
        mainPanel.add(Box.createHorizontalStrut(5), gbc);
        ++gbc.gridx;
        mainPanel.add((Component)browseFolderButton, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        mainPanel.add(Box.createVerticalStrut(10), gbc);
        ++gbc.gridy;
        gbc.fill = 2;
        mainPanel.add((Component)newSessionLabel, gbc);
        ++gbc.gridx;
        mainPanel.add((Component)this.sessionNameField, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        mainPanel.add(Box.createVerticalStrut(15), gbc);
        ++gbc.gridy;
        gbc.gridwidth = 4;
        mainPanel.add((Component)new JSeparator(), gbc);
        ++gbc.gridy;
        gbc.gridwidth = 1;
        mainPanel.add(Box.createVerticalStrut(25), gbc);
        ++gbc.gridy;
        mainPanel.add((Component)sourceLabel, gbc);
        ++gbc.gridx;
        mainPanel.add((Component)this.sourceField, gbc);
        gbc.gridx += 2;
        mainPanel.add((Component)this.sourceBrowseButton, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.fill = 0;
        gbc.gridwidth = 4;
        mainPanel.add((Component)this.swapProgramsButton, gbc);
        gbc.gridwidth = 1;
        ++gbc.gridy;
        gbc.fill = 2;
        mainPanel.add((Component)destinationLabel, gbc);
        ++gbc.gridx;
        mainPanel.add((Component)this.destinationField, gbc);
        gbc.gridx += 2;
        mainPanel.add((Component)this.destinationBrowseButton, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        mainPanel.add(Box.createVerticalStrut(25), gbc);
        ++gbc.gridy;
        gbc.gridwidth = 4;
        mainPanel.add((Component)new JSeparator(), gbc);
        ++gbc.gridy;
        gbc.gridwidth = 1;
        mainPanel.add(Box.createVerticalStrut(60), gbc);
        this.setLayout(new BorderLayout());
        this.add((Component)mainPanel, "North");
    }

    public void setDestinationFile(DomainFile file) {
        this.destinationFile = file;
        if (this.destinationFile != null) {
            this.destinationField.setText(this.destinationFile.getPathname());
        } else {
            this.destinationField.setText("");
        }
        this.updateSessionNameIfBlank();
    }

    public void setSourceFile(DomainFile file) {
        this.sourceFile = file;
        if (this.sourceFile != null) {
            this.sourceField.setText(this.sourceFile.getPathname());
        } else {
            this.sourceField.setText("");
        }
        this.updateSessionNameIfBlank();
    }

    private JButton createSourceBrowseButton() {
        BrowseButton button = new BrowseButton();
        button.setName("SOURCE_BUTTON");
        button.addActionListener(e -> {
            DomainFile programFile = VTWizardUtils.chooseDomainFile(this, "a source program", VTWizardUtils.PROGRAM_FILTER, null);
            if (programFile != null) {
                this.setSourceFile(programFile);
                this.statusChangedCallback.call();
            }
        });
        return button;
    }

    private JButton createDestinationBrowseButton() {
        BrowseButton button = new BrowseButton();
        button.setName("DESTINATION_BUTTON");
        button.addActionListener(e -> {
            DomainFile programFile = VTWizardUtils.chooseDomainFile(this, "a destination program", VTWizardUtils.PROGRAM_FILTER, null);
            if (programFile != null) {
                this.setDestinationFile(programFile);
                this.statusChangedCallback.call();
            }
        });
        return button;
    }

    private void browseDataTreeFolders() {
        DataTreeDialog dataTreeDialog = new DataTreeDialog((Component)this, "Choose a project folder", DataTreeDialogType.CHOOSE_FOLDER);
        dataTreeDialog.addOkActionListener(e -> {
            dataTreeDialog.close();
            this.sessionFolder = dataTreeDialog.getDomainFolder();
            this.folderNameField.setText(this.sessionFolder.toString());
            this.statusChangedCallback.call();
        });
        dataTreeDialog.showComponent();
    }

    private void swapPrograms() {
        DomainFile newSourceFile = this.destinationFile;
        DomainFile newDestionationFile = this.sourceFile;
        this.setSourceFile(newSourceFile);
        this.setDestinationFile(newDestionationFile);
        this.statusChangedCallback.call();
    }

    public DomainFolder getSessionFolder() {
        return this.sessionFolder;
    }

    public String getSessionName() {
        return this.sessionNameField.getText().trim();
    }

    public DomainFile getSourceFile() {
        return this.sourceFile;
    }

    public DomainFile getDestinationFile() {
        return this.destinationFile;
    }

    private void updateSessionNameIfBlank() {
        if (!StringUtils.isBlank((CharSequence)this.sessionNameField.getText())) {
            return;
        }
        if (this.sourceFile == null || this.destinationFile == null || this.sourceFile == this.destinationFile) {
            return;
        }
        String defaultSessionName = this.createVTSessionName(this.sourceFile.getName(), this.destinationFile.getName());
        this.sessionNameField.setText(defaultSessionName);
    }

    private String createVTSessionName(String sourceName, String destinationName) {
        if (sourceName.length() + destinationName.length() <= 56) {
            return "VT_" + sourceName + "_" + destinationName;
        }
        if (sourceName.length() < 28) {
            int leftover = 28 - sourceName.length();
            destinationName = StringUtilities.trimMiddle((String)destinationName, (int)(28 + leftover));
            return "VT_" + sourceName + "_" + destinationName;
        }
        if (destinationName.length() < 28) {
            int leftover = 28 - destinationName.length();
            sourceName = StringUtilities.trimMiddle((String)sourceName, (int)(28 + leftover));
            return "VT_" + sourceName + "_" + destinationName;
        }
        sourceName = StringUtilities.trimMiddle((String)sourceName, (int)28);
        destinationName = StringUtilities.trimMiddle((String)destinationName, (int)28);
        return "VT_" + sourceName + "_" + destinationName;
    }

    public void setSessionFolder(DomainFolder folder) {
        this.sessionFolder = folder;
        this.folderNameField.setText(this.sessionFolder.toString());
    }
}

