/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.filters;

import docking.ReusableDialogComponentProvider;
import ghidra.feature.vt.gui.filters.AncillaryFilter;
import ghidra.feature.vt.gui.filters.Filter;
import ghidra.feature.vt.gui.filters.FilterChangedListener;
import ghidra.feature.vt.gui.filters.FilterDialogModel;
import ghidra.feature.vt.gui.filters.FilterState;
import ghidra.feature.vt.gui.plugin.VTController;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;

public abstract class AncillaryFilterDialogComponentProvider<T>
extends ReusableDialogComponentProvider {
    private FilterChangedListener filterChangedListener;
    private Set<AncillaryFilter<T>> ancillaryFilters = new HashSet<AncillaryFilter<T>>();
    private Map<AncillaryFilter<T>, FilterState> originalState = new HashMap<AncillaryFilter<T>, FilterState>();
    protected final VTController controller;
    private final FilterDialogModel<T> dialogModel;
    private Boolean isFiltered;

    protected AncillaryFilterDialogComponentProvider(VTController controller, String title, FilterDialogModel<T> dialogModel) {
        super(title);
        this.controller = controller;
        this.dialogModel = dialogModel;
        this.filterChangedListener = state -> this.stateChanged(state);
        this.addWorkPanel(this.buildWorkPanel());
        this.addApplyButton();
        this.addOKButton();
        this.addCancelButton();
        this.applyButton.setToolTipText("Apply any filter changes");
        this.okButton.setToolTipText("Apply any filter changes and close the dialog");
        this.cancelButton.setToolTipText("Undo any changes and close the dialog");
        this.updateButtons(false);
    }

    public boolean isFiltered() {
        if (this.isFiltered != null) {
            return this.isFiltered;
        }
        this.isFiltered = Boolean.FALSE;
        for (Filter filter : this.ancillaryFilters) {
            Filter.FilterShortcutState state = filter.getFilterShortcutState();
            if (state == Filter.FilterShortcutState.ALWAYS_PASSES) continue;
            this.isFiltered = Boolean.TRUE;
        }
        return this.isFiltered;
    }

    public void close() {
        super.close();
        this.originalState.clear();
        this.dialogModel.dialogVisibilityChanged(false);
        this.updateButtons(false);
    }

    protected void dialogShown() {
        this.dialogModel.dialogVisibilityChanged(true);
        this.originalState = this.getCurrentState();
        this.isFiltered = null;
    }

    protected void cancelCallback() {
        this.applyState(this.originalState);
        this.close();
    }

    protected void okCallback() {
        this.applyState(this.getCurrentState());
        this.close();
    }

    protected void applyCallback() {
        this.applyState(this.getCurrentState());
        this.updateButtons(false);
        this.dialogModel.forceRefilter();
        this.originalState = this.getCurrentState();
    }

    private void applyState(Map<AncillaryFilter<T>, FilterState> state) {
        for (Map.Entry<AncillaryFilter<T>, FilterState> entry : state.entrySet()) {
            AncillaryFilter<T> filter = entry.getKey();
            FilterState filterState = entry.getValue();
            filter.restoreFilterState(filterState);
        }
    }

    private void stateChanged(FilterState state) {
        boolean hasChanges = this.hasStateChanged(state);
        this.updateButtons(hasChanges);
    }

    private void updateButtons(boolean hasChanges) {
        this.applyButton.setEnabled(hasChanges);
        this.cancelButton.setEnabled(hasChanges);
    }

    private boolean hasStateChanged(FilterState state) {
        FilterState oldState = this.originalState.get(state.getFilter());
        if (oldState == null) {
            return false;
        }
        return !oldState.equals(state);
    }

    private Map<AncillaryFilter<T>, FilterState> getCurrentState() {
        HashMap<AncillaryFilter<T>, FilterState> state = new HashMap<AncillaryFilter<T>, FilterState>();
        for (AncillaryFilter<T> filter : this.ancillaryFilters) {
            state.put(filter, filter.getFilterState());
        }
        return state;
    }

    private JComponent buildWorkPanel() {
        return this.buildFilterPanel();
    }

    protected abstract JComponent buildFilterPanel();

    protected void addFilter(AncillaryFilter<T> filter) {
        filter.addFilterChangedListener(this.filterChangedListener);
        this.ancillaryFilters.add(filter);
        this.dialogModel.addFilter(filter);
    }
}

